/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.StringRanges;
import org.apache.juneau.Version;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.http.header.AcceptCharset;
import org.apache.juneau.http.header.AcceptEncoding;
import org.apache.juneau.http.header.AcceptLanguage;
import org.apache.juneau.http.header.AcceptRanges;
import org.apache.juneau.http.header.Age;
import org.apache.juneau.http.header.Allow;
import org.apache.juneau.http.header.Authorization;
import org.apache.juneau.http.header.BasicBooleanHeader;
import org.apache.juneau.http.header.BasicCsvHeader;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.http.header.BasicEntityTagHeader;
import org.apache.juneau.http.header.BasicEntityTagsHeader;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.BasicIntegerHeader;
import org.apache.juneau.http.header.BasicLongHeader;
import org.apache.juneau.http.header.BasicMediaRangesHeader;
import org.apache.juneau.http.header.BasicMediaTypeHeader;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.header.BasicStringRangesHeader;
import org.apache.juneau.http.header.BasicUriHeader;
import org.apache.juneau.http.header.CacheControl;
import org.apache.juneau.http.header.ClientVersion;
import org.apache.juneau.http.header.Connection;
import org.apache.juneau.http.header.ContentDisposition;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentLanguage;
import org.apache.juneau.http.header.ContentLength;
import org.apache.juneau.http.header.ContentLocation;
import org.apache.juneau.http.header.ContentRange;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.Date;
import org.apache.juneau.http.header.Debug;
import org.apache.juneau.http.header.ETag;
import org.apache.juneau.http.header.EntityTag;
import org.apache.juneau.http.header.EntityTags;
import org.apache.juneau.http.header.Expect;
import org.apache.juneau.http.header.Expires;
import org.apache.juneau.http.header.Forwarded;
import org.apache.juneau.http.header.From;
import org.apache.juneau.http.header.HeaderBeanMeta;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.Headerable;
import org.apache.juneau.http.header.Host;
import org.apache.juneau.http.header.IfMatch;
import org.apache.juneau.http.header.IfModifiedSince;
import org.apache.juneau.http.header.IfNoneMatch;
import org.apache.juneau.http.header.IfRange;
import org.apache.juneau.http.header.IfUnmodifiedSince;
import org.apache.juneau.http.header.LastModified;
import org.apache.juneau.http.header.Location;
import org.apache.juneau.http.header.MaxForwards;
import org.apache.juneau.http.header.NoTrace;
import org.apache.juneau.http.header.Origin;
import org.apache.juneau.http.header.Pragma;
import org.apache.juneau.http.header.ProxyAuthenticate;
import org.apache.juneau.http.header.ProxyAuthorization;
import org.apache.juneau.http.header.Range;
import org.apache.juneau.http.header.Referer;
import org.apache.juneau.http.header.RetryAfter;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.header.Server;
import org.apache.juneau.http.header.TE;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.header.Trailer;
import org.apache.juneau.http.header.TransferEncoding;
import org.apache.juneau.http.header.Upgrade;
import org.apache.juneau.http.header.UserAgent;
import org.apache.juneau.http.header.Vary;
import org.apache.juneau.http.header.Via;
import org.apache.juneau.http.header.Warning;
import org.apache.juneau.http.header.WwwAuthenticate;
import org.apache.juneau.http.part.NameValuePairable;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.reflect.ClassInfo;

public class HttpHeaders {
    public static final Accept ACCEPT_APPLICATION_ATOM_XML = Accept.APPLICATION_ATOM_XML;
    public static final Accept ACCEPT_APPLICATION_FORM_URLENCODED = Accept.APPLICATION_FORM_URLENCODED;
    public static final Accept ACCEPT_APPLICATION_JSON = Accept.APPLICATION_JSON;
    public static final Accept ACCEPT_APPLICATION_OCTET_STREAM = Accept.APPLICATION_OCTET_STREAM;
    public static final Accept ACCEPT_APPLICATION_SOAP_XML = Accept.APPLICATION_SOAP_XML;
    public static final Accept ACCEPT_APPLICATION_SVG_XML = Accept.APPLICATION_SVG_XML;
    public static final Accept ACCEPT_APPLICATION_XHTML_XML = Accept.APPLICATION_XHTML_XML;
    public static final Accept ACCEPT_APPLICATION_XML = Accept.APPLICATION_XML;
    public static final Accept ACCEPT_IMAGE_BMP = Accept.IMAGE_BMP;
    public static final Accept ACCEPT_IMAGE_GIF = Accept.IMAGE_GIF;
    public static final Accept ACCEPT_IMAGE_JPEG = Accept.IMAGE_JPEG;
    public static final Accept ACCEPT_IMAGE_PNG = Accept.IMAGE_PNG;
    public static final Accept ACCEPT_IMAGE_SVG = Accept.IMAGE_SVG;
    public static final Accept ACCEPT_IMAGE_TIFF = Accept.IMAGE_TIFF;
    public static final Accept ACCEPT_IMAGE_WEBP = Accept.IMAGE_WEBP;
    public static final Accept ACCEPT_MULTIPART_FORM_DATA = Accept.MULTIPART_FORM_DATA;
    public static final Accept ACCEPT_TEXT_HTML = Accept.TEXT_HTML;
    public static final Accept ACCEPT_TEXT_PLAIN = Accept.TEXT_PLAIN;
    public static final Accept ACCEPT_TEXT_XML = Accept.TEXT_XML;
    public static final Accept ACCEPT_WILDCARD = Accept.WILDCARD;
    public static final ContentType CONTENTTYPE_APPLICATION_ATOM_XML = ContentType.APPLICATION_ATOM_XML;
    public static final ContentType CONTENTTYPE_APPLICATION_FORM_URLENCODED = ContentType.APPLICATION_FORM_URLENCODED;
    public static final ContentType CONTENTTYPE_APPLICATION_JSON = ContentType.APPLICATION_JSON;
    public static final ContentType CONTENTTYPE_APPLICATION_OCTET_STREAM = ContentType.APPLICATION_OCTET_STREAM;
    public static final ContentType CONTENTTYPE_APPLICATION_SOAP_XML = ContentType.APPLICATION_SOAP_XML;
    public static final ContentType CONTENTTYPE_APPLICATION_SVG_XML = ContentType.APPLICATION_SVG_XML;
    public static final ContentType CONTENTTYPE_APPLICATION_XHTML_XML = ContentType.APPLICATION_XHTML_XML;
    public static final ContentType CONTENTTYPE_APPLICATION_XML = ContentType.APPLICATION_XML;
    public static final ContentType CONTENTTYPE_IMAGE_BMP = ContentType.IMAGE_BMP;
    public static final ContentType CONTENTTYPE_IMAGE_GIF = ContentType.IMAGE_GIF;
    public static final ContentType CONTENTTYPE_IMAGE_JPEG = ContentType.IMAGE_JPEG;
    public static final ContentType CONTENTTYPE_IMAGE_PNG = ContentType.IMAGE_PNG;
    public static final ContentType CONTENTTYPE_IMAGE_SVG = ContentType.IMAGE_SVG;
    public static final ContentType CONTENTTYPE_IMAGE_TIFF = ContentType.IMAGE_TIFF;
    public static final ContentType CONTENTTYPE_IMAGE_WEBP = ContentType.IMAGE_WEBP;
    public static final ContentType CONTENTTYPE_MULTIPART_FORM_DATA = ContentType.MULTIPART_FORM_DATA;
    public static final ContentType CONTENTTYPE_TEXT_HTML = ContentType.TEXT_HTML;
    public static final ContentType CONTENTTYPE_TEXT_PLAIN = ContentType.TEXT_PLAIN;
    public static final ContentType CONTENTTYPE_TEXT_XML = ContentType.TEXT_XML;
    public static final ContentType CONTENTTYPE_WILDCARD = ContentType.WILDCARD;

    public static final Accept accept(String value) {
        return Accept.of(value);
    }

    public static final Accept accept(MediaRanges value) {
        return Accept.of(value);
    }

    public static final Accept accept(MediaType value) {
        return Accept.of(value);
    }

    public static final Accept accept(Supplier<MediaRanges> value) {
        return Accept.of(value);
    }

    public static final AcceptCharset acceptCharset(String value) {
        return AcceptCharset.of(value);
    }

    public static final AcceptCharset acceptCharset(StringRanges value) {
        return AcceptCharset.of(value);
    }

    public static final AcceptCharset acceptCharset(Supplier<StringRanges> value) {
        return AcceptCharset.of(value);
    }

    public static final AcceptEncoding acceptEncoding(String value) {
        return AcceptEncoding.of(value);
    }

    public static final AcceptEncoding acceptEncoding(StringRanges value) {
        return AcceptEncoding.of(value);
    }

    public static final AcceptEncoding acceptEncoding(Supplier<StringRanges> value) {
        return AcceptEncoding.of(value);
    }

    public static final AcceptLanguage acceptLanguage(String value) {
        return AcceptLanguage.of(value);
    }

    public static final AcceptLanguage acceptLanguage(StringRanges value) {
        return AcceptLanguage.of(value);
    }

    public static final AcceptLanguage acceptLanguage(Supplier<StringRanges> value) {
        return AcceptLanguage.of(value);
    }

    public static final AcceptRanges acceptRanges(String value) {
        return AcceptRanges.of(value);
    }

    public static final AcceptRanges acceptRanges(Supplier<String> value) {
        return AcceptRanges.of(value);
    }

    public static final Age age(String value) {
        return Age.of(value);
    }

    public static final Age age(Integer value) {
        return Age.of(value);
    }

    public static final Age age(Supplier<Integer> value) {
        return Age.of(value);
    }

    public static final Allow allow(String value) {
        return Allow.of(value);
    }

    public static final Allow allow(String ... value) {
        return Allow.of(value);
    }

    public static final Allow allow(Supplier<String[]> value) {
        return Allow.of(value);
    }

    public static final Authorization authorization(String value) {
        return Authorization.of(value);
    }

    public static final Authorization authorization(Supplier<String> value) {
        return Authorization.of(value);
    }

    public static final CacheControl cacheControl(String value) {
        return CacheControl.of(value);
    }

    public static final CacheControl cacheControl(Supplier<String> value) {
        return CacheControl.of(value);
    }

    public static final ClientVersion clientVersion(String value) {
        return ClientVersion.of(value);
    }

    public static final ClientVersion clientVersion(Version value) {
        return ClientVersion.of(value);
    }

    public static final ClientVersion clientVersion(Supplier<Version> value) {
        return ClientVersion.of(value);
    }

    public static final Connection connection(String value) {
        return Connection.of(value);
    }

    public static final Connection connection(Supplier<String> value) {
        return Connection.of(value);
    }

    public static final ContentDisposition contentDisposition(String value) {
        return ContentDisposition.of(value);
    }

    public static final ContentDisposition contentDisposition(StringRanges value) {
        return ContentDisposition.of(value);
    }

    public static final ContentDisposition contentDisposition(Supplier<StringRanges> value) {
        return ContentDisposition.of(value);
    }

    public static final ContentEncoding contentEncoding(String value) {
        return ContentEncoding.of(value);
    }

    public static final ContentEncoding contentEncoding(Supplier<String> value) {
        return ContentEncoding.of(value);
    }

    public static final ContentLanguage contentLanguage(String value) {
        return ContentLanguage.of(value);
    }

    public static final ContentLanguage contentLanguage(String ... value) {
        return ContentLanguage.of(value);
    }

    public static final ContentLanguage contentLanguage(Supplier<String[]> value) {
        return ContentLanguage.of(value);
    }

    public static final ContentLength contentLength(String value) {
        return ContentLength.of(value);
    }

    public static final ContentLength contentLength(Long value) {
        return ContentLength.of(value);
    }

    public static final ContentLength contentLength(Supplier<Long> value) {
        return ContentLength.of(value);
    }

    public static final ContentLocation contentLocation(String value) {
        return ContentLocation.of(value);
    }

    public static final ContentLocation contentLocation(URI value) {
        return ContentLocation.of(value);
    }

    public static final ContentLocation contentLocation(Supplier<URI> value) {
        return ContentLocation.of(value);
    }

    public static final ContentRange contentRange(String value) {
        return ContentRange.of(value);
    }

    public static final ContentRange contentRange(Supplier<String> value) {
        return ContentRange.of(value);
    }

    public static final ContentType contentType(String value) {
        return ContentType.of(value);
    }

    public static final ContentType contentType(MediaType value) {
        return ContentType.of(value);
    }

    public static final ContentType contentType(Supplier<MediaType> value) {
        return ContentType.of(value);
    }

    public static final Date date(String value) {
        return Date.of(value);
    }

    public static final Date date(ZonedDateTime value) {
        return Date.of(value);
    }

    public static final Date date(Supplier<ZonedDateTime> value) {
        return Date.of(value);
    }

    public static final Debug debug(String value) {
        return Debug.of(value);
    }

    public static final Debug debug(Boolean value) {
        return Debug.of(value);
    }

    public static final Debug debug(Supplier<Boolean> value) {
        return Debug.of(value);
    }

    public static final ETag eTag(String value) {
        return ETag.of(value);
    }

    public static final ETag eTag(EntityTag value) {
        return ETag.of(value);
    }

    public static final ETag eTag(Supplier<EntityTag> value) {
        return ETag.of(value);
    }

    public static final Expect expect(String value) {
        return Expect.of(value);
    }

    public static final Expect expect(Supplier<String> value) {
        return Expect.of(value);
    }

    public static final Expires expires(String value) {
        return Expires.of(value);
    }

    public static final Expires expires(ZonedDateTime value) {
        return Expires.of(value);
    }

    public static final Expires expires(Supplier<ZonedDateTime> value) {
        return Expires.of(value);
    }

    public static final Forwarded forwarded(String value) {
        return Forwarded.of(value);
    }

    public static final Forwarded forwarded(Supplier<String> value) {
        return Forwarded.of(value);
    }

    public static final From from(String value) {
        return From.of(value);
    }

    public static final From from(Supplier<String> value) {
        return From.of(value);
    }

    public static final Host host(String value) {
        return Host.of(value);
    }

    public static final Host host(Supplier<String> value) {
        return Host.of(value);
    }

    public static final IfMatch ifMatch(String value) {
        return IfMatch.of(value);
    }

    public static final IfMatch ifMatch(EntityTags value) {
        return IfMatch.of(value);
    }

    public static final IfMatch ifMatch(Supplier<EntityTags> value) {
        return IfMatch.of(value);
    }

    public static final IfModifiedSince ifModifiedSince(String value) {
        return IfModifiedSince.of(value);
    }

    public static final IfModifiedSince ifModifiedSince(ZonedDateTime value) {
        return IfModifiedSince.of(value);
    }

    public static final IfModifiedSince ifModifiedSince(Supplier<ZonedDateTime> value) {
        return IfModifiedSince.of(value);
    }

    public static final IfNoneMatch ifNoneMatch(String value) {
        return IfNoneMatch.of(value);
    }

    public static final IfNoneMatch ifNoneMatch(EntityTags value) {
        return IfNoneMatch.of(value);
    }

    public static final IfNoneMatch ifNoneMatch(Supplier<EntityTags> value) {
        return IfNoneMatch.of(value);
    }

    public static final IfRange ifRange(String value) {
        return IfRange.of(value);
    }

    public static final IfRange ifRange(ZonedDateTime value) {
        return IfRange.of(value);
    }

    public static final IfRange ifRange(EntityTag value) {
        return IfRange.of(value);
    }

    public static final IfRange ifRange(Supplier<?> value) {
        return IfRange.of(value);
    }

    public static final IfUnmodifiedSince ifUnmodifiedSince(String value) {
        return IfUnmodifiedSince.of(value);
    }

    public static final IfUnmodifiedSince ifUnmodifiedSince(ZonedDateTime value) {
        return IfUnmodifiedSince.of(value);
    }

    public static final IfUnmodifiedSince ifUnmodifiedSince(Supplier<ZonedDateTime> value) {
        return IfUnmodifiedSince.of(value);
    }

    public static final LastModified lastModified(String value) {
        return LastModified.of(value);
    }

    public static final LastModified lastModified(ZonedDateTime value) {
        return LastModified.of(value);
    }

    public static final LastModified lastModified(Supplier<ZonedDateTime> value) {
        return LastModified.of(value);
    }

    public static final Location location(String value) {
        return Location.of(value);
    }

    public static final Location location(URI value) {
        return Location.of(value);
    }

    public static final Location location(Supplier<URI> value) {
        return Location.of(value);
    }

    public static final MaxForwards maxForwards(String value) {
        return MaxForwards.of(value);
    }

    public static final MaxForwards maxForwards(Integer value) {
        return MaxForwards.of(value);
    }

    public static final MaxForwards maxForwards(Supplier<Integer> value) {
        return MaxForwards.of(value);
    }

    public static final NoTrace noTrace(String value) {
        return NoTrace.of(value);
    }

    public static final NoTrace noTrace(Boolean value) {
        return NoTrace.of(value);
    }

    public static final NoTrace noTrace(Supplier<Boolean> value) {
        return NoTrace.of(value);
    }

    public static final Origin origin(String value) {
        return Origin.of(value);
    }

    public static final Origin origin(Supplier<String> value) {
        return Origin.of(value);
    }

    public static final Pragma pragma(String value) {
        return Pragma.of(value);
    }

    public static final Pragma pragma(Supplier<String> value) {
        return Pragma.of(value);
    }

    public static final ProxyAuthenticate proxyAuthenticate(String value) {
        return ProxyAuthenticate.of(value);
    }

    public static final ProxyAuthenticate proxyAuthenticate(Supplier<String> value) {
        return ProxyAuthenticate.of(value);
    }

    public static final ProxyAuthorization proxyAuthorization(String value) {
        return ProxyAuthorization.of(value);
    }

    public static final ProxyAuthorization proxyAuthorization(Supplier<String> value) {
        return ProxyAuthorization.of(value);
    }

    public static final Range range(String value) {
        return Range.of(value);
    }

    public static final Range range(Supplier<String> value) {
        return Range.of(value);
    }

    public static final Referer referer(String value) {
        return Referer.of(value);
    }

    public static final Referer referer(URI value) {
        return Referer.of(value);
    }

    public static final Referer referer(Supplier<URI> value) {
        return Referer.of(value);
    }

    public static final RetryAfter retryAfter(String value) {
        return RetryAfter.of(value);
    }

    public static final RetryAfter retryAfter(ZonedDateTime value) {
        return RetryAfter.of(value);
    }

    public static final RetryAfter retryAfter(Integer value) {
        return RetryAfter.of(value);
    }

    public static final RetryAfter retryAfter(Supplier<?> value) {
        return RetryAfter.of(value);
    }

    public static final Server server(String value) {
        return Server.of(value);
    }

    public static final Server server(Supplier<String> value) {
        return Server.of(value);
    }

    public static final TE te(String value) {
        return TE.of(value);
    }

    public static final TE te(StringRanges value) {
        return TE.of(value);
    }

    public static final TE te(Supplier<StringRanges> value) {
        return TE.of(value);
    }

    public static final Thrown thrown(String value) {
        return Thrown.of(value);
    }

    public static final Thrown thrown(Throwable ... value) {
        return Thrown.of(value);
    }

    public static final Trailer trailer(String value) {
        return Trailer.of(value);
    }

    public static final Trailer trailer(Supplier<String> value) {
        return Trailer.of(value);
    }

    public static final TransferEncoding transferEncoding(String value) {
        return TransferEncoding.of(value);
    }

    public static final TransferEncoding transferEncoding(Supplier<String> value) {
        return TransferEncoding.of(value);
    }

    public static final Upgrade upgrade(String value) {
        return Upgrade.of(value);
    }

    public static final Upgrade upgrade(String ... value) {
        return Upgrade.of(value);
    }

    public static final Upgrade upgrade(Supplier<String[]> value) {
        return Upgrade.of(value);
    }

    public static final UserAgent userAgent(String value) {
        return UserAgent.of(value);
    }

    public static final UserAgent userAgent(Supplier<String> value) {
        return UserAgent.of(value);
    }

    public static final Vary vary(String value) {
        return Vary.of(value);
    }

    public static final Vary vary(Supplier<String> value) {
        return Vary.of(value);
    }

    public static final Via via(String value) {
        return Via.of(value);
    }

    public static final Via via(String ... value) {
        return Via.of(value);
    }

    public static final Via via(Supplier<String[]> value) {
        return Via.of(value);
    }

    public static final Warning warning(String value) {
        return Warning.of(value);
    }

    public static final Warning warning(Supplier<String> value) {
        return Warning.of(value);
    }

    public static final WwwAuthenticate wwwAuthenticate(String value) {
        return WwwAuthenticate.of(value);
    }

    public static final WwwAuthenticate wwwAuthenticate(Supplier<String> value) {
        return WwwAuthenticate.of(value);
    }

    public static final BasicBooleanHeader booleanHeader(String name, String value) {
        return BasicBooleanHeader.of(name, value);
    }

    public static final BasicBooleanHeader booleanHeader(String name, Boolean value) {
        return BasicBooleanHeader.of(name, value);
    }

    public static final BasicBooleanHeader booleanHeader(String name, Supplier<Boolean> value) {
        return BasicBooleanHeader.of(name, value);
    }

    public static final BasicCsvHeader csvHeader(String name, String value) {
        return BasicCsvHeader.of(name, value);
    }

    public static final BasicCsvHeader csvHeader(String name, String ... value) {
        return BasicCsvHeader.of(name, value);
    }

    public static final BasicCsvHeader csvHeader(String name, Supplier<String[]> value) {
        return BasicCsvHeader.of(name, value);
    }

    public static final BasicDateHeader dateHeader(String name, String value) {
        return BasicDateHeader.of(name, value);
    }

    public static final BasicDateHeader dateHeader(String name, ZonedDateTime value) {
        return BasicDateHeader.of(name, value);
    }

    public static final BasicDateHeader dateHeader(String name, Supplier<ZonedDateTime> value) {
        return BasicDateHeader.of(name, value);
    }

    public static final BasicEntityTagsHeader entityTagsHeader(String name, String value) {
        return BasicEntityTagsHeader.of(name, value);
    }

    public static final BasicEntityTagsHeader entityTagsHeader(String name, EntityTags value) {
        return BasicEntityTagsHeader.of(name, value);
    }

    public static final BasicEntityTagsHeader entityTagsHeader(String name, Supplier<EntityTags> value) {
        return BasicEntityTagsHeader.of(name, value);
    }

    public static final BasicEntityTagHeader entityTagHeader(String name, String value) {
        return BasicEntityTagHeader.of(name, value);
    }

    public static final BasicEntityTagHeader entityTagHeader(String name, EntityTag value) {
        return BasicEntityTagHeader.of(name, value);
    }

    public static final BasicEntityTagHeader entityTagHeader(String name, Supplier<EntityTag> value) {
        return BasicEntityTagHeader.of(name, value);
    }

    public static final BasicIntegerHeader integerHeader(String name, String value) {
        return BasicIntegerHeader.of(name, value);
    }

    public static final BasicIntegerHeader integerHeader(String name, Integer value) {
        return BasicIntegerHeader.of(name, value);
    }

    public static final BasicIntegerHeader integerHeader(String name, Supplier<Integer> value) {
        return BasicIntegerHeader.of(name, value);
    }

    public static final BasicLongHeader longHeader(String name, String value) {
        return BasicLongHeader.of(name, value);
    }

    public static final BasicLongHeader longHeader(String name, Long value) {
        return BasicLongHeader.of(name, value);
    }

    public static final BasicLongHeader longHeader(String name, Supplier<Long> value) {
        return BasicLongHeader.of(name, value);
    }

    public static final BasicMediaRangesHeader mediaRangesHeader(String name, String value) {
        return BasicMediaRangesHeader.of(name, value);
    }

    public static final BasicMediaRangesHeader mediaRangesHeader(String name, MediaRanges value) {
        return BasicMediaRangesHeader.of(name, value);
    }

    public static final BasicMediaRangesHeader mediaRangesHeader(String name, Supplier<MediaRanges> value) {
        return value == null ? null : new BasicMediaRangesHeader(name, value);
    }

    public static final BasicMediaTypeHeader mediaTypeHeader(String name, String value) {
        return BasicMediaTypeHeader.of(name, value);
    }

    public static final BasicMediaTypeHeader mediaTypeHeader(String name, MediaType value) {
        return BasicMediaTypeHeader.of(name, value);
    }

    public static final BasicMediaTypeHeader mediaTypeHeader(String name, Supplier<MediaType> value) {
        return value == null ? null : new BasicMediaTypeHeader(name, value);
    }

    public static final BasicStringHeader stringHeader(String pair) {
        return BasicStringHeader.ofPair(pair);
    }

    public static final BasicHeader basicHeader(String name, Object value) {
        return BasicHeader.of(name, value);
    }

    public static final BasicHeader basicHeader(String name, Supplier<?> value) {
        return new BasicHeader(name, value);
    }

    public static final SerializedHeader serializedHeader(String name, Object value) {
        return SerializedHeader.of(name, value);
    }

    public static SerializedHeader serializedHeader(String name, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return SerializedHeader.of(name, value, serializer, schema, skipIfEmpty);
    }

    public static SerializedHeader serializedHeader(String name, Supplier<?> value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return SerializedHeader.of(name, value, serializer, schema, skipIfEmpty);
    }

    public static final SerializedHeader serializedHeader(String name, Supplier<?> value) {
        return SerializedHeader.of(name, value);
    }

    public static final BasicStringHeader stringHeader(String name, String value) {
        return BasicStringHeader.of(name, value);
    }

    public static final BasicStringHeader stringHeader(String name, Supplier<String> value) {
        return BasicStringHeader.of(name, value);
    }

    public static final BasicStringRangesHeader stringRangesHeader(String name, String value) {
        return BasicStringRangesHeader.of(name, value);
    }

    public static final BasicStringRangesHeader stringRangesHeader(String name, StringRanges value) {
        return BasicStringRangesHeader.of(name, value);
    }

    public static final BasicStringRangesHeader stringRangesHeader(String name, Supplier<StringRanges> value) {
        return BasicStringRangesHeader.of(name, value);
    }

    public static final BasicUriHeader uriHeader(String name, String value) {
        return BasicUriHeader.of(name, value);
    }

    public static final BasicUriHeader uriHeader(String name, URI value) {
        return BasicUriHeader.of(name, value);
    }

    public static final BasicUriHeader uriHeader(String name, Supplier<URI> value) {
        return BasicUriHeader.of(name, value);
    }

    public static final <T extends Header> T header(Class<T> type, String name, Object value) {
        return (T)((Header)HeaderBeanMeta.of(type).construct(name, value));
    }

    public static final <T extends Header> T header(Class<T> type, Object value) {
        return (T)((Header)HeaderBeanMeta.of(type).construct(null, value));
    }

    public static final HeaderList headerList() {
        return HeaderList.create();
    }

    public static final HeaderList headerList(List<Header> headers) {
        return HeaderList.of(headers);
    }

    public static final HeaderList headerList(Header ... headers) {
        return HeaderList.of(headers);
    }

    public static HeaderList headerList(String ... pairs) {
        return HeaderList.ofPairs(pairs);
    }

    public static boolean canCast(Object o) {
        ClassInfo ci = ClassInfo.of((Object)o);
        return ci != null && ci.isChildOfAny(new Class[]{Header.class, Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class});
    }

    public static Header cast(Object o) {
        if (o instanceof Header) {
            return (Header)o;
        }
        if (o instanceof Headerable) {
            return ((Headerable)o).asHeader();
        }
        if (o instanceof NameValuePair) {
            return BasicHeader.of((NameValuePair)o);
        }
        if (o instanceof NameValuePairable) {
            return BasicHeader.of(((NameValuePairable)o).asNameValuePair());
        }
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return BasicHeader.of(StringUtils.stringify(e.getKey()), StringUtils.stringify(e.getValue()));
        }
        throw new BasicRuntimeException("Object of type {0} could not be converted to a Header.", new Object[]{ClassUtils.className((Object)o)});
    }
}

