/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Locale;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.apache.http.message.BasicLineFormatter;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters
public class BasicStatusLine
implements StatusLine {
    private ProtocolVersion DEFAULT_PROTOCOL_VERSION;
    private ProtocolVersion protocolVersion;
    private int statusCode;
    private String reasonPhrase;
    private ReasonPhraseCatalog reasonPhraseCatalog;
    private Locale locale;
    private boolean unmodifiable;

    public static BasicStatusLine create() {
        return new BasicStatusLine();
    }

    public static BasicStatusLine create(int statusCode, String reasonPhrase) {
        return new BasicStatusLine().setStatusCode(statusCode).setReasonPhrase(reasonPhrase);
    }

    public BasicStatusLine() {
        this.protocolVersion = this.DEFAULT_PROTOCOL_VERSION = new ProtocolVersion("HTTP", 1, 1);
        this.statusCode = 0;
        this.locale = Locale.getDefault();
    }

    protected BasicStatusLine(BasicStatusLine copyFrom) {
        this.protocolVersion = this.DEFAULT_PROTOCOL_VERSION = new ProtocolVersion("HTTP", 1, 1);
        this.statusCode = 0;
        this.locale = Locale.getDefault();
        this.protocolVersion = copyFrom.protocolVersion;
        this.statusCode = copyFrom.statusCode;
        this.reasonPhrase = copyFrom.reasonPhrase;
        this.locale = copyFrom.locale;
    }

    public BasicStatusLine copy() {
        return new BasicStatusLine(this);
    }

    @FluentSetter
    public BasicStatusLine setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("Bean is read-only");
        }
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @FluentSetter
    public BasicStatusLine setProtocolVersion(ProtocolVersion value) {
        this.assertModifiable();
        this.protocolVersion = value;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @FluentSetter
    public BasicStatusLine setStatusCode(int value) {
        this.assertModifiable();
        this.statusCode = value;
        return this;
    }

    public String getReasonPhrase() {
        if (this.reasonPhrase == null) {
            ReasonPhraseCatalog rfc = (ReasonPhraseCatalog)ObjectUtils.firstNonNull((Object[])new ReasonPhraseCatalog[]{this.reasonPhraseCatalog, EnglishReasonPhraseCatalog.INSTANCE});
            return rfc.getReason(this.statusCode, this.locale);
        }
        return this.reasonPhrase;
    }

    @FluentSetter
    public BasicStatusLine setReasonPhrase(String value) {
        this.assertModifiable();
        this.reasonPhrase = value;
        return this;
    }

    @FluentSetter
    public BasicStatusLine setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.assertModifiable();
        this.reasonPhraseCatalog = value;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @FluentSetter
    public BasicStatusLine setLocale(Locale value) {
        this.assertModifiable();
        this.locale = value;
        return this;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatStatusLine(null, (StatusLine)this).toString();
    }
}

