/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXB;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckCommon;
import org.apache.juddi.v3.tck.TckValidator;
import org.junit.Assert;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckTModel {
    public static final String JOE_PUBLISHER_TMODEL_XML = "uddi_data/joepublisher/tModelKeyGen.xml";
    public static final String JOE_PUBLISHER_TMODEL_XML_SUBSCRIPTION3 = "uddi_data/joepublisher/FindTmodelTest.xml";
    public static final String JOE_PUBLISHER_TMODEL_SUBSCRIPTION3_TMODEL_KEY = "uddi:uddi.joepublisher.com:tmodelone";
    public static final String JOE_PUBLISHER_KEY_PREFIX = "uddi:uddi.joepublisher.com:";
    static final String JOE_PUBLISHER_TMODEL_KEY = "uddi:uddi.joepublisher.com:keygenerator";
    static final String MARY_PUBLISHER_TMODEL_XML = "uddi_data/marypublisher/tModelKeyGen.xml";
    static final String MARY_PUBLISHER_TMODEL_KEY = "uddi:uddi.marypublisher.com:keygenerator";
    static final String SAM_SYNDICATOR_TMODEL_XML = "uddi_data/samsyndicator/tModelKeyGen.xml";
    static final String SAM_SYNDICATOR_TMODEL_KEY = "uddi:www.samco.com:keygenerator";
    static final String TMODEL_PUBLISHER_TMODEL_XML = "uddi_data/tmodels/tModelKeyGen.xml";
    static final String TMODEL_PUBLISHER_TMODEL_KEY = "uddi:tmodelkey:categories:keygenerator";
    static final String FIND_TMODEL_XML = "uddi_data/find/findTModel1.xml";
    static final String FIND_TMODEL_XML_BY_CAT = "uddi_data/find/findTModelByCategoryBag.xml";
    public static final String TMODELS_XML = "uddi_data/tmodels/tmodels.xml";
    public static final String RIFTSAW_PUBLISHER_TMODEL_XML = "uddi_data/bpel/riftsaw/tModelKeyGen.xml";
    public static final String RIFTSAW_PUBLISHER_TMODEL_KEY = "uddi:riftsaw.jboss.org:keygenerator";
    public static final String RIFTSAW_CUST_PORTTYPE_TMODEL_XML = "uddi_data/bpel/riftsaw/tModelCustomerPortType.xml";
    public static final String RIFTSAW_CUST_PORTTYPE_TMODEL_KEY = "uddi:riftsaw.jboss.org:CustomerInterface_portType";
    public static final String RIFTSAW_AGENT_PORTTYPE_TMODEL_XML = "uddi_data/bpel/riftsaw/tModelAgentPortType.xml";
    public static final String RIFTSAW_AGENT_PORTTYPE_TMODEL_KEY = "uddi:riftsaw.jboss.org:TravelAgentInterface_portType";
    public static final String RIFTSAW_PROCESS_TMODEL_XML = "uddi_data/bpel/riftsaw/tModelProcess.xml";
    public static final String RIFTSAW_PROCESS_TMODEL_KEY = "uddi:riftsaw.jboss.org:ReservationAndBookingTicketsProcess";
    private Log logger = LogFactory.getLog(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;
    private Set<String> keyscreated = new HashSet<String>();

    public TckTModel(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public void saveTModels(String authInfo, String tModelXml) {
        try {
            SaveTModel st = (SaveTModel)EntityCreator.buildFromDoc((String)tModelXml, (String)"org.uddi.api_v3");
            for (int i = 0; i < st.getTModel().size(); ++i) {
                this.saveTModel(authInfo, (TModel)st.getTModel().get(i), false);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private TModel saveTModel(String authInfo, TModel tmIn, boolean force) {
        boolean exists = false;
        GetTModelDetail gt1 = new GetTModelDetail();
        gt1.getTModelKey().add(tmIn.getTModelKey());
        try {
            TModelDetail td1 = this.inquiry.getTModelDetail(gt1);
            if (td1 != null && !td1.getTModel().isEmpty()) {
                if (!((TModel)td1.getTModel().get(0)).isDeleted()) {
                    exists = true;
                } else {
                    this.logger.info((Object)("The tModel with key " + tmIn.getTModelKey() + " exists already, but is flagged as deleted. Overwritting"));
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!exists || force) {
            try {
                SaveTModel st = new SaveTModel();
                st.setAuthInfo(authInfo);
                st.getTModel().add(tmIn);
                this.publication.saveTModel(st);
                this.keyscreated.add(tmIn.getTModelKey());
                GetTModelDetail gt = new GetTModelDetail();
                gt.getTModelKey().add(tmIn.getTModelKey());
                TModelDetail td = this.inquiry.getTModelDetail(gt);
                List tmOutList = td.getTModel();
                TModel tmOut = (TModel)tmOutList.get(0);
                junit.framework.Assert.assertEquals((String)tmIn.getTModelKey().toLowerCase(), (String)tmOut.getTModelKey());
                junit.framework.Assert.assertEquals((String)tmIn.getName().getLang(), (String)tmOut.getName().getLang());
                junit.framework.Assert.assertEquals((String)tmIn.getName().getValue(), (String)tmOut.getName().getValue());
                TckValidator.checkDescriptions(tmIn.getDescription(), tmOut.getDescription());
                TckValidator.checkCategories(tmIn.getCategoryBag(), tmOut.getCategoryBag());
                for (OverviewDoc overviewDoc : tmIn.getOverviewDoc()) {
                    TckValidator.checkOverviewDocs(overviewDoc, tmOut.getOverviewDoc());
                }
                this.logger.info((Object)("The TModel " + tmIn.getTModelKey() + " saved"));
                if (TckCommon.isDebug()) {
                    JAXB.marshal((Object)tmOut, (OutputStream)System.out);
                }
                return tmOut;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                Assert.fail((String)"No exception should be thrown");
            }
        } else {
            this.logger.info((Object)("The TModel " + tmIn.getTModelKey() + " exists already, skipping"));
        }
        return tmIn;
    }

    public TModel saveTModel(String authInfo, String tModelXml, String tModelKey) {
        return this.saveTModel(authInfo, tModelXml, tModelKey, false);
    }

    public TModel saveTModel(String authInfo, String tModelXml, String tModelKey, boolean force) {
        this.logger.info((Object)("Loading tModel from " + tModelXml));
        TModel tmIn = null;
        try {
            tmIn = (TModel)EntityCreator.buildFromDoc((String)tModelXml, (String)"org.uddi.api_v3");
        }
        catch (Exception ex) {
            Assert.fail((String)"unable to load tmodel from file!");
        }
        if (tmIn == null) {
            Assert.fail((String)"unable to load tmodel from file!");
        }
        return this.saveTModel(authInfo, tmIn, force);
    }

    public synchronized void deleteTModel(String authInfo, String tModelXml, String tModelKey, boolean force) {
        if (this.keyscreated.contains(tModelKey) || force) {
            try {
                this.keyscreated.remove(tModelKey);
                DeleteTModel dt = new DeleteTModel();
                dt.setAuthInfo(authInfo);
                this.logger.info((Object)("deleting tmodel " + tModelKey));
                dt.getTModelKey().add(tModelKey);
                this.publication.deleteTModel(dt);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                Assert.fail((String)"No exception should be thrown");
            }
        } else {
            this.logger.info((Object)("skipping the deletion of tmodel " + tModelKey + " since it wasn't created by the tck"));
        }
    }

    public synchronized void deleteTModel(String authInfo, String tModelXml, String tModelKey) {
        this.deleteTModel(authInfo, tModelXml, tModelKey, false);
    }

    public TModelDetail getTModelDetail(String authInfo, String tModelXml, String tModelKey) {
        try {
            GetTModelDetail tmodelDetail = new GetTModelDetail();
            tmodelDetail.setAuthInfo(authInfo);
            tmodelDetail.getTModelKey().add(tModelKey);
            return this.inquiry.getTModelDetail(tmodelDetail);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
            Assert.fail((String)"We should already have returned");
            return null;
        }
    }

    public TModelList findJoeTModelDetail() {
        try {
            FindTModel body = (FindTModel)EntityCreator.buildFromDoc((String)FIND_TMODEL_XML, (String)"org.uddi.api_v3");
            TModelList result = this.inquiry.findTModel(body);
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
            Assert.fail((String)"We should already have returned");
            return null;
        }
    }

    public TModelList findJoeTModelDetailByCategoryBag() {
        try {
            FindTModel body = (FindTModel)EntityCreator.buildFromDoc((String)FIND_TMODEL_XML_BY_CAT, (String)"org.uddi.api_v3");
            TModelList result = this.inquiry.findTModel(body);
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
            Assert.fail((String)"We should already have returned");
            return null;
        }
    }

    public TModel saveJoePublisherTmodel(String authInfoJoe) {
        return this.saveTModel(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY, false);
    }

    public TModel saveJoePublisherTmodel(String authInfoJoe, boolean force) {
        return this.saveTModel(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY, force);
    }

    public void saveUDDIPublisherTmodel(String authInfoTM) {
        this.saveTModel(authInfoTM, TMODEL_PUBLISHER_TMODEL_XML, TMODEL_PUBLISHER_TMODEL_KEY, false);
    }

    public void saveTmodels(String authInfoJoe) {
        this.saveTModels(authInfoJoe, TMODELS_XML);
    }

    public void deleteJoePublisherTmodel(String authInfoJoe) {
        this.deleteTModel(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY);
    }

    public TModelDetail getJoePublisherTmodel(String authInfoJoe) {
        return this.getTModelDetail(authInfoJoe, JOE_PUBLISHER_TMODEL_XML, JOE_PUBLISHER_TMODEL_KEY);
    }

    public TModelList findJoePublisherTmodel(String authInfoJoe) {
        return this.findJoeTModelDetail();
    }

    public TModel saveMaryPublisherTmodel(String authInfoMary) {
        return this.saveTModel(authInfoMary, MARY_PUBLISHER_TMODEL_XML, MARY_PUBLISHER_TMODEL_KEY, false);
    }

    public void deleteMaryPublisherTmodel(String authInfoMary) {
        this.deleteTModel(authInfoMary, MARY_PUBLISHER_TMODEL_XML, MARY_PUBLISHER_TMODEL_KEY);
    }

    public TModel saveSamSyndicatorTmodel(String authInfoSam) {
        return this.saveTModel(authInfoSam, SAM_SYNDICATOR_TMODEL_XML, SAM_SYNDICATOR_TMODEL_KEY, false);
    }

    public void deleteSamSyndicatorTmodel(String authInfoSam) {
        this.deleteTModel(authInfoSam, SAM_SYNDICATOR_TMODEL_XML, SAM_SYNDICATOR_TMODEL_KEY);
    }

    public void deleteCreatedTModels(String authinfo) {
        if (this.keyscreated != null) {
            Iterator<String> iterator = this.keyscreated.iterator();
            while (iterator.hasNext()) {
                DeleteTModel dtm = new DeleteTModel();
                dtm.setAuthInfo(authinfo);
                String s = iterator.next();
                this.logger.info((Object)("cleanup tModel " + s));
                dtm.getTModelKey().add(s);
                try {
                    this.publication.deleteTModel(dtm);
                }
                catch (Exception ex) {
                    this.logger.warn((Object)("failed to delete tmodel " + s + " " + ex.getMessage()));
                    this.logger.debug((Object)("failed to delete tmodel " + s + " " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }
}

