/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.junit.Assert;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.v3_service.UDDIPublicationPortType;

public class TckPublisherAssertion {
    static final String JOE_ASSERT_XML = "uddi_data/joepublisher/publisherAssertion.xml";
    static final String MARY_ASSERT_XML = "uddi_data/marypublisher/publisherAssertion.xml";
    static final String JOE_ASSERT2_XML = "uddi_data/joepublisher/publisherAssertion2.xml";
    static final String SAM_ASSERT_XML = "uddi_data/samsyndicator/publisherAssertion.xml";
    private Log logger = LogFactory.getLog(this.getClass());
    private UDDIPublicationPortType publication = null;

    public TckPublisherAssertion(UDDIPublicationPortType publication) {
        this.publication = publication;
    }

    public void saveJoePublisherPublisherAssertion(String authInfoJoe) {
        this.addPublisherAssertion(authInfoJoe, JOE_ASSERT_XML);
    }

    public void saveSamPublisherPublisherAssertion(String authInfoSam) {
        this.addPublisherAssertion(authInfoSam, SAM_ASSERT_XML);
    }

    public void saveMaryPublisherPublisherAssertion(String authInfoMary) {
        this.addPublisherAssertion(authInfoMary, MARY_ASSERT_XML);
    }

    public void saveJoePublisherPublisherAssertion2(String authInfoJoe) {
        this.addPublisherAssertion(authInfoJoe, JOE_ASSERT2_XML);
    }

    public void deleteJoePublisherPublisherAssertion(String authInfoJoe) {
        this.deletePublisherAssertion(authInfoJoe, JOE_ASSERT_XML);
    }

    public void deleteMaryPublisherPublisherAssertion(String authInfoMary) {
        this.deletePublisherAssertion(authInfoMary, MARY_ASSERT_XML);
    }

    public void deleteSamPublisherPublisherAssertion(String authInfoSam) {
        this.deletePublisherAssertion(authInfoSam, SAM_ASSERT_XML);
    }

    public void deleteJoePublisherPublisherAssertion2(String authInfoJoe) {
        this.deletePublisherAssertion(authInfoJoe, JOE_ASSERT2_XML);
    }

    public void addPublisherAssertion(String authInfo, String pubassertXML) {
        try {
            AddPublisherAssertions ap = new AddPublisherAssertions();
            ap.setAuthInfo(authInfo);
            PublisherAssertion paIn = (PublisherAssertion)EntityCreator.buildFromDoc((String)pubassertXML, (String)"org.uddi.api_v3");
            ap.getPublisherAssertion().add(paIn);
            this.publication.addPublisherAssertions(ap);
            List paOutList = this.publication.getPublisherAssertions(authInfo);
            if (paOutList.size() == 1) {
                PublisherAssertion paOut = (PublisherAssertion)paOutList.get(0);
                junit.framework.Assert.assertEquals((String)paIn.getFromKey(), (String)paOut.getFromKey());
                junit.framework.Assert.assertEquals((String)paIn.getToKey(), (String)paOut.getToKey());
                KeyedReference keyRefIn = paIn.getKeyedReference();
                KeyedReference keyRefOut = paOut.getKeyedReference();
                junit.framework.Assert.assertEquals((String)keyRefIn.getTModelKey(), (String)keyRefOut.getTModelKey());
                junit.framework.Assert.assertEquals((String)keyRefIn.getKeyName(), (String)keyRefOut.getKeyName());
                junit.framework.Assert.assertEquals((String)keyRefIn.getKeyValue(), (String)keyRefOut.getKeyValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deletePublisherAssertion(String authInfo, String pubassertXML) {
        try {
            DeletePublisherAssertions dp = new DeletePublisherAssertions();
            dp.setAuthInfo(authInfo);
            PublisherAssertion paIn = (PublisherAssertion)EntityCreator.buildFromDoc((String)pubassertXML, (String)"org.uddi.api_v3");
            dp.getPublisherAssertion().add(paIn);
            this.publication.deletePublisherAssertions(dp);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

