/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.tck.Property;

public class TckPublisher {
    private static Properties tckProperties = new Properties();
    public static final String JOE_PUBLISHER_XML = "uddi_data/joepublisher/publisher.xml";
    public static final String SAM_SYNDICATOR_XML = "uddi_data/samsyndicator/publisher.xml";
    public static final String MARY_PUBLISHER_XML = "uddi_data/marypublisher/publisher.xml";
    private static Log logger = LogFactory.getLog(TckPublisher.class);

    public static final String getRootPublisherId() {
        return tckProperties.getProperty(Property.ROOT_PUBLISHER);
    }

    public static final String getRootPassword() {
        return tckProperties.getProperty(Property.ROOT_PASSWORD);
    }

    public static final String getUDDIPublisherId() {
        return tckProperties.getProperty(Property.UDDI_PUBLISHER);
    }

    public static final String getUDDIPassword() {
        return tckProperties.getProperty(Property.UDDI_PASSWORD);
    }

    public static final String getJoePublisherId() {
        return tckProperties.getProperty(Property.JOE_PUBLISHER);
    }

    public static final String getJoePassword() {
        return tckProperties.getProperty(Property.JOE_PASSWORD);
    }

    public static final String getTModelPublisherId() {
        return tckProperties.getProperty(Property.TMODEL_PUBLISHER);
    }

    public static final String getTModelPassword() {
        return tckProperties.getProperty(Property.TMODEL_PASSWORD);
    }

    public static final String getSamPublisherId() {
        return tckProperties.getProperty(Property.SAM_PUBLISHER);
    }

    public static final String getSamPassword() {
        return tckProperties.getProperty(Property.SAM_PASSWORD);
    }

    public static final String getMaryPublisherId() {
        return tckProperties.getProperty(Property.MARY_PUBLISHER);
    }

    public static final String getMaryPassword() {
        return tckProperties.getProperty(Property.MARY_PASSWORD);
    }

    public static final String getRiftSawPublisherId() {
        return tckProperties.getProperty(Property.RIFTSAW_PUBLISHER);
    }

    public static final String getRiftSawPassword() {
        return tckProperties.getProperty(Property.RIFTSAW_PASSWORD);
    }

    public static boolean isUDDIAuthMode() {
        String x = tckProperties.getProperty("auth_mode");
        return x != null && x.equalsIgnoreCase("uddi");
    }

    public static boolean isReplicationEnabled() {
        String x = tckProperties.getProperty("replication.enabled");
        return x != null && x.equalsIgnoreCase("true");
    }

    public static boolean isInquiryRestEnabled() {
        String x = tckProperties.getProperty("rest.enabled");
        return x != null && x.equalsIgnoreCase("true");
    }

    public static boolean isValueSetAPIEnabled() {
        String x = tckProperties.getProperty("vsv.enabled");
        return x != null && x.equalsIgnoreCase("true");
    }

    public static boolean isSubscriptionEnabled() {
        String x = tckProperties.getProperty("sub.enabled");
        return x != null && x.equalsIgnoreCase("true");
    }

    public static boolean isCustodyTransferEnabled() {
        String x = tckProperties.getProperty("transfer.enabled");
        return x != null && x.equalsIgnoreCase("true");
    }

    public static boolean isJUDDI() {
        String x = tckProperties.getProperty("isJuddi");
        return x.equalsIgnoreCase("true");
    }

    public static boolean isRMI() {
        String x = tckProperties.getProperty("rmi.enabled");
        return x.equalsIgnoreCase("true");
    }

    public static boolean isLoadTest() {
        String x = tckProperties.getProperty("loadtest.enable");
        return x.equalsIgnoreCase("true");
    }

    public static boolean isBPEL() {
        String x = tckProperties.getProperty("bpel.enable");
        return x.equalsIgnoreCase("true");
    }

    public static int getMaxLoadServices() {
        String x = tckProperties.getProperty("loadtest.maxbusinesses");
        if (x != null) {
            try {
                return Integer.parseInt(x);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 1100;
    }

    public static Properties getProperties() {
        return tckProperties;
    }

    public static int getSubscriptionTimeout() {
        String x = tckProperties.getProperty("sub.timeout");
        if (x != null) {
            try {
                return Integer.parseInt(x);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 60;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String s = System.getProperty("tck.properties");
        InputStream inputSteam = null;
        try {
            File f = null;
            if (s != null && s.length() != 0) {
                f = new File(s);
            }
            if (f == null || !f.exists()) {
                f = new File("tck.properties");
            }
            if (f.exists()) {
                inputSteam = new FileInputStream(f);
                logger.info((Object)("Loading tck.properties from " + f.getAbsolutePath()));
            } else {
                inputSteam = TckPublisher.class.getResourceAsStream("/tck.properties");
                logger.info((Object)"Loading tck.properties as a classpath resource, probable within uddi-tck-base.jar");
            }
            tckProperties.load(inputSteam);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (inputSteam != null) {
                try {
                    inputSteam.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

