/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckCommon;
import org.apache.juddi.v3.tck.TckSigningUtil;
import org.apache.juddi.v3.tck.TckValidator;
import org.junit.Assert;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TckBusiness {
    public static final String JOE_BUSINESS_XML = "uddi_data/joepublisher/businessEntity.xml";
    public static final String JOE_BUSINESS_KEY = "uddi:uddi.joepublisher.com:businessone";
    public static final String JOE_BUSINESS3_XML = "uddi_data/joepublisher/businessEntity3.xml";
    public static final String JOE_BUSINESS3_KEY = "uddi:uddi.joepublisher.com:businessthree.com";
    public static final String JOE_BUSINESS_MOVE_XML = "uddi_data/joepublisher/moveBusinessService1to3.xml";
    public static final String MARY_BUSINESS_XML = "uddi_data/marypublisher/businessEntity.xml";
    public static final String MARY_BUSINESS_KEY = "uddi:uddi.marypublisher.com:marybusinessone";
    public static final String SAM_BUSINESS_XML = "uddi_data/samsyndicator/businessEntity.xml";
    public static final String SAM_BUSINESS_WITHPROJECTION_XML = "uddi_data/samsyndicator/businessEntity_withProjection.xml";
    public static final String SAM_BUSINESS_KEY = "uddi:www.samco.com:samco";
    public static final String COMBINE_CATBAGS_BIZ_XML = "uddi_data/joepublisher/combineCatBagsBusinessServices.xml";
    public static final String COMBINE_CATBAGS_BIZ_KEY = "uddi:uddi.joepublisher.com:business01";
    public static final String RIFTSAW_BUSINESS_KEY = "uddi:riftsaw.jboss.org:business_redhat-jboss";
    public static final String RIFTSAW_BUSINESS_XML = "uddi_data/bpel/riftsaw/businessEntity.xml";
    static final String SIGNATURE_KEYSTORE = "uddi_data/signature/signature.jks";
    static final String SIGNATURE_KEYSTORE_TYPE = "JKS";
    static final String SIGNATURE_KEYSTORE_PASSWORD = "changeit";
    static final String SIGNATURE_KEYSTORE_ALIAS = "mykey";
    private Log logger = LogFactory.getLog(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDIInquiryPortType inquiry = null;

    public TckBusiness(UDDIPublicationPortType publication, UDDIInquiryPortType inquiry) {
        this.publication = publication;
        this.inquiry = inquiry;
    }

    public BusinessEntity saveSamSyndicatorBusiness(String authInfoSam) {
        return this.saveBusiness(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY);
    }

    public void saveSamSyndicatorBusinesses(String authInfoSam, int numberOfCopies) {
        this.saveBusinesses(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY, numberOfCopies);
    }

    public BusinessEntity saveSamSyndicatorBusinessWithProjection(String authInfoSam) {
        return this.saveBusiness(authInfoSam, SAM_BUSINESS_WITHPROJECTION_XML, SAM_BUSINESS_KEY);
    }

    public void deleteSamSyndicatorBusiness(String authInfoSam) {
        this.deleteBusiness(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY);
    }

    public void deleteSamSyndicatorBusinesses(String authInfoSam, int numberOfCopies) {
        this.deleteBusinesses(authInfoSam, SAM_BUSINESS_XML, SAM_BUSINESS_KEY, numberOfCopies);
    }

    public void saveJoePublisherBusinessX509Signature(String authInfoJoe) {
        this.saveBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY);
        this.signBusiness(authInfoJoe, JOE_BUSINESS_KEY);
        this.verifyBusinessSignature(authInfoJoe, JOE_BUSINESS_KEY);
    }

    public void saveJoePublisherBusiness(String authInfoJoe) {
        this.saveBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY, TckCommon.isDebug());
    }

    public BusinessEntity saveCombineCatBagsPublisherBusiness(String authInfoJoe) {
        return this.saveBusiness(authInfoJoe, COMBINE_CATBAGS_BIZ_XML, COMBINE_CATBAGS_BIZ_KEY);
    }

    public BusinessEntity saveJoePublisherBusiness3(String authInfoJoe) {
        return this.saveBusiness(authInfoJoe, JOE_BUSINESS3_XML, JOE_BUSINESS3_KEY);
    }

    public BusinessEntity saveJoePublisherBusiness1to3(String authInfoJoe) {
        return this.saveBusiness(authInfoJoe, JOE_BUSINESS_MOVE_XML, JOE_BUSINESS3_KEY);
    }

    public BusinessEntity saveMaryPublisherBusiness(String authInfoMary) {
        return this.saveBusiness(authInfoMary, MARY_BUSINESS_XML, MARY_BUSINESS_KEY);
    }

    public void updateJoePublisherBusiness(String authInfoJoe) {
        this.updateBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY);
    }

    public void saveJoePublisherBusinesses(String authInfoJoe, int numberOfCopies) {
        this.saveBusinesses(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY, numberOfCopies);
    }

    public void deleteJoePublisherBusiness(String authInfoJoe) {
        this.deleteBusiness(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY);
    }

    public void deleteJoePublisherBusiness3(String authInfoJoe) {
        this.deleteBusiness(authInfoJoe, JOE_BUSINESS3_XML, JOE_BUSINESS3_KEY);
    }

    public void deleteMaryPublisherBusiness(String authInfoMary) {
        this.deleteBusiness(authInfoMary, MARY_BUSINESS_XML, MARY_BUSINESS_KEY);
    }

    public void deleteJoePublisherBusinesses(String authInfoJoe, int numberOfCopies) {
        this.deleteBusinesses(authInfoJoe, JOE_BUSINESS_XML, JOE_BUSINESS_KEY, numberOfCopies);
    }

    public void checkServicesBusinessOne(int expectedNumberOfServices) {
        this.checkNumberOfServices(JOE_BUSINESS_KEY, expectedNumberOfServices);
    }

    public void checkServicesBusinessThree(int expectedNumberOfServices) {
        this.checkNumberOfServices(JOE_BUSINESS3_KEY, expectedNumberOfServices);
    }

    public void saveBusinesses(String authInfo, String businessXML, String businessKey, int numberOfCopies) {
        try {
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)businessXML, (String)"org.uddi.api_v3");
            String businessName = ((Name)beIn.getName().get(0)).getValue();
            for (int i = 0; i < numberOfCopies; ++i) {
                SaveBusiness sb = new SaveBusiness();
                sb.setAuthInfo(authInfo);
                ((Name)beIn.getName().get(0)).setValue(businessName + "-" + i);
                beIn.setBusinessKey(businessKey + "-" + i);
                sb.getBusinessEntity().add(beIn);
                this.publication.saveBusiness(sb);
                this.logger.info((Object)("Saved business with key " + businessName + "-" + i));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void checkNumberOfServices(String businessKey, int expectedServices) {
        try {
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity beOut = (BusinessEntity)beOutList.get(0);
            if (expectedServices > 0) {
                junit.framework.Assert.assertEquals((int)expectedServices, (int)beOut.getBusinessServices().getBusinessService().size());
            } else {
                Assert.assertNull((Object)beOut.getBusinessServices());
            }
        }
        catch (RemoteException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void signBusiness(String authInfo, String businessKey) {
        try {
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity bizEntity = (BusinessEntity)beOutList.get(0);
            bizEntity.getSignature().clear();
            BusinessEntity bizEntitySigned = this.signJAXBObject(bizEntity);
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(authInfo);
            sb.getBusinessEntity().add(bizEntitySigned);
            this.publication.saveBusiness(sb);
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void verifyBusinessSignature(String authInfo, String businessKey) {
        try {
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity bizEntity = (BusinessEntity)beOutList.get(0);
            boolean sigOk = this.verifySignedJAXBObject(bizEntity);
            junit.framework.Assert.assertTrue((String)"Signature invalid!", (boolean)sigOk);
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    private <T> T signJAXBObject(T jaxbObj) {
        DOMResult domResult = new DOMResult();
        JAXB.marshal(jaxbObj, (Result)domResult);
        Document doc = (Document)domResult.getNode();
        Element docElement = doc.getDocumentElement();
        try {
            KeyStore ks = KeyStore.getInstance(SIGNATURE_KEYSTORE_TYPE);
            URL url = Thread.currentThread().getContextClassLoader().getResource(SIGNATURE_KEYSTORE);
            ks.load(url.openStream(), SIGNATURE_KEYSTORE_PASSWORD.toCharArray());
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(SIGNATURE_KEYSTORE_ALIAS, new KeyStore.PasswordProtection(SIGNATURE_KEYSTORE_PASSWORD.toCharArray()));
            PrivateKey privateKey = keyEntry.getPrivateKey();
            Certificate origCert = keyEntry.getCertificate();
            PublicKey validatingKey = origCert.getPublicKey();
            TckSigningUtil.signDOM(docElement, privateKey, origCert);
            DOMSource domSource = new DOMSource(doc);
            Object result = JAXB.unmarshal((Source)domSource, jaxbObj.getClass());
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Signature failure due to: " + e.getMessage(), e);
        }
    }

    private boolean verifySignedJAXBObject(Object obj) {
        try {
            DOMResult domResult = new DOMResult();
            JAXB.marshal((Object)obj, (Result)domResult);
            Document doc = (Document)domResult.getNode();
            Element docElement = doc.getDocumentElement();
            KeyStore ks = KeyStore.getInstance(SIGNATURE_KEYSTORE_TYPE);
            URL url = Thread.currentThread().getContextClassLoader().getResource(SIGNATURE_KEYSTORE);
            ks.load(url.openStream(), SIGNATURE_KEYSTORE_PASSWORD.toCharArray());
            KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(SIGNATURE_KEYSTORE_ALIAS, new KeyStore.PasswordProtection(SIGNATURE_KEYSTORE_PASSWORD.toCharArray()));
            PrivateKey privateKey = keyEntry.getPrivateKey();
            Certificate origCert = keyEntry.getCertificate();
            PublicKey validatingKey = origCert.getPublicKey();
            return TckSigningUtil.verifySignature(docElement, validatingKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BusinessEntity saveBusiness(String authInfo, String businessXML, String businessKey) {
        return this.saveBusiness(authInfo, businessXML, businessKey, false);
    }

    public BusinessEntity saveBusiness(String authInfo, String businessXML, String businessKey, boolean serialize) {
        this.logger.info((Object)("attempting to save business " + businessKey + " from " + businessXML));
        try {
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(authInfo);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)businessXML, (String)"org.uddi.api_v3");
            if (beIn == null) {
                throw new Exception("Unload to load source xml document from " + businessXML);
            }
            sb.getBusinessEntity().add(beIn);
            BusinessDetail saveBusiness = this.publication.saveBusiness(sb);
            this.logger.info((Object)("Business saved with key " + ((BusinessEntity)saveBusiness.getBusinessEntity().get(0)).getBusinessKey()));
            if (serialize) {
                JAXB.marshal((Object)saveBusiness, (OutputStream)System.out);
            }
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity beOut = (BusinessEntity)beOutList.get(0);
            if (serialize) {
                JAXB.marshal((Object)beOut, (File)new File("target/aftersave.xml"));
            }
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)beOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), beOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), beOut.getDescription());
            TckValidator.checkDiscoveryUrls(beIn.getDiscoveryURLs(), beOut.getDiscoveryURLs());
            TckValidator.checkContacts(beIn.getContacts(), beOut.getContacts());
            TckValidator.checkCategories(beIn.getCategoryBag(), beOut.getCategoryBag());
            TckValidator.checkSignatures(beIn.getSignature(), beOut.getSignature());
            return beOut;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
            return null;
        }
    }

    public void updateBusiness(String authInfo, String businessXML, String businessKey) {
        try {
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.getBusinessKey().add(businessKey);
            BusinessDetail bd = this.inquiry.getBusinessDetail(gb);
            List beOutList = bd.getBusinessEntity();
            BusinessEntity beOut = (BusinessEntity)beOutList.get(0);
            junit.framework.Assert.assertEquals((int)2, (int)beOut.getBusinessServices().getBusinessService().size());
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(authInfo);
            BusinessEntity beIn = beOut;
            Description desc2 = new Description();
            desc2.setLang("nl");
            desc2.setValue("Omschrijving");
            beIn.getDescription().add(desc2);
            sb.getBusinessEntity().add(beIn);
            this.publication.saveBusiness(sb);
            BusinessDetail bdnew = this.inquiry.getBusinessDetail(gb);
            List beOutListNew = bdnew.getBusinessEntity();
            BusinessEntity beOutNew = (BusinessEntity)beOutListNew.get(0);
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)beOutNew.getBusinessKey());
            junit.framework.Assert.assertNotNull((Object)beOutNew.getBusinessServices());
            junit.framework.Assert.assertEquals((int)2, (int)beOutNew.getBusinessServices().getBusinessService().size());
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deleteBusinesses(String authInfo, String businessXML, String businessKey, int numberOfCopies) {
        try {
            for (int i = 0; i < numberOfCopies; ++i) {
                String key = businessKey + "-" + i;
                DeleteBusiness db = new DeleteBusiness();
                db.setAuthInfo(authInfo);
                db.getBusinessKey().add(key);
                this.publication.deleteBusiness(db);
                this.logger.debug((Object)("Deleted business with key " + key));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deleteBusiness(String authInfo, String businessXML, String businessKey) {
        try {
            DeleteBusiness db = new DeleteBusiness();
            db.setAuthInfo(authInfo);
            db.getBusinessKey().add(businessKey);
            this.publication.deleteBusiness(db);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

