/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.Remote;
import java.util.HashMap;
import org.apache.juddi.v3.client.transport.InVMTransport;
import org.apache.juddi.v3.client.transport.wrapper.Handler;
import org.apache.juddi.v3.client.transport.wrapper.RequestHandler;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.v3_service.UDDISecurityPortType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UDDISecurityService {
    private HashMap<String, Handler> operations = new HashMap();

    public UDDISecurityService() {
        this.operations.put("get_authToken", new Handler("getAuthToken", GetAuthToken.class));
        this.operations.put("discard_authToken", new Handler("discardAuthToken", DiscardAuthToken.class));
    }

    public void validateRequest(String operation, String version, Element uddiReq) throws UnsupportedOperationException {
        if (version == null) {
            throw new UnsupportedOperationException("version needs to be 3.0");
        }
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
    }

    public Node secure(Element uddiReq) throws Exception {
        InVMTransport invmtransport = new InVMTransport();
        UDDISecurityPortType security = invmtransport.getUDDISecurityService();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setUddiReq(uddiReq);
        requestHandler.setPortType((Remote)security);
        String operation = requestHandler.getOperation(uddiReq);
        Handler opHandler = this.operations.get(operation);
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        String version = requestHandler.getVersion(uddiReq, operation);
        this.validateRequest(operation, version, uddiReq);
        Thread thread = new Thread((Runnable)requestHandler, "WorkThread");
        thread.start();
        thread.join();
        if (requestHandler.getException() != null) {
            throw new Exception(requestHandler.getException());
        }
        return requestHandler.getResponse();
    }
}

