/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.net.URI;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.apache.log4j.Logger;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class RMITransport
implements Transport {
    InitialContext context = null;
    private Logger logger = Logger.getLogger(this.getClass());
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public RMITransport() throws NamingException, ConfigurationException {
        Properties env = new Properties();
        String factoryInitial = ClientConfig.getConfiguration().getString("java.naming.factory.initial");
        String factoryURLPkgs = ClientConfig.getConfiguration().getString("java.naming.factory.url.pkgs");
        String factoryNamingProvider = ClientConfig.getConfiguration().getString("java.naming.provider.url");
        if (factoryInitial != null && factoryInitial != "") {
            env.setProperty("java.naming.factory.initial", factoryInitial);
        }
        if (factoryURLPkgs != null && factoryURLPkgs != "") {
            env.setProperty("java.naming.factory.url.pkgs", factoryURLPkgs);
        }
        if (factoryNamingProvider != null && factoryNamingProvider != "") {
            env.setProperty("java.naming.provider.url", factoryNamingProvider);
        }
        this.logger.debug((Object)("Initial Context using env=" + env.toString()));
        this.context = new InitialContext(env);
    }

    public UDDIInquiryPortType getUDDIInquiryService() throws TransportException {
        if (this.inquiryService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.inquiry.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.inquiryService = (UDDIInquiryPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    public UDDISecurityPortType getUDDISecurityService() throws TransportException {
        if (this.securityService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.security.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.securityService = (UDDISecurityPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    public UDDIPublicationPortType getUDDIPublishService() throws TransportException {
        if (this.publishService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.publish.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.publishService = (UDDIPublicationPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    public UDDISubscriptionPortType getUDDISubscriptionService() throws TransportException {
        if (this.subscriptionService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.subscriptionService = (UDDISubscriptionPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService() throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.subscription.listener.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    public UDDICustodyTransferPortType getUDDICustodyTransferService() throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.custodytransfer.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.custodyTransferService = (UDDICustodyTransferPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    public JUDDIApiPortType getJUDDIApiService() throws TransportException {
        if (this.publisherService == null) {
            try {
                String endpointURL = ClientConfig.getConfiguration().getString("uddi.juddi.api.url");
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug((Object)("Looking up service=" + service));
                Object requestHandler = this.context.lookup(service);
                this.publisherService = (JUDDIApiPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }
}

