/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping.wsdl;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.mapping.Common2UDDI;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.wsdl.WSDL2UDDI;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.api_v3.TModelList;
import org.w3c.dom.Element;

public class BPEL2UDDI
extends AnnotationProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private String keyDomainURI;
    private UDDIClerk clerk;
    private String lang;
    private URLLocalizer urlLocalizer;
    private String businessKey;
    private Properties properties = new Properties();
    private WSDL2UDDI wsdl2UDDI;

    public BPEL2UDDI(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws ConfigurationException {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        this.keyDomainURI = "uddi:" + properties.getProperty("keyDomain") + ":";
        this.businessKey = UDDIKeyConvention.getBusinessKey(properties);
        this.lang = properties.getProperty("lang", "en");
        this.wsdl2UDDI = new WSDL2UDDI(clerk, urlLocalizer, properties);
    }

    public String getKeyDomainURI() {
        return this.keyDomainURI;
    }

    public void setKeyDomainURI(String keyDomainURI) {
        this.keyDomainURI = keyDomainURI;
    }

    public UDDIClerk getClerk() {
        return this.clerk;
    }

    public void setClerk(UDDIClerk clerk) {
        this.clerk = clerk;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public URLLocalizer getUrlLocalizer() {
        return this.urlLocalizer;
    }

    public void setUrlLocalizer(URLLocalizer urlLocalizer) {
        this.urlLocalizer = urlLocalizer;
    }

    public BindingTemplate register(QName serviceName, String portName, URL serviceUrl, Definition wsdlDefinition) throws WSDLException, MalformedURLException, RemoteException, ConfigurationException, TransportException {
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        String genericWSDLURL = wsdlDefinition.getDocumentBaseURI();
        String bpelOverviewURL = "http://localhost:8080/bpel-console/";
        String serviceKey = UDDIKeyConvention.getServiceKey(this.properties, serviceName.getLocalPart());
        BusinessService service = this.lookupService(serviceKey);
        if (service == null) {
            ArrayList<TModel> tModels = new ArrayList<TModel>();
            Map portTypes = wsdlDefinition.getAllPortTypes();
            tModels.addAll(this.createWSDLPortTypeTModels(genericWSDLURL, portTypes));
            Map bindings = wsdlDefinition.getAllBindings();
            tModels.addAll(this.createWSDLBindingTModels(genericWSDLURL, bindings));
            TModel bpel4WSTModel = this.createBPEL4WSProcessTModel(serviceName, targetNamespace, portTypes, bpelOverviewURL);
            tModels.add(bpel4WSTModel);
            for (TModel tModel : tModels) {
                this.clerk.register(tModel);
            }
            service = this.createBusinessService(serviceName, wsdlDefinition);
            this.clerk.register(service);
        }
        BindingTemplate binding = this.createBPELBinding(serviceName, portName, serviceUrl, wsdlDefinition);
        this.clerk.register(binding);
        return binding;
    }

    public String unRegister(QName serviceName, String portName, URL serviceUrl) throws RemoteException, ConfigurationException, TransportException {
        String serviceKey = UDDIKeyConvention.getServiceKey(this.properties, serviceName.getLocalPart());
        BusinessService service = this.lookupService(serviceKey);
        boolean isRemoveServiceIfNoTemplates = true;
        String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceName, portName, serviceUrl);
        for (BindingTemplate bindingTemplate : service.getBindingTemplates().getBindingTemplate()) {
            TModel bpel4WSTModel;
            CategoryBag categoryBag;
            List tModelPortTypeList;
            if (!bindingKey.equals(bindingTemplate.getBindingKey())) continue;
            this.clerk.unRegisterBinding(bindingKey);
            if (service.getBindingTemplates().getBindingTemplate().size() != 1 || !isRemoveServiceIfNoTemplates) break;
            this.clerk.unRegisterService(serviceKey);
            FindTModel findTmodelForProcessName = this.createFindTModelForProcessName(serviceName);
            TModelList tModelList = this.clerk.findTModel(findTmodelForProcessName);
            if (tModelList == null || tModelList.getTModelInfos() == null || tModelList.getTModelInfos().getTModelInfo() == null) break;
            TModelInfo tModelInfo = (TModelInfo)tModelList.getTModelInfos().getTModelInfo().get(0);
            String bpel4WSTModelKey = tModelInfo.getTModelKey();
            this.clerk.unRegisterTModel(bpel4WSTModelKey);
            GetTModelDetail findAllPortTypesForProcess = this.createFindAllPortTypesForProcess_1(bpel4WSTModelKey);
            TModelDetail tModelDetail = this.clerk.getTModelDetail(findAllPortTypesForProcess);
            if (tModelDetail == null || (tModelPortTypeList = tModelDetail.getTModel()) == null || tModelPortTypeList.size() <= 0 || (categoryBag = (bpel4WSTModel = (TModel)tModelPortTypeList.get(0)).getCategoryBag()) == null || categoryBag.getKeyedReference() == null) break;
            ArrayList<KeyedReference> portTypeTModelKeys = new ArrayList<KeyedReference>();
            KeyedReference namespaceRef = null;
            for (KeyedReference keyedReference : categoryBag.getKeyedReference()) {
                if ("uddi:uddi.org:wsdl:porttypereference".equals(keyedReference.getTModelKey())) {
                    portTypeTModelKeys.add(keyedReference);
                }
                if (!"uddi:uddi.org:xml:namespace".equals(keyedReference.getTModelKey())) continue;
                namespaceRef = keyedReference;
            }
            String namespace = null;
            if (namespaceRef != null) {
                namespace = namespaceRef.getKeyValue();
            }
            for (KeyedReference keyedReference : portTypeTModelKeys) {
                FindTModel findBindingTModel = WSDL2UDDI.createFindBindingTModelForPortType(keyedReference.getKeyValue(), namespace);
                TModelList bindingTmodels = this.clerk.findTModel(findBindingTModel);
                if (bindingTmodels != null && bindingTmodels.getTModelInfos() != null && bindingTmodels.getTModelInfos().getTModelInfo() != null) {
                    for (TModelInfo bindingTModelInfo : bindingTmodels.getTModelInfos().getTModelInfo()) {
                        this.clerk.unRegisterTModel(bindingTModelInfo.getTModelKey());
                    }
                }
                this.clerk.unRegisterTModel(keyedReference.getKeyValue());
            }
        }
        return service.getServiceKey();
    }

    public BusinessService lookupService(String serviceKey) throws RemoteException, ConfigurationException, TransportException {
        BusinessService service = this.clerk.getServiceDetail(serviceKey);
        return service;
    }

    public BusinessService createBusinessService(QName serviceName, Definition wsdlDefinition) {
        Element docElement;
        this.log.debug((Object)("Constructing Service UDDI Information for " + serviceName));
        BusinessService service = new BusinessService();
        service.setBusinessKey(this.businessKey);
        service.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceName.getLocalPart()));
        String serviceDescription = this.properties.getProperty("serviceDescription", "Default service description when no <wsdl:document> element is defined inside the <wsdl:service> element.");
        if (wsdlDefinition.getService(serviceName) != null && (docElement = wsdlDefinition.getService(serviceName).getDocumentationElement()) != null && docElement.getTextContent() != null) {
            serviceDescription = docElement.getTextContent();
        }
        service.getDescription().addAll(Common2UDDI.mapDescription(serviceDescription, this.lang));
        Name sName = new Name();
        sName.setLang(this.lang);
        sName.setValue(serviceName.getLocalPart());
        service.getName().add(sName);
        if (this.properties.containsKey("serviceCategoryBag")) {
            String serviceCategoryBag = this.properties.getProperty("serviceCategoryBag");
            this.log.debug((Object)("Adding KeyedReferences '" + serviceCategoryBag + "' to service " + serviceName.getLocalPart()));
            CategoryBag categoryBag = this.parseCategoryBag(serviceCategoryBag);
            service.setCategoryBag(categoryBag);
        }
        return service;
    }

    public Set<TModel> createWSDLPortTypeTModels(String wsdlURL, Map<QName, PortType> portTypes) throws WSDLException {
        return this.wsdl2UDDI.createWSDLPortTypeTModels(wsdlURL, portTypes);
    }

    public Set<TModel> createWSDLBindingTModels(String wsdlURL, Map<QName, Binding> bindings) throws WSDLException {
        return this.wsdl2UDDI.createWSDLBindingTModels(wsdlURL, bindings);
    }

    public TModel createBPEL4WSProcessTModel(QName serviceName, String targetNamespace, Map<QName, PortType> portTypes, String bpelOverviewURL) {
        TModel tModel = new TModel();
        tModel.setTModelKey(this.keyDomainURI + serviceName.getLocalPart() + "Process");
        Name name = new Name();
        name.setLang("en");
        name.setValue(serviceName.getLocalPart());
        tModel.setName(name);
        OverviewURL overviewURL = new OverviewURL();
        overviewURL.setValue("http://localhost:8080/bpel-console/");
        OverviewDoc overviewDoc = new OverviewDoc();
        overviewDoc.setOverviewURL(overviewURL);
        tModel.getOverviewDoc().add(overviewDoc);
        CategoryBag categoryBag = new CategoryBag();
        if (targetNamespace != null) {
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", targetNamespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference typesReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:bpel:types", "uddi-org:bpel:types", "process");
        categoryBag.getKeyedReference().add(typesReference);
        for (QName qName : portTypes.keySet()) {
            String portTypeKey = this.keyDomainURI + qName.getLocalPart();
            KeyedReference portTypeReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", "uddi-org:wsdl:portTypeReference", portTypeKey);
            categoryBag.getKeyedReference().add(portTypeReference);
        }
        tModel.setCategoryBag(categoryBag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)new PrintUDDI().print((Object)tModel));
        }
        return tModel;
    }

    public BindingTemplate createBPELBinding(QName serviceName, String portName, URL serviceUrl, Definition wsdlDefinition) {
        BindingTemplate bindingTemplate = new BindingTemplate();
        bindingTemplate.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceName.getLocalPart()));
        String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceName, portName, serviceUrl);
        bindingTemplate.setBindingKey(bindingKey);
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setUseType(AccessPointType.END_POINT.toString());
        accessPoint.setValue(this.urlLocalizer.rewrite(serviceUrl));
        bindingTemplate.setAccessPoint(accessPoint);
        Service service = wsdlDefinition.getService(serviceName);
        if (service != null) {
            TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
            Port port = service.getPort(portName);
            if (port != null) {
                Binding binding = port.getBinding();
                String bindingDescription = this.properties.getProperty("bindingDescription", "Default binding description when no <wsdl:document> element is defined inside the <wsdl:binding> element.");
                Element docElement = binding.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    bindingDescription = docElement.getTextContent();
                }
                bindingTemplate.getDescription().addAll(Common2UDDI.mapDescription(bindingDescription, this.lang));
                TModelInstanceInfo tModelInstanceInfoBinding = new TModelInstanceInfo();
                tModelInstanceInfoBinding.setTModelKey(this.keyDomainURI + binding.getQName().getLocalPart());
                InstanceDetails instanceDetails = new InstanceDetails();
                instanceDetails.setInstanceParms(portName);
                tModelInstanceInfoBinding.setInstanceDetails(instanceDetails);
                tModelInstanceInfoBinding.getDescription().addAll(Common2UDDI.mapDescription("The wsdl:binding that this wsdl:port implements. " + bindingDescription + " The instanceParms specifies the port local name.", this.lang));
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoBinding);
                PortType portType = binding.getPortType();
                TModelInstanceInfo tModelInstanceInfoPortType = new TModelInstanceInfo();
                tModelInstanceInfoPortType.setTModelKey(this.keyDomainURI + portType.getQName().getLocalPart());
                String portTypeDescription = "";
                docElement = portType.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    portTypeDescription = docElement.getTextContent();
                }
                tModelInstanceInfoPortType.getDescription().addAll(Common2UDDI.mapDescription("The wsdl:portType that this wsdl:port implements." + portTypeDescription, this.lang));
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoPortType);
                TModelInstanceInfo tModelInstanceInfoBPEL = new TModelInstanceInfo();
                tModelInstanceInfoBPEL.setTModelKey(this.keyDomainURI + service.getQName().getLocalPart() + "Process");
                String serviceDescription = this.properties.getProperty("serviceDescription", "Default service description when no <wsdl:document> element is defined inside the <wsdl:service> element.");
                docElement = wsdlDefinition.getService(serviceName).getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    serviceDescription = docElement.getTextContent();
                }
                tModelInstanceInfoBPEL.getDescription().addAll(Common2UDDI.mapDescription("The bpel:process this wsdl:port supports." + serviceDescription, this.lang));
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoBPEL);
                bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
            } else {
                this.log.error((Object)("Could not find Port with portName: " + portName));
            }
        } else {
            this.log.error((Object)("Could not find Service with serviceName: " + serviceName.getLocalPart()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)new PrintUDDI().print((Object)bindingTemplate));
        }
        return bindingTemplate;
    }

    public FindTModel createFindTModelForProcessName(QName serviceName) {
        FindTModel findTModel = new FindTModel();
        Name name = new Name();
        name.setValue(serviceName.getLocalPart());
        findTModel.setName(name);
        CategoryBag categoryBag = new CategoryBag();
        String namespace = serviceName.getNamespaceURI();
        if (namespace != null && namespace.length() != 0) {
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference typesReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:bpel:types", "uddi-org:bpel:types", "process");
        categoryBag.getKeyedReference().add(typesReference);
        findTModel.setCategoryBag(categoryBag);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)new PrintUDDI().print((Object)findTModel));
        }
        return findTModel;
    }

    public FindTModel createFindProcessesForPortTypes(String portTypeKey) {
        FindTModel findTModel = new FindTModel();
        CategoryBag categoryBag = new CategoryBag();
        KeyedReference typesReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:bpel:types", "uddi-org:bpel:types", "process");
        categoryBag.getKeyedReference().add(typesReference);
        KeyedReference portTypeReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", "uddi-org:wsdl:portTypeReference", portTypeKey);
        categoryBag.getKeyedReference().add(portTypeReference);
        findTModel.setCategoryBag(categoryBag);
        return findTModel;
    }

    public GetTModelDetail createFindAllPortTypesForProcess_1(String processKey) {
        GetTModelDetail getTModelDetail = new GetTModelDetail();
        getTModelDetail.getTModelKey().add(processKey);
        return getTModelDetail;
    }

    public GetTModelDetail createFindAllPortTypesForProcess_2(List<String> portTypeTModelKeys) {
        GetTModelDetail getTModelDetail = new GetTModelDetail();
        for (String tModelKey : portTypeTModelKeys) {
            getTModelDetail.getTModelKey().add(tModelKey);
        }
        return getTModelDetail;
    }

    public FindBinding createFindImplementationsForProcess(String processKey) {
        FindBinding findBinding = new FindBinding();
        TModelBag tModelBag = new TModelBag();
        tModelBag.getTModelKey().add(processKey);
        return findBinding;
    }
}

