/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.sub_v3.CoveragePeriod;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class UddiSubscribeValidate {
    private UDDISecurityPortType security = null;
    private UDDISubscriptionPortType uddiSubscriptionService = null;

    public UddiSubscribeValidate() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.uddiSubscriptionService = transport.getUDDISubscriptionService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UddiSubscribeValidate(Transport transport) {
        try {
            this.security = transport.getUDDISecurityService();
            this.uddiSubscriptionService = transport.getUDDISubscriptionService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void go(String authtoken, String key) {
        if (key == null) {
            System.out.println("No key was specified!");
            return;
        }
        try {
            if (authtoken == null) {
                GetAuthToken getAuthTokenRoot = new GetAuthToken();
                getAuthTokenRoot.setUserID("root");
                getAuthTokenRoot.setCred("root");
                AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
                System.out.println("root AUTHTOKEN = don't log 'em");
                authtoken = rootAuthToken.getAuthInfo();
            }
            DatatypeFactory df = DatatypeFactory.newInstance();
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(System.currentTimeMillis());
            XMLGregorianCalendar xcal = df.newXMLGregorianCalendar(gcal);
            GetSubscriptionResults req = new GetSubscriptionResults();
            req.setAuthInfo(authtoken);
            req.setSubscriptionKey(key);
            req.setCoveragePeriod(new CoveragePeriod());
            req.getCoveragePeriod().setEndPoint(xcal);
            gcal = new GregorianCalendar();
            gcal.add(2, -1);
            req.getCoveragePeriod().setStartPoint(df.newXMLGregorianCalendar(gcal));
            SubscriptionResultsList subscriptionResults = this.uddiSubscriptionService.getSubscriptionResults(req);
            System.out.println("items modified: " + subscriptionResults.getBusinessDetail().getBusinessEntity().size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiSubscribeValidate sp = new UddiSubscribeValidate();
        sp.go(null, null);
    }
}

