/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXB;
import javax.xml.ws.BindingProvider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.uddi.repl_v3.ChangeRecord;
import org.uddi.repl_v3.ChangeRecordIDType;
import org.uddi.repl_v3.ChangeRecords;
import org.uddi.repl_v3.DoPing;
import org.uddi.repl_v3.GetChangeRecords;
import org.uddi.repl_v3.HighWaterMarkVectorType;
import org.uddi.v3_service.UDDIReplicationPortType;

class UddiReplication {
    private UDDIReplicationPortType uddiReplicationPort = new UDDIService().getUDDIReplicationPort();

    public UddiReplication(UDDIClient client, String nodename) throws ConfigurationException {
        ((BindingProvider)this.uddiReplicationPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", client.getClientConfig().getUDDINode(nodename).getReplicationUrl());
    }

    protected String doPing() {
        try {
            String doPing = this.uddiReplicationPort.doPing(new DoPing());
            System.out.println("Ping Success, remote node's id is " + doPing);
            return doPing;
        }
        catch (Exception ex) {
            Logger.getLogger(UddiReplication.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected void getHighWatermarks() {
        try {
            List highWaterMarks = this.uddiReplicationPort.getHighWaterMarks();
            System.out.println("Success....");
            System.out.println("Node, USN");
            for (int i = 0; i < highWaterMarks.size(); ++i) {
                System.out.println(((ChangeRecordIDType)highWaterMarks.get(i)).getNodeID() + ", " + ((ChangeRecordIDType)highWaterMarks.get(i)).getOriginatingUSN());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UddiReplication.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void getChangeRecords(Long record, String sourcenode) {
        try {
            HighWaterMarkVectorType highWaterMarkVectorType = new HighWaterMarkVectorType();
            highWaterMarkVectorType.getHighWaterMark().add(new ChangeRecordIDType(this.doPing(), record));
            GetChangeRecords req = new GetChangeRecords();
            req.setRequestingNode(sourcenode);
            req.setChangesAlreadySeen(highWaterMarkVectorType);
            req.setResponseLimitCount(BigInteger.valueOf(100L));
            ChangeRecords res = this.uddiReplicationPort.getChangeRecords(req);
            List changeRecords = res.getChangeRecord();
            System.out.println("Success...." + changeRecords.size() + " records returned");
            System.out.println("Node, USN, type");
            for (int i = 0; i < changeRecords.size(); ++i) {
                System.out.println(((ChangeRecord)changeRecords.get(i)).getChangeID().getNodeID() + ", " + ((ChangeRecord)changeRecords.get(i)).getChangeID().getOriginatingUSN() + ": " + this.getChangeType((ChangeRecord)changeRecords.get(i)));
                JAXB.marshal(changeRecords.get(i), (OutputStream)System.out);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UddiReplication.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected String getChangeType(ChangeRecord get) {
        if (get.getChangeRecordAcknowledgement() != null) {
            return "ACK";
        }
        if (get.getChangeRecordConditionFailed() != null) {
            return "ConditionFailed";
        }
        if (get.getChangeRecordCorrection() != null) {
            return "Correction";
        }
        if (get.getChangeRecordDelete() != null) {
            return "Deletion";
        }
        if (get.getChangeRecordDeleteAssertion() != null) {
            return "Delete Assertion";
        }
        if (get.getChangeRecordHide() != null) {
            return "Hide tmodel";
        }
        if (get.getChangeRecordNewData() != null) {
            return "New Data";
        }
        if (get.getChangeRecordNewDataConditional() != null) {
            return "New data conditional";
        }
        if (get.getChangeRecordNull() != null) {
            return "Null";
        }
        if (get.getChangeRecordPublisherAssertion() != null) {
            return "New publisher assertion";
        }
        return null;
    }
}

