/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.commons.codec.binary.Base64;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.custody_v3.KeyBag;
import org.uddi.custody_v3.TransferEntities;
import org.uddi.custody_v3.TransferToken;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiCustodyTransfer {
    private UDDISecurityPortType security = null;
    private UDDIPublicationPortType publish = null;
    private UDDIInquiryPortType uddiInquiryService = null;
    private UDDICustodyTransferPortType custodyTransferPortType = null;

    public UddiCustodyTransfer() {
        try {
            UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.publish = transport.getUDDIPublishService();
            this.uddiInquiryService = transport.getUDDIInquiryService();
            this.custodyTransferPortType = transport.getUDDICustodyTransferService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void main(String[] args) throws Exception {
        UddiCustodyTransfer sp = new UddiCustodyTransfer();
        GetAuthToken getAuthTokenRoot = new GetAuthToken();
        getAuthTokenRoot.setUserID("root");
        getAuthTokenRoot.setCred("root");
        AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
        System.out.println("root AUTHTOKEN = don't log auth tokens!");
        getAuthTokenRoot = new GetAuthToken();
        getAuthTokenRoot.setUserID("uddi");
        getAuthTokenRoot.setCred("uddi");
        AuthToken uddiAuthToken = this.security.getAuthToken(getAuthTokenRoot);
        System.out.println("uddi AUTHTOKEN = don't log auth tokens!");
        BusinessEntity biz = sp.createBusiness("uddi");
        SaveBusiness sb = new SaveBusiness();
        sb.setAuthInfo(uddiAuthToken.getAuthInfo());
        sb.getBusinessEntity().add(biz);
        BusinessDetail saveBusiness = this.publish.saveBusiness(sb);
        sp.transferBusiness(uddiAuthToken.getAuthInfo(), "uddi", rootAuthToken.getAuthInfo(), "root", ((BusinessEntity)saveBusiness.getBusinessEntity().get(0)).getBusinessKey());
    }

    public void transferBusiness(String fromUser, String fromUserAuthToken, String toUser, String toUserAuthToken, String BusinessKey) throws Exception {
        System.out.println("Transfering business key " + BusinessKey);
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        KeyBag kb = new KeyBag();
        kb.getKey().add(BusinessKey);
        Holder nodeidOUT = new Holder();
        Holder expiresOUT = new Holder();
        Holder tokenOUT = new Holder();
        this.custodyTransferPortType.getTransferToken(fromUserAuthToken, kb, nodeidOUT, expiresOUT, tokenOUT);
        System.out.println("Transfer token obtained. Give this to user " + toUser);
        System.out.println("Expires " + ((XMLGregorianCalendar)expiresOUT.value).toXMLFormat());
        System.out.println("Node " + (String)nodeidOUT.value);
        System.out.println("Token " + Base64.encodeBase64String((byte[])((byte[])tokenOUT.value)));
        if (toUser == null || toUser.length() == 0 || toUserAuthToken == null || toUserAuthToken.length() == 0) {
            System.out.println("The toUser parameters are either null or empty, I can't complete the transfer here");
            return;
        }
        TransferEntities te = new TransferEntities();
        te.setAuthInfo(toUserAuthToken);
        te.setKeyBag(kb);
        TransferToken tt = new TransferToken();
        tt.setExpirationTime((XMLGregorianCalendar)expiresOUT.value);
        tt.setNodeID((String)nodeidOUT.value);
        tt.setOpaqueToken((byte[])tokenOUT.value);
        te.setTransferToken(tt);
        System.out.println("Excuting transfer...");
        this.custodyTransferPortType.transferEntities(te);
        System.out.println("Complete! verifing ownership change...");
        GetOperationalInfo go = new GetOperationalInfo();
        go.setAuthInfo(fromUserAuthToken);
        go.getEntityKey().add(BusinessKey);
        OperationalInfos operationalInfo = this.uddiInquiryService.getOperationalInfo(go);
        boolean ok = false;
        boolean found = false;
        for (int i = 0; i < operationalInfo.getOperationalInfo().size(); ++i) {
            if (!((OperationalInfo)operationalInfo.getOperationalInfo().get(i)).getEntityKey().equalsIgnoreCase(BusinessKey)) continue;
            found = true;
            if (((OperationalInfo)operationalInfo.getOperationalInfo().get(i)).getAuthorizedName().equalsIgnoreCase(fromUser)) {
                System.out.println("Transfer unexpected failed");
            }
            if (!((OperationalInfo)operationalInfo.getOperationalInfo().get(i)).getAuthorizedName().equalsIgnoreCase(toUser)) continue;
            ok = true;
        }
        if (!found) {
            System.out.println("Could get the operational info the transfed business");
        }
        System.out.println("Transfer " + (ok ? "success" : " failed"));
    }

    private BusinessEntity createBusiness(String user) {
        BusinessEntity be = new BusinessEntity();
        be.getName().add(new Name(user + "'s business", null));
        return be;
    }
}

