/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.Address;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Contact;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.Phone;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class SimpleBrowse {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;

    public SimpleBrowse() {
        try {
            UDDIClient client = new UDDIClient("META-INF/simple-browse-uddi.xml");
            Transport transport = client.getTransport("default");
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SimpleBrowse sp = new SimpleBrowse();
        sp.browse(args);
    }

    public SimpleBrowse(Transport transport) {
        try {
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void browse(String[] args) {
        try {
            String token = this.getAuthKey("uddi", "uddi");
            BusinessList findBusiness = this.getBusinessList(token, null, 0, 100);
            this.printBusinessInfo(findBusiness.getBusinessInfos());
            this.printBusinessDetails(findBusiness.getBusinessInfos(), token);
            this.printServiceDetailsByBusiness(findBusiness.getBusinessInfos(), token);
            this.security.discardAuthToken(new DiscardAuthToken(token));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BusinessList getBusinessList(String token, String query, int offset, int maxrecords) throws Exception {
        FindBusiness fb = new FindBusiness();
        fb.setAuthInfo(token);
        FindQualifiers fq = new FindQualifiers();
        fq.getFindQualifier().add("approximateMatch");
        fb.setFindQualifiers(fq);
        Name searchname = new Name();
        if (query == null || query.equalsIgnoreCase("")) {
            searchname.setValue("%");
        } else {
            searchname.setValue(query);
        }
        fb.getName().add(searchname);
        fb.setListHead(Integer.valueOf(offset));
        fb.setMaxRows(Integer.valueOf(maxrecords));
        BusinessList findBusiness = this.inquiry.findBusiness(fb);
        return findBusiness;
    }

    private String catBagToString(CategoryBag categoryBag) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (categoryBag == null) {
            return "no data";
        }
        for (i = 0; i < categoryBag.getKeyedReference().size(); ++i) {
            sb.append(this.keyedReferenceToString((KeyedReference)categoryBag.getKeyedReference().get(i)));
        }
        for (i = 0; i < categoryBag.getKeyedReferenceGroup().size(); ++i) {
            sb.append("Key Ref Grp: TModelKey=");
            for (int k = 0; k < ((KeyedReferenceGroup)categoryBag.getKeyedReferenceGroup().get(i)).getKeyedReference().size(); ++k) {
                sb.append(this.keyedReferenceToString((KeyedReference)((KeyedReferenceGroup)categoryBag.getKeyedReferenceGroup().get(i)).getKeyedReference().get(k)));
            }
        }
        return sb.toString();
    }

    private String keyedReferenceToString(KeyedReference item) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key Ref: Name=").append(item.getKeyName()).append(" Value=").append(item.getKeyValue()).append(" tModel=").append(item.getTModelKey()).append(System.getProperty("line.separator"));
        return sb.toString();
    }

    private void printContacts(Contacts contacts) {
        if (contacts == null) {
            return;
        }
        for (int i = 0; i < contacts.getContact().size(); ++i) {
            int k;
            System.out.println("Contact " + i + " type:" + ((Contact)contacts.getContact().get(i)).getUseType());
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getPersonName().size(); ++k) {
                System.out.println("Name: " + ((PersonName)((Contact)contacts.getContact().get(i)).getPersonName().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getEmail().size(); ++k) {
                System.out.println("Email: " + ((Email)((Contact)contacts.getContact().get(i)).getEmail().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getAddress().size(); ++k) {
                System.out.println("Address sort code " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getSortCode());
                System.out.println("Address use type " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getUseType());
                System.out.println("Address tmodel key " + ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getTModelKey());
                for (int x = 0; x < ((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().size(); ++x) {
                    System.out.println("Address line value " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getValue());
                    System.out.println("Address line key name " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getKeyName());
                    System.out.println("Address line key value " + ((AddressLine)((Address)((Contact)contacts.getContact().get(i)).getAddress().get(k)).getAddressLine().get(x)).getKeyValue());
                }
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getDescription().size(); ++k) {
                System.out.println("Desc: " + ((Description)((Contact)contacts.getContact().get(i)).getDescription().get(k)).getValue());
            }
            for (k = 0; k < ((Contact)contacts.getContact().get(i)).getPhone().size(); ++k) {
                System.out.println("Phone: " + ((Phone)((Contact)contacts.getContact().get(i)).getPhone().get(k)).getValue());
            }
        }
    }

    private void printServiceDetail(BusinessService get) {
        if (get == null) {
            return;
        }
        System.out.println("Name " + this.listToString(get.getName()));
        System.out.println("Desc " + this.listToDescString(get.getDescription()));
        System.out.println("Key " + get.getServiceKey());
        System.out.println("Cat bag " + this.catBagToString(get.getCategoryBag()));
        if (!get.getSignature().isEmpty()) {
            System.out.println("Item is digitally signed");
        } else {
            System.out.println("Item is not digitally signed");
        }
        this.printBindingTemplates(get.getBindingTemplates());
    }

    private void printBindingTemplates(BindingTemplates bindingTemplates) {
        if (bindingTemplates == null) {
            return;
        }
        for (int i = 0; i < bindingTemplates.getBindingTemplate().size(); ++i) {
            System.out.println("Binding Key: " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getBindingKey());
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint() == null) continue;
            System.out.println("Access Point: " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getValue() + " type " + ((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType());
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType() == null) continue;
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType().equalsIgnoreCase(AccessPointType.END_POINT.toString())) {
                System.out.println("Use this access point value as an invocation endpoint.");
            }
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType().equalsIgnoreCase(AccessPointType.BINDING_TEMPLATE.toString())) {
                System.out.println("Use this access point value as a reference to another binding template.");
            }
            if (((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType().equalsIgnoreCase(AccessPointType.WSDL_DEPLOYMENT.toString())) {
                System.out.println("Use this access point value as a URL to a WSDL document, which presumably will have a real access point defined.");
            }
            if (!((BindingTemplate)bindingTemplates.getBindingTemplate().get(i)).getAccessPoint().getUseType().equalsIgnoreCase(AccessPointType.HOSTING_REDIRECTOR.toString())) continue;
            System.out.println("Use this access point value as an Inquiry URL of another UDDI registry, look up the same binding template there (usage varies).");
        }
    }

    public void printBusinessList(String authtoken, String searchString, boolean rawXml) throws Exception {
        int offset = 0;
        int maxrecords = 100;
        BusinessList findBusiness = this.getBusinessList(authtoken, searchString, offset, maxrecords);
        while (findBusiness != null && findBusiness.getBusinessInfos() != null && !findBusiness.getBusinessInfos().getBusinessInfo().isEmpty()) {
            if (rawXml) {
                JAXB.marshal((Object)findBusiness, (OutputStream)System.out);
            } else {
                this.printBusinessInfo(findBusiness.getBusinessInfos());
                this.printBusinessDetails(findBusiness.getBusinessInfos(), authtoken);
                this.printServiceDetailsByBusiness(findBusiness.getBusinessInfos(), authtoken);
            }
            findBusiness = this.getBusinessList(authtoken, searchString, offset += maxrecords, maxrecords);
        }
    }

    public void printServiceList(String authtoken, String searchString, boolean rawXml) throws Exception {
        int offset = 0;
        int maxrecords = 100;
        ServiceList findBusiness = this.getServiceList(authtoken, searchString, offset, maxrecords);
        while (findBusiness != null && findBusiness.getServiceInfos() != null && !findBusiness.getServiceInfos().getServiceInfo().isEmpty()) {
            if (rawXml) {
                JAXB.marshal((Object)findBusiness, (OutputStream)System.out);
            } else {
                this.printServiceInfo(findBusiness.getServiceInfos());
            }
            findBusiness = this.getServiceList(authtoken, searchString, offset += maxrecords, maxrecords);
        }
    }

    private ServiceList getServiceList(String authtoken, String searchString, int offset, int maxrecords) throws Exception {
        FindService fs = new FindService();
        fs.setAuthInfo(authtoken);
        fs.setListHead(Integer.valueOf(offset));
        fs.setMaxRows(Integer.valueOf(maxrecords));
        if (searchString != null) {
            fs.getName().add(new Name("%" + searchString + " %", null));
        } else {
            fs.getName().add(new Name("%", null));
        }
        fs.setFindQualifiers(new FindQualifiers());
        fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
        return this.inquiry.findService(fs);
    }

    void printTModelList(String authtoken, String searchString, boolean rawXml) throws Exception {
        int offset = 0;
        int maxrecords = 100;
        TModelList findBusiness = this.getTmodelList(authtoken, searchString, offset, maxrecords);
        while (findBusiness != null && findBusiness.getTModelInfos() != null && !findBusiness.getTModelInfos().getTModelInfo().isEmpty()) {
            if (rawXml) {
                JAXB.marshal((Object)findBusiness, (OutputStream)System.out);
            } else {
                this.printTModelInfo(findBusiness.getTModelInfos());
            }
            findBusiness = this.getTmodelList(authtoken, searchString, offset += maxrecords, maxrecords);
        }
    }

    private void printTModelInfo(TModelInfos tModelInfos) {
        if (tModelInfos == null) {
            System.out.println("No data returned");
            return;
        }
        for (TModelInfo tModelInfo : tModelInfos.getTModelInfo()) {
            System.out.println("tModel key: " + tModelInfo.getTModelKey());
            System.out.println("tModel name: " + tModelInfo.getName().getLang() + " " + tModelInfo.getName().getValue());
            for (int k = 0; k < tModelInfo.getDescription().size(); ++k) {
                System.out.println("Desc: " + ((Description)tModelInfo.getDescription().get(k)).getValue());
            }
        }
    }

    private TModelList getTmodelList(String authtoken, String searchString, int offset, int maxrecords) throws Exception {
        FindTModel fs = new FindTModel();
        fs.setAuthInfo(authtoken);
        fs.setListHead(Integer.valueOf(offset));
        fs.setMaxRows(Integer.valueOf(maxrecords));
        if (searchString != null) {
            fs.setName(new Name("%" + searchString + " %", null));
        } else {
            fs.setName(new Name("%", null));
        }
        fs.setFindQualifiers(new FindQualifiers());
        fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
        return this.inquiry.findTModel(fs);
    }

    private String getAuthKey(String username, String password) {
        try {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID(username);
            getAuthTokenRoot.setCred(password);
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            System.out.println(username + " AUTHTOKEN = (don't log auth tokens!");
            return rootAuthToken.getAuthInfo();
        }
        catch (Exception ex) {
            System.out.println("Could not authenticate with the provided credentials " + ex.getMessage());
            return null;
        }
    }

    private void printBusinessInfo(BusinessInfos businessInfos) {
        if (businessInfos == null) {
            System.out.println("No data returned");
        } else {
            for (int i = 0; i < businessInfos.getBusinessInfo().size(); ++i) {
                System.out.println("===============================================");
                System.out.println("Business Key: " + ((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getBusinessKey());
                System.out.println("Name: " + this.listToString(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getName()));
                System.out.println("Description: " + this.listToDescString(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getDescription()));
                System.out.println("Services:");
                this.printServiceInfo(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getServiceInfos());
            }
        }
    }

    private String listToString(List<Name> name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            sb.append(name.get(i).getValue()).append(" ");
        }
        return sb.toString();
    }

    private String listToDescString(List<Description> name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.size(); ++i) {
            sb.append(name.get(i).getValue()).append(" ");
        }
        return sb.toString();
    }

    private void printServiceInfo(ServiceInfos serviceInfos) {
        for (int i = 0; i < serviceInfos.getServiceInfo().size(); ++i) {
            System.out.println("-------------------------------------------");
            System.out.println("Service Key: " + ((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getServiceKey());
            System.out.println("Owning Business Key: " + ((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getBusinessKey());
            System.out.println("Name: " + this.listToString(((ServiceInfo)serviceInfos.getServiceInfo().get(i)).getName()));
        }
    }

    private void printBusinessDetails(BusinessInfos businessInfos, String token) throws Exception {
        GetBusinessDetail gbd = new GetBusinessDetail();
        gbd.setAuthInfo(token);
        for (int i = 0; i < businessInfos.getBusinessInfo().size(); ++i) {
            gbd.getBusinessKey().add(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getBusinessKey());
        }
        BusinessDetail businessDetail = this.inquiry.getBusinessDetail(gbd);
        for (int i = 0; i < businessDetail.getBusinessEntity().size(); ++i) {
            System.out.println("Business Detail - key: " + ((BusinessEntity)businessDetail.getBusinessEntity().get(i)).getBusinessKey());
            System.out.println("Name: " + this.listToString(((BusinessEntity)businessDetail.getBusinessEntity().get(i)).getName()));
            System.out.println("CategoryBag: " + this.catBagToString(((BusinessEntity)businessDetail.getBusinessEntity().get(i)).getCategoryBag()));
            this.printContacts(((BusinessEntity)businessDetail.getBusinessEntity().get(i)).getContacts());
        }
    }

    private void printServiceDetailsByBusiness(BusinessInfos businessInfos, String token) throws Exception {
        for (int i = 0; i < businessInfos.getBusinessInfo().size(); ++i) {
            GetServiceDetail gsd = new GetServiceDetail();
            for (int k = 0; k < ((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getServiceInfos().getServiceInfo().size(); ++k) {
                gsd.getServiceKey().add(((ServiceInfo)((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getServiceInfos().getServiceInfo().get(k)).getServiceKey());
            }
            gsd.setAuthInfo(token);
            System.out.println("Fetching data for business " + ((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getBusinessKey());
            ServiceDetail serviceDetail = this.inquiry.getServiceDetail(gsd);
            for (int k = 0; k < serviceDetail.getBusinessService().size(); ++k) {
                this.printServiceDetail((BusinessService)serviceDetail.getBusinessService().get(k));
            }
            System.out.println("................");
        }
    }

    private static enum AuthStyle {
        HTTP_BASIC,
        HTTP_DIGEST,
        HTTP_NTLM,
        UDDI_AUTH,
        HTTP_CLIENT_CERT;

    }
}

