/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import org.apache.wiki.util.XHTML;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class XhtmlUtil {
    public static final Format EXPAND_EMPTY_NODES = Format.getCompactFormat().setExpandEmptyElements(true);

    private XhtmlUtil() {
    }

    public static String serialize(Element element) {
        return XhtmlUtil.serialize(element, false);
    }

    public static String serialize(Element element, boolean pretty) {
        return XhtmlUtil.serialize(element, pretty ? Format.getPrettyFormat() : Format.getCompactFormat());
    }

    public static String serialize(Element element, Format format) {
        XMLOutputter out = new XMLOutputter(format);
        return out.outputString(element);
    }

    public static Element element(XHTML element) {
        return XhtmlUtil.element(element, null);
    }

    public static Element element(XHTML element, String content) {
        Element elt = new Element(element.name());
        if (content != null) {
            elt.addContent(content);
        }
        return elt;
    }

    public static Element link(String href, String content) {
        if (href == null) {
            throw new IllegalArgumentException("missing 'href' attribute value.");
        }
        return XhtmlUtil.fLink(href, content, null);
    }

    public static Element target(String id, String content) {
        if (id == null) {
            throw new IllegalArgumentException("missing 'id' attribute value.");
        }
        return XhtmlUtil.fLink(null, content, id);
    }

    private static Element fLink(String href, String content, String id) {
        Element a = XhtmlUtil.element(XHTML.a);
        if (href != null) {
            a.setAttribute("href", href);
        }
        if (content != null) {
            a.addContent(content);
        }
        if (id != null) {
            a.setAttribute("id", id);
        }
        return a;
    }

    public static Element img(String src, String alt) {
        Element img = XhtmlUtil.element(XHTML.img);
        if (src == null) {
            throw new IllegalArgumentException("missing 'src' attribute value.");
        }
        img.setAttribute("src", src);
        if (alt != null) {
            img.setAttribute("alt", alt);
        }
        return img;
    }

    public static Element input(String type, String name, String value) {
        Element input = XhtmlUtil.element(XHTML.input);
        if (type != null) {
            input.setAttribute("type", type);
        }
        if (name != null) {
            input.setAttribute("name", name);
        }
        if (value != null) {
            input.setAttribute("value", value);
        }
        return input;
    }

    public static void setClass(Element element, String classValue) {
        if (classValue == null) {
            throw new IllegalArgumentException("missing 'class' attribute value.");
        }
        element.setAttribute("class", classValue);
    }
}

