/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.osgi;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.johnzon.osgi.Config;
import org.apache.johnzon.osgi.cdi.RegisterCdiExtension;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    private static final Converter CONVERTER = Converters.standardConverter();
    private static final OSGi<Map.Entry<Dictionary<String, ?>, Config>> CONFIGURATION = OSGi.coalesce((OSGi[])new OSGi[]{OSGi.all((OSGi[])new OSGi[]{OSGi.configurations((String)"org.apache.johnzon.jaxrs.jsonb"), OSGi.configuration((String)"org.apache.johnzon.jaxrs.jsonb")}), OSGi.just(Hashtable::new)}).map(properties -> new AbstractMap.SimpleImmutableEntry<Dictionary, Config>((Dictionary)properties, (Config)CONVERTER.convert(properties).to(Config.class)));
    private OSGiResult _result;

    public void start(BundleContext context) throws Exception {
        this._result = OSGi.all((OSGi[])new OSGi[]{OSGi.ignore((OSGi)CONFIGURATION.flatMap(entry -> OSGi.register((String[])new String[]{MessageBodyReader.class.getName(), MessageBodyWriter.class.getName()}, (Object)new JsonbJaxrsProviderFactory((Config)entry.getValue()), this.getJaxrsExtensionProperties((Dictionary)entry.getKey(), (Config)entry.getValue())))), OSGi.ignore(RegisterCdiExtension.ifPossible())}).run(context);
    }

    public void stop(BundleContext context) throws Exception {
        this._result.close();
    }

    private Map<String, ?> getJaxrsExtensionProperties(final Dictionary<String, ?> properties, final Config config) {
        final Enumeration<String> keys = properties.keys();
        return new HashMap<String, Object>(){
            {
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.startsWith(".")) continue;
                    this.put(key, properties.get(key));
                }
                this.put("osgi.jaxrs.extension", true);
                this.put("osgi.jaxrs.name", "johnzon.jsonb");
                this.putIfAbsent("ignores", config.ignores());
                this.putIfAbsent("osgi.jaxrs.application.select", config.osgi_jaxrs_application_select());
                this.putIfAbsent("osgi.jaxrs.media.type", config.osgi_jaxrs_media_type());
                this.putIfAbsent("service.ranking", JsonbJaxrsProvider.class.getAnnotation(Priority.class).value());
            }
        };
    }

    private static Optional<String> notEmpty(String value) {
        return Optional.ofNullable(value).filter(s -> !s.isEmpty());
    }

    private static Optional<Boolean> whenTrue(boolean value) {
        return Optional.of(value).filter(b -> b == Boolean.TRUE);
    }

    private static class JsonbJaxrsProviderFactory
    implements PrototypeServiceFactory<JsonbJaxrsProvider<?>> {
        private final Config config;

        public JsonbJaxrsProviderFactory(Config config) {
            this.config = config;
        }

        public JsonbJaxrsProvider<?> getService(Bundle bundle, ServiceRegistration<JsonbJaxrsProvider<?>> registration) {
            return new ExtendedJsonbJaxrsProvider(this.config);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<JsonbJaxrsProvider<?>> registration, JsonbJaxrsProvider<?> service) {
        }
    }

    private static class ExtendedJsonbJaxrsProvider
    extends JsonbJaxrsProvider<Object> {
        public ExtendedJsonbJaxrsProvider(Config config) {
            super(Arrays.asList(config.ignores()));
            this.config.setProperty("johnzon.skip-cdi", (Object)true);
            Activator.whenTrue(config.throw_no_content_exception_on_empty_streams()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setThrowNoContentExceptionOnEmptyStreams(arg_0));
            Activator.whenTrue(config.fail_on_unknown_properties()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setFailOnUnknownProperties(arg_0));
            Activator.whenTrue(config.use_js_range()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setUseJsRange(arg_0));
            Activator.notEmpty(config.other_properties()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setOtherProperties(arg_0));
            Activator.whenTrue(config.ijson()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setIJson(arg_0));
            Activator.notEmpty(config.encoding()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setEncoding(arg_0));
            Activator.notEmpty(config.binary_datastrategy()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setBinaryDataStrategy(arg_0));
            Activator.notEmpty(config.property_naming_strategy()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPropertyNamingStrategy(arg_0));
            Activator.notEmpty(config.property_order_strategy()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPropertyOrderStrategy(arg_0));
            Activator.whenTrue(config.null_values()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setNullValues(arg_0));
            Activator.whenTrue(config.pretty()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPretty(arg_0));
            Activator.whenTrue(config.fail_on_missing_creator_values()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setFailOnMissingCreatorValues(arg_0));
            Activator.notEmpty(config.polymorphic_serialization_predicate()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPolymorphicSerializationPredicate(arg_0));
            Activator.notEmpty(config.polymorphic_deserialization_predicate()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPolymorphicDeserializationPredicate(arg_0));
            Activator.notEmpty(config.polymorphic_discriminator()).ifPresent(arg_0 -> ((ExtendedJsonbJaxrsProvider)this).setPolymorphicDiscriminator(arg_0));
        }
    }
}

