/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.polymorphism;

import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonbPolymorphismTypeInfo {
    private final List<JsonbPolymorphismTypeInfo> parents = new ArrayList<JsonbPolymorphismTypeInfo>();
    private final Class<?> clazz;
    private final String typeKey;
    private final Map<String, Class<?>> aliases;

    protected JsonbPolymorphismTypeInfo(Class<?> clazz, JsonbTypeInfo annotation) {
        this.clazz = clazz;
        if (annotation == null) {
            this.typeKey = null;
            this.aliases = null;
            return;
        }
        this.typeKey = annotation.key();
        this.aliases = new HashMap();
        for (JsonbSubtype subtype : annotation.value()) {
            this.aliases.put(subtype.alias(), subtype.type());
        }
    }

    public boolean hasSubtypeInformation() {
        return this.typeKey != null;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public Map<String, Class<?>> getAliases() {
        return this.aliases;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<JsonbPolymorphismTypeInfo> getParents() {
        return this.parents;
    }

    public JsonbPolymorphismTypeInfo getFirstParent() {
        if (this.parents.isEmpty()) {
            return null;
        }
        return this.parents.get(0);
    }
}

