/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import org.apache.commons.cli.avalon.CLOptionDescriptor;

public final class CLUtil {
    private static final int MAX_DESCRIPTION_COLUMN_LENGTH = 60;

    private CLUtil() {
    }

    public static StringBuilder describeOptions(CLOptionDescriptor[] options) {
        String lSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (CLOptionDescriptor option : options) {
            char ch = (char)option.getId();
            String name = option.getName();
            String description = option.getDescription();
            int flags = option.getFlags();
            boolean argumentOptional = (flags & 4) == 4;
            boolean argumentRequired = (flags & 2) == 2;
            boolean twoArgumentsRequired = (flags & 0x10) == 16;
            boolean needComma = false;
            if (twoArgumentsRequired) {
                argumentRequired = true;
            }
            sb.append('\t');
            if (Character.isLetter(ch)) {
                sb.append("-");
                sb.append(ch);
                needComma = true;
            }
            if (null != name) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append("--");
                sb.append(name);
            }
            if (argumentOptional) {
                sb.append(" [<argument>]");
            }
            if (argumentRequired) {
                sb.append(" <argument>");
            }
            if (twoArgumentsRequired) {
                sb.append("=<value>");
            }
            sb.append(lSep);
            if (null == description) continue;
            while (description.length() > 60) {
                String descriptionPart = description.substring(0, 60);
                description = description.substring(60);
                sb.append("\t\t");
                sb.append(descriptionPart);
                sb.append(lSep);
            }
            sb.append("\t\t");
            sb.append(description);
            sb.append(lSep);
        }
        return sb;
    }
}

