/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.TCPClient;

public abstract class TCPClientDecorator
extends AbstractTCPClient {
    protected final TCPClient tcpClient;

    public TCPClientDecorator(TCPClient tcpClient) {
        this.tcpClient = tcpClient;
    }

    public static byte[] intToByteArray(int value, int len) {
        if (len == 2 || len == 4) {
            if (len == 2 && (value < Short.MIN_VALUE || value > Short.MAX_VALUE)) {
                throw new IllegalArgumentException("Value outside range for signed short int.");
            }
            byte[] b = new byte[len];
            for (int i = 0; i < len; ++i) {
                int offset = (b.length - 1 - i) * 8;
                b[i] = (byte)(value >>> offset & 0xFF);
            }
            return b;
        }
        throw new IllegalArgumentException("Length must be specified as either 2 or 4.");
    }

    public static int byteArrayToInt(byte[] b) {
        if (b != null && (b.length == 2 || b.length == 4)) {
            int value = b[0] << (b.length - 1) * 8;
            for (int i = 1; i < b.length; ++i) {
                int offset = (b.length - 1 - i) * 8;
                value += (b[i] & 0xFF) << offset;
            }
            return value;
        }
        throw new IllegalArgumentException("Byte array is null or invalid length.");
    }
}

