/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TCPClientImpl
extends AbstractTCPClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int eolInt = JMeterUtils.getPropDefault((String)"tcp.eolByte", (int)1000);
    private static final String charset = JMeterUtils.getPropDefault((String)"tcp.charset", (String)Charset.defaultCharset().name());

    public TCPClientImpl() {
        this.setEolByte(eolInt);
        if (this.useEolByte) {
            log.info("Using eolByte=" + this.eolByte);
        }
        this.setCharset(charset);
        String configuredCharset = JMeterUtils.getProperty((String)"tcp.charset");
        if (StringUtils.isEmpty((CharSequence)configuredCharset)) {
            log.info("Using platform default charset:" + charset);
        } else {
            log.info("Using charset:" + configuredCharset);
        }
    }

    @Override
    public void write(OutputStream os, String s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("WriteS: " + this.showEOL(s));
        }
        os.write(s.getBytes(charset));
        os.flush();
    }

    @Override
    public void write(OutputStream os, InputStream is) throws IOException {
        byte[] buff = new byte[512];
        while (is.read(buff) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("WriteIS: " + this.showEOL(new String(buff, charset)));
            }
            os.write(buff);
            os.flush();
        }
    }

    @Override
    public String read(InputStream is) throws ReadException {
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int x = 0;
            while ((x = is.read(buffer)) > -1) {
                w.write(buffer, 0, x);
                if (!this.useEolByte || buffer[x - 1] != this.eolByte) continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("Read: " + w.size() + "\n" + w.toString());
            }
            return w.toString(charset);
        }
        catch (IOException e) {
            throw new ReadException("Error reading from server, bytes read: " + w.size(), e, w.toString());
        }
    }

    private String showEOL(String input) {
        StringBuilder sb = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch < ' ') {
                sb.append('[');
                sb.append((int)ch);
                sb.append(']');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

