/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.ldap.sampler.LdapClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPSampler
extends AbstractSampler {
    private static final Logger log = LoggerFactory.getLogger(LDAPSampler.class);
    private static final long serialVersionUID = 240L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.LoginConfigGui", "org.apache.jmeter.protocol.ldap.config.gui.LdapConfigGui", "org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final String SERVERNAME = "servername";
    public static final String PORT = "port";
    public static final String ROOTDN = "rootdn";
    public static final String TEST = "test";
    public static final String ADD = "add";
    public static final String MODIFY = "modify";
    public static final String DELETE = "delete";
    public static final String SEARCHBASE = "search";
    public static final String SEARCHFILTER = "searchfilter";
    public static final String USER_DEFINED = "user_defined";
    public static final String ARGUMENTS = "arguments";
    public static final String BASE_ENTRY_DN = "base_entry_dn";
    private static AtomicInteger COUNTER = new AtomicInteger(0);
    private boolean searchFoundEntries;

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public void setServername(String servername) {
        this.setProperty((JMeterProperty)new StringProperty(SERVERNAME, servername));
    }

    public void setPort(String port) {
        this.setProperty((JMeterProperty)new StringProperty(PORT, port));
    }

    public String getServername() {
        return this.getPropertyAsString(SERVERNAME);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT);
    }

    public void setRootdn(String newRootdn) {
        this.setProperty(ROOTDN, newRootdn);
    }

    public String getRootdn() {
        return this.getPropertyAsString(ROOTDN);
    }

    public void setTest(String newTest) {
        this.setProperty(TEST, newTest);
    }

    public String getTest() {
        return this.getPropertyAsString(TEST);
    }

    public void setUserDefinedTest(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USER_DEFINED, value));
    }

    public boolean getUserDefinedTest() {
        return this.getPropertyAsBoolean(USER_DEFINED);
    }

    public void setBaseEntryDN(String newbaseentry) {
        this.setProperty((JMeterProperty)new StringProperty(BASE_ENTRY_DN, newbaseentry));
    }

    public String getBaseEntryDN() {
        return this.getPropertyAsString(BASE_ENTRY_DN);
    }

    public void setArguments(Arguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)value));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    private BasicAttributes getUserAttributes() {
        BasicAttribute basicattribute = new BasicAttribute("objectclass");
        basicattribute.add("top");
        basicattribute.add("person");
        basicattribute.add("organizationalPerson");
        basicattribute.add("inetOrgPerson");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(basicattribute);
        for (JMeterProperty jMeterProperty : this.getArguments()) {
            Argument item = (Argument)jMeterProperty.getObjectValue();
            BasicAttribute attr = this.getBasicAttribute(item.getName(), item.getValue());
            attrs.put(attr);
        }
        return attrs;
    }

    private ModificationItem[] getUserModAttributes() {
        ModificationItem[] mods = new ModificationItem[this.getArguments().getArguments().size()];
        PropertyIterator iter = this.getArguments().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next().getObjectValue();
            BasicAttribute attr = this.getBasicAttribute(item.getName(), item.getValue());
            mods[count] = new ModificationItem(2, attr);
            count = 1;
        }
        return mods;
    }

    private ModificationItem[] getModificationItem() {
        ModificationItem[] mods = new ModificationItem[2];
        BasicAttribute mod0 = new BasicAttribute("userpassword", "secret");
        BasicAttribute mod1 = new BasicAttribute("mobile", "123-456-1234");
        mods[0] = new ModificationItem(2, mod0);
        mods[1] = new ModificationItem(1, mod1);
        return mods;
    }

    private BasicAttributes getBasicAttributes() {
        BasicAttributes basicattributes = new BasicAttributes();
        BasicAttribute basicattribute = new BasicAttribute("objectclass");
        basicattribute.add("top");
        basicattribute.add("person");
        basicattribute.add("organizationalPerson");
        basicattribute.add("inetOrgPerson");
        basicattributes.put(basicattribute);
        String s1 = "User";
        String s3 = "Test";
        String s5 = "user";
        String s6 = TEST;
        COUNTER.incrementAndGet();
        basicattributes.put(new BasicAttribute("givenname", s1));
        basicattributes.put(new BasicAttribute("sn", s3));
        basicattributes.put(new BasicAttribute("cn", "TestUser" + COUNTER.get()));
        basicattributes.put(new BasicAttribute("uid", s5));
        basicattributes.put(new BasicAttribute("userpassword", s6));
        this.setProperty((JMeterProperty)new StringProperty(ADD, "cn=TestUser" + COUNTER.get()));
        return basicattributes;
    }

    private BasicAttribute getBasicAttribute(String name, String value) {
        BasicAttribute attr = new BasicAttribute(name, value);
        return attr;
    }

    public String getLabel() {
        return "ldap://" + this.getServername() + ":" + this.getPort() + "/" + this.getRootdn();
    }

    private void addTest(LdapClient ldap, SampleResult res) throws NamingException {
        if (this.getPropertyAsBoolean(USER_DEFINED)) {
            res.sampleStart();
            ldap.createTest(this.getUserAttributes(), this.getPropertyAsString(BASE_ENTRY_DN));
            res.sampleEnd();
        } else {
            res.sampleStart();
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            res.sampleEnd();
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
    }

    private void deleteTest(LdapClient ldap, SampleResult res) throws NamingException {
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(DELETE, this.getPropertyAsString(ADD)));
        }
        res.sampleStart();
        ldap.deleteTest(this.getPropertyAsString(DELETE));
        res.sampleEnd();
    }

    private void searchTest(LdapClient ldap, SampleResult res) throws NamingException {
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(SEARCHBASE, this.getPropertyAsString(ADD)));
            this.setProperty((JMeterProperty)new StringProperty(SEARCHFILTER, this.getPropertyAsString(ADD)));
        }
        res.sampleStart();
        this.searchFoundEntries = ldap.searchTest(this.getPropertyAsString(SEARCHBASE), this.getPropertyAsString(SEARCHFILTER));
        res.sampleEnd();
        if (!this.getPropertyAsBoolean(USER_DEFINED)) {
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
    }

    private void modifyTest(LdapClient ldap, SampleResult res) throws NamingException {
        if (this.getPropertyAsBoolean(USER_DEFINED)) {
            res.sampleStart();
            ldap.modifyTest(this.getUserModAttributes(), this.getPropertyAsString(BASE_ENTRY_DN));
            res.sampleEnd();
        } else {
            ldap.createTest(this.getBasicAttributes(), this.getPropertyAsString(ADD));
            this.setProperty((JMeterProperty)new StringProperty(MODIFY, this.getPropertyAsString(ADD)));
            res.sampleStart();
            ldap.modifyTest(this.getModificationItem(), this.getPropertyAsString(MODIFY));
            res.sampleEnd();
            ldap.deleteTest(this.getPropertyAsString(ADD));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        boolean isSuccessful = false;
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getPropertyAsString(TEST));
        LdapClient ldap = new LdapClient();
        try {
            ldap.connect(this.getServername(), this.getPort(), this.getRootdn(), this.getUsername(), this.getPassword());
            if (this.getPropertyAsString(TEST).equals(ADD)) {
                this.addTest(ldap, res);
            } else if (this.getPropertyAsString(TEST).equals(DELETE)) {
                this.deleteTest(ldap, res);
            } else if (this.getPropertyAsString(TEST).equals(MODIFY)) {
                this.modifyTest(ldap, res);
            } else if (this.getPropertyAsString(TEST).equals(SEARCHBASE)) {
                this.searchTest(ldap, res);
            }
            if (this.getPropertyAsString(TEST).equals(SEARCHBASE) && !this.searchFoundEntries) {
                res.setResponseCode("201");
                res.setResponseMessage("OK - no results");
                res.setResponseData("successful - no results", null);
            } else {
                res.setResponseCodeOK();
                res.setResponseMessage("OK");
                res.setResponseData("successful", null);
            }
            res.setDataType("text");
            isSuccessful = true;
        }
        catch (Exception ex) {
            log.error("Ldap client - ", (Throwable)ex);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
            isSuccessful = false;
        }
        finally {
            ldap.disconnect();
        }
        res.setSuccessful(isSuccessful);
        return res;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

