/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jmeter.protocol.jms.client.ReceiveSubscriber;
import org.apache.jmeter.protocol.jms.sampler.BaseJMSSampler;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SubscriberSampler
extends BaseJMSSampler
implements Interruptible,
ThreadListener,
TestStateListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long DEFAULT_WAIT = 500L;
    private transient ReceiveSubscriber SUBSCRIBER = null;
    private volatile transient boolean interrupted = false;
    private transient long timeout;
    private transient boolean useReceive;
    private transient Exception exceptionDuringInit;
    private transient boolean stopBetweenSamples;
    private static final String CLIENT_CHOICE = "jms.client_choice";
    private static final String TIMEOUT = "jms.timeout";
    private static final String TIMEOUT_DEFAULT = "";
    private static final String DURABLE_SUBSCRIPTION_ID = "jms.durableSubscriptionId";
    private static final String CLIENT_ID = "jms.clientId";
    private static final String JMS_SELECTOR = "jms.selector";
    private static final String DURABLE_SUBSCRIPTION_ID_DEFAULT = "";
    private static final String CLIENT_ID_DEFAULT = "";
    private static final String JMS_SELECTOR_DEFAULT = "";
    private static final String STOP_BETWEEN = "jms.stop_between_samples";
    private static final String SEPARATOR = "jms.separator";
    private static final String SEPARATOR_DEFAULT = "";
    private transient boolean START_ON_SAMPLE = false;
    private transient String separator;
    private static final String RECEIVE_STR = JMeterUtils.getResString((String)"jms_subscriber_receive");

    private void initListenerClient() throws JMSException, NamingException {
        this.SUBSCRIBER = new ReceiveSubscriber(0, this.getUseJNDIPropertiesAsBoolean(), this.getJNDIInitialContextFactory(), this.getProviderUrl(), this.getConnectionFactory(), this.getDestination(), this.getDurableSubscriptionId(), this.getClientId(), this.getJmsSelector(), this.isUseAuth(), this.getUsername(), this.getPassword());
        this.setupSeparator();
        log.debug("SubscriberSampler.initListenerClient called");
    }

    private void initReceiveClient() throws NamingException, JMSException {
        this.SUBSCRIBER = new ReceiveSubscriber(this.getUseJNDIPropertiesAsBoolean(), this.getJNDIInitialContextFactory(), this.getProviderUrl(), this.getConnectionFactory(), this.getDestination(), this.getDurableSubscriptionId(), this.getClientId(), this.getJmsSelector(), this.isUseAuth(), this.getUsername(), this.getPassword());
        this.setupSeparator();
        log.debug("SubscriberSampler.initReceiveClient called");
    }

    @Override
    public SampleResult sample() {
        if (!this.isDestinationStatic()) {
            this.threadStarted(true);
        }
        SampleResult result = new SampleResult();
        result.setDataType("text");
        result.setSampleLabel(this.getName());
        result.sampleStart();
        if (this.exceptionDuringInit != null) {
            result.sampleEnd();
            result.setSuccessful(false);
            result.setResponseCode("000");
            result.setResponseMessage(this.exceptionDuringInit.toString());
            return result;
        }
        if (this.stopBetweenSamples) {
            try {
                this.SUBSCRIBER.start();
            }
            catch (JMSException e) {
                log.warn("Problem starting subscriber", (Throwable)e);
            }
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder propBuffer = new StringBuilder();
        int loop = this.getIterationCount();
        int read = 0;
        long until = 0L;
        long now = System.currentTimeMillis();
        if (this.timeout > 0L) {
            until = this.timeout + now;
        }
        while (!(this.interrupted || until != 0L && now >= until || read >= loop)) {
            try {
                Message msg = this.SUBSCRIBER.getMessage(this.calculateWait(until, now));
                if (msg != null) {
                    this.extractContent(buffer, propBuffer, msg, ++read == loop);
                }
            }
            catch (JMSException e) {
                log.warn("Error " + e.toString());
            }
            now = System.currentTimeMillis();
        }
        result.sampleEnd();
        if (this.getReadResponseAsBoolean()) {
            result.setResponseData(buffer.toString().getBytes());
        } else {
            result.setBytes((long)buffer.toString().length());
        }
        result.setResponseHeaders(propBuffer.toString());
        if (read == 0) {
            result.setResponseCode("404");
            result.setSuccessful(false);
        } else if (read < loop) {
            result.setResponseCode("500");
            result.setSuccessful(false);
        } else {
            result.setResponseCodeOK();
            result.setSuccessful(true);
        }
        result.setResponseMessage(read + " message(s) received successfully of " + loop + " expected");
        result.setSamplerData(loop + " messages expected");
        result.setSampleCount(read);
        if (this.stopBetweenSamples) {
            try {
                this.SUBSCRIBER.stop();
            }
            catch (JMSException e) {
                log.warn("Problem stopping subscriber", (Throwable)e);
            }
        }
        if (!this.isDestinationStatic()) {
            this.threadFinished(true);
        }
        return result;
    }

    private long calculateWait(long until, long now) {
        if (until == 0L) {
            return 500L;
        }
        long wait = until - now;
        return wait > 500L ? 500L : wait;
    }

    private void extractContent(StringBuilder buffer, StringBuilder propBuffer, Message msg, boolean isLast) {
        if (msg != null) {
            try {
                if (msg instanceof TextMessage) {
                    buffer.append(((TextMessage)msg).getText());
                } else if (msg instanceof ObjectMessage) {
                    ObjectMessage objectMessage = (ObjectMessage)msg;
                    if (objectMessage.getObject() != null) {
                        buffer.append(objectMessage.getObject().getClass());
                    } else {
                        buffer.append("object is null");
                    }
                } else if (msg instanceof BytesMessage) {
                    BytesMessage bytesMessage = (BytesMessage)msg;
                    buffer.append(bytesMessage.getBodyLength() + " bytes received in BytesMessage");
                } else if (msg instanceof MapMessage) {
                    MapMessage mapm = (MapMessage)msg;
                    Enumeration enumb = mapm.getMapNames();
                    while (enumb.hasMoreElements()) {
                        String name = (String)enumb.nextElement();
                        Object obj = mapm.getObject(name);
                        buffer.append(name);
                        buffer.append(",");
                        buffer.append(obj.getClass().getCanonicalName());
                        buffer.append(",");
                        buffer.append(obj);
                        buffer.append("\n");
                    }
                }
                Utils.messageProperties(propBuffer, msg);
                if (!isLast && !StringUtils.isEmpty((CharSequence)this.separator)) {
                    propBuffer.append(this.separator);
                    buffer.append(this.separator);
                }
            }
            catch (JMSException e) {
                log.error(e.getMessage());
            }
        }
    }

    public void threadStarted() {
        if (this.isDestinationStatic() || this.START_ON_SAMPLE) {
            this.timeout = this.getTimeoutAsLong();
            this.interrupted = false;
            this.exceptionDuringInit = null;
            this.useReceive = this.getClientChoice().equals("jms_subscriber_receive");
            this.stopBetweenSamples = this.isStopBetweenSamples();
            if (this.useReceive) {
                try {
                    this.initReceiveClient();
                    if (!this.stopBetweenSamples) {
                        this.SUBSCRIBER.start();
                    }
                }
                catch (JMSException | NamingException e) {
                    this.exceptionDuringInit = e;
                }
            } else {
                try {
                    this.initListenerClient();
                    if (!this.stopBetweenSamples) {
                        this.SUBSCRIBER.start();
                    }
                }
                catch (JMSException | NamingException e) {
                    this.exceptionDuringInit = e;
                }
            }
            if (this.exceptionDuringInit != null) {
                log.error("Could not initialise client", (Throwable)this.exceptionDuringInit);
            }
        }
    }

    public void threadStarted(boolean wts) {
        if (wts) {
            this.START_ON_SAMPLE = true;
        }
        this.threadStarted();
    }

    public void threadFinished() {
        if (this.SUBSCRIBER != null) {
            this.SUBSCRIBER.close();
        }
    }

    public void threadFinished(boolean wts) {
        if (wts) {
            this.START_ON_SAMPLE = false;
        }
        this.threadFinished();
    }

    public boolean interrupt() {
        boolean oldvalue = this.interrupted;
        this.interrupted = true;
        return !oldvalue;
    }

    public void setClientChoice(String choice) {
        this.setProperty(CLIENT_CHOICE, choice);
    }

    public String getClientChoice() {
        String choice = this.getPropertyAsString(CLIENT_CHOICE);
        if (choice.equals(RECEIVE_STR)) {
            choice = "jms_subscriber_receive";
        } else if (!choice.equals("jms_subscriber_receive")) {
            choice = "jms_subscriber_on_message";
        }
        return choice;
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT, "");
    }

    public long getTimeoutAsLong() {
        return this.getPropertyAsLong(TIMEOUT, 0L);
    }

    public void setTimeout(String timeout) {
        this.setProperty(TIMEOUT, timeout, "");
    }

    public String getDurableSubscriptionId() {
        return this.getPropertyAsString(DURABLE_SUBSCRIPTION_ID);
    }

    public String getClientId() {
        return this.getPropertyAsString(CLIENT_ID, "");
    }

    public String getJmsSelector() {
        return this.getPropertyAsString(JMS_SELECTOR, "");
    }

    public void setDurableSubscriptionId(String durableSubscriptionId) {
        this.setProperty(DURABLE_SUBSCRIPTION_ID, durableSubscriptionId, "");
    }

    public void setClientID(String clientId) {
        this.setProperty(CLIENT_ID, clientId, "");
    }

    public void setJmsSelector(String jmsSelector) {
        this.setProperty(JMS_SELECTOR, jmsSelector, "");
    }

    public String getSeparator() {
        return this.getPropertyAsString(SEPARATOR, "");
    }

    public void setSeparator(String text) {
        this.setProperty(SEPARATOR, text, "");
    }

    public boolean isStopBetweenSamples() {
        return this.getPropertyAsBoolean(STOP_BETWEEN, false);
    }

    public void setStopBetweenSamples(boolean selected) {
        this.setProperty(STOP_BETWEEN, selected, false);
    }

    public void testEnded() {
        InitialContextFactory.close();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
    }

    private void setupSeparator() {
        this.separator = this.getSeparator();
        this.separator = this.separator.replace("\\t", "\t");
        this.separator = this.separator.replace("\\n", "\n");
        this.separator = this.separator.replace("\\r", "\r");
    }

    private Object readResolve() {
        this.setupSeparator();
        this.exceptionDuringInit = null;
        return this;
    }
}

