/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Date;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;

public abstract class BaseJMSSampler
extends AbstractSampler {
    private static final long serialVersionUID = 240L;
    private static final String JNDI_INITIAL_CONTEXT_FAC = "jms.initial_context_factory";
    private static final String PROVIDER_URL = "jms.provider_url";
    private static final String CONN_FACTORY = "jms.connection_factory";
    private static final String DEST = "jms.topic";
    private static final String PRINCIPAL = "jms.security_principle";
    private static final String CREDENTIALS = "jms.security_credentials";
    private static final String ITERATIONS = "jms.iterations";
    private static final String USE_AUTH = "jms.authenticate";
    private static final String USE_PROPERTIES_FILE = "jms.jndi_properties";
    private static final String READ_RESPONSE = "jms.read_response";
    private static final String DESTINATION_STATIC = "jms.destination_static";
    private static final boolean DESTINATION_STATIC_DEFAULT = true;
    private static final String REQUIRED = JMeterUtils.getResString((String)"jms_auth_required");

    public SampleResult sample(Entry e) {
        return this.sample();
    }

    public abstract SampleResult sample();

    public void setJNDIIntialContextFactory(String icf) {
        this.setProperty(JNDI_INITIAL_CONTEXT_FAC, icf);
    }

    public String getJNDIInitialContextFactory() {
        return this.getPropertyAsString(JNDI_INITIAL_CONTEXT_FAC);
    }

    public void setProviderUrl(String url) {
        this.setProperty(PROVIDER_URL, url);
    }

    public String getProviderUrl() {
        return this.getPropertyAsString(PROVIDER_URL);
    }

    public void setConnectionFactory(String factory) {
        this.setProperty(CONN_FACTORY, factory);
    }

    public String getConnectionFactory() {
        return this.getPropertyAsString(CONN_FACTORY);
    }

    public void setDestination(String dest) {
        this.setProperty(DEST, dest);
    }

    public String getDestination() {
        return this.getPropertyAsString(DEST);
    }

    public void setUsername(String user) {
        this.setProperty(PRINCIPAL, user);
    }

    public String getUsername() {
        return this.getPropertyAsString(PRINCIPAL);
    }

    public void setPassword(String pwd) {
        this.setProperty(CREDENTIALS, pwd);
    }

    public String getPassword() {
        return this.getPropertyAsString(CREDENTIALS);
    }

    public void setIterations(String count) {
        this.setProperty(ITERATIONS, count);
    }

    public String getIterations() {
        return this.getPropertyAsString(ITERATIONS);
    }

    public int getIterationCount() {
        return this.getPropertyAsInt(ITERATIONS);
    }

    public void setUseAuth(boolean useAuth) {
        this.setProperty(USE_AUTH, useAuth);
    }

    public boolean isUseAuth() {
        String useAuth = this.getPropertyAsString(USE_AUTH);
        return useAuth.equalsIgnoreCase("true") || useAuth.equals(REQUIRED);
    }

    public void setReadResponse(String read) {
        this.setProperty(READ_RESPONSE, read);
    }

    public String getReadResponse() {
        return this.getPropertyAsString(READ_RESPONSE);
    }

    public boolean getReadResponseAsBoolean() {
        return this.getPropertyAsBoolean(READ_RESPONSE);
    }

    public void setUseJNDIProperties(String properties) {
        this.setProperty(USE_PROPERTIES_FILE, properties);
    }

    public String getUseJNDIProperties() {
        return this.getPropertyAsString(USE_PROPERTIES_FILE);
    }

    public boolean getUseJNDIPropertiesAsBoolean() {
        return this.getPropertyAsBoolean(USE_PROPERTIES_FILE);
    }

    public void setDestinationStatic(boolean isStatic) {
        this.setProperty(DESTINATION_STATIC, isStatic, true);
    }

    public boolean isDestinationStatic() {
        return this.getPropertyAsBoolean(DESTINATION_STATIC, true);
    }

    public static String getMessageHeaders(Message message) {
        StringBuilder response = new StringBuilder(256);
        try {
            response.append("JMS Message Header Attributes:");
            response.append("\n   Correlation ID: ");
            response.append(message.getJMSCorrelationID());
            response.append("\n   Delivery Mode: ");
            if (message.getJMSDeliveryMode() == 2) {
                response.append("PERSISTANT");
            } else {
                response.append("NON-PERSISTANT");
            }
            Destination destination = message.getJMSDestination();
            response.append("\n   Destination: ");
            response.append(destination == null ? null : destination.toString());
            response.append("\n   Expiration: ");
            response.append(new Date(message.getJMSExpiration()));
            response.append("\n   Message ID: ");
            response.append(message.getJMSMessageID());
            response.append("\n   Priority: ");
            response.append(message.getJMSPriority());
            response.append("\n   Redelivered: ");
            response.append(message.getJMSRedelivered());
            Destination replyTo = message.getJMSReplyTo();
            response.append("\n   Reply to: ");
            response.append(replyTo == null ? null : replyTo.toString());
            response.append("\n   Timestamp: ");
            response.append(new Date(message.getJMSTimestamp()));
            response.append("\n   Type: ");
            response.append(message.getJMSType());
            response.append("\n\n");
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return new String(response);
    }
}

