/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.jmeter.protocol.jms.sampler.MessageAdmin;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FixedQueueExecutor
implements QueueExecutor {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final MessageProducer producer;
    private final int timeout;
    private final boolean useReqMsgIdAsCorrelId;

    public FixedQueueExecutor(MessageProducer producer, int timeout, boolean useReqMsgIdAsCorrelId) {
        this.producer = producer;
        this.timeout = timeout;
        this.useReqMsgIdAsCorrelId = useReqMsgIdAsCorrelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message sendAndReceive(Message request, int deliveryMode, int priority, long expiration) throws JMSException {
        String id = request.getJMSCorrelationID();
        if (id == null && !this.useReqMsgIdAsCorrelId) {
            throw new IllegalArgumentException("Correlation id is null. Set the JMSCorrelationID header.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MessageAdmin admin = MessageAdmin.getAdmin();
        if (this.useReqMsgIdAsCorrelId) {
            MessageAdmin messageAdmin = admin;
            synchronized (messageAdmin) {
                this.producer.send(request, deliveryMode, priority, expiration);
                id = request.getJMSMessageID();
                admin.putRequest(id, request, countDownLatch);
            }
        } else {
            admin.putRequest(id, request, countDownLatch);
            this.producer.send(request, deliveryMode, priority, expiration);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " will wait for reply " + id + " started on " + System.currentTimeMillis());
            }
            if (this.timeout == 0) {
                countDownLatch.await();
            } else if (!countDownLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                log.debug("Timeout reached before getting a reply message");
            }
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " done waiting for " + id + " on " + request + " ended on " + System.currentTimeMillis());
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupt exception caught", (Throwable)e);
        }
        return admin.get(id);
    }
}

