/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class Utils {
    public static final String DEFAULT_PRIORITY_4 = "4";
    public static final String DEFAULT_NO_EXPIRY = "0";
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static void close(MessageConsumer closeable, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (JMSException e) {
                log.error("Error during close: ", (Throwable)e);
            }
        }
    }

    public static void close(Session closeable, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (JMSException e) {
                log.error("Error during close: ", (Throwable)e);
            }
        }
    }

    public static void close(Connection closeable, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (JMSException e) {
                log.error("Error during close: ", (Throwable)e);
            }
        }
    }

    public static void close(MessageProducer closeable, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (JMSException e) {
                log.error("Error during close: ", (Throwable)e);
            }
        }
    }

    public static String messageProperties(Message msg) {
        return Utils.messageProperties(new StringBuilder(), msg).toString();
    }

    public static StringBuilder messageProperties(StringBuilder sb, Message msg) {
        Utils.requestHeaders(sb, msg);
        sb.append("Properties:\n");
        try {
            Enumeration rme = msg.getPropertyNames();
            while (rme.hasMoreElements()) {
                String name = (String)rme.nextElement();
                sb.append(name).append('\t');
                String value = msg.getStringProperty(name);
                sb.append(value).append('\n');
            }
        }
        catch (JMSException e) {
            sb.append("\nError: " + e.toString());
        }
        return sb;
    }

    public static StringBuilder requestHeaders(StringBuilder sb, Message msg) {
        try {
            sb.append("JMSCorrelationId ").append(msg.getJMSCorrelationID()).append('\n');
            sb.append("JMSMessageId     ").append(msg.getJMSMessageID()).append('\n');
            sb.append("JMSTimestamp     ").append(msg.getJMSTimestamp()).append('\n');
            sb.append("JMSType          ").append(msg.getJMSType()).append('\n');
            sb.append("JMSExpiration    ").append(msg.getJMSExpiration()).append('\n');
            sb.append("JMSPriority      ").append(msg.getJMSPriority()).append('\n');
            sb.append("JMSDestination   ").append(msg.getJMSDestination()).append('\n');
        }
        catch (JMSException e) {
            sb.append("\nError: " + e.toString());
        }
        return sb;
    }

    public static Destination lookupDestination(Context context, String name) throws NamingException {
        Object o = context.lookup(name);
        if (o instanceof Destination) {
            return (Destination)o;
        }
        throw new NamingException("Found: " + name + "; expected Destination, but was: " + (o != null ? o.getClass().getName() : "null"));
    }

    public static final String getFromEnvironment(Context context, String key) throws NamingException {
        try {
            Hashtable<?, ?> env = context.getEnvironment();
            if (env != null) {
                return (String)env.get(key);
            }
            log.warn("context.getEnvironment() returned null (should not happen according to javadoc but non compliant implementation can return this)");
            return null;
        }
        catch (OperationNotSupportedException ex) {
            log.warn("context.getEnvironment() not supported by implementation ");
            return null;
        }
    }

    public static Connection getConnection(Context ctx, String factoryName) throws JMSException, NamingException {
        Object objfac = null;
        try {
            objfac = ctx.lookup(factoryName);
        }
        catch (NoClassDefFoundError e) {
            throw new NamingException("Lookup failed: " + e.toString());
        }
        if (objfac instanceof ConnectionFactory) {
            String username = Utils.getFromEnvironment(ctx, "java.naming.security.principal");
            if (username != null) {
                String password = Utils.getFromEnvironment(ctx, "java.naming.security.credentials");
                return ((ConnectionFactory)objfac).createConnection(username, password);
            }
            return ((ConnectionFactory)objfac).createConnection();
        }
        throw new NamingException("Expected javax.jms.ConnectionFactory, found " + (objfac != null ? objfac.getClass().getName() : "null"));
    }

    public static void addJMSProperties(Message msg, Map<String, Object> map) throws JMSException {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> me : map.entrySet()) {
            String name = me.getKey();
            Object value = me.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Adding property [" + name + "=" + value + "]");
            }
            if ("JMSCorrelationID".equalsIgnoreCase(name)) {
                msg.setJMSCorrelationID((String)value);
                continue;
            }
            msg.setObjectProperty(name, value);
        }
    }

    public static final JMSProperties convertArgumentsToJmsProperties(Arguments args) {
        JMSProperties jmsProperties = new JMSProperties();
        Map map = args.getArgumentsAsMap();
        for (Map.Entry entry : map.entrySet()) {
            jmsProperties.addJmsProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return jmsProperties;
    }
}

