/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.curl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;

public class BasicCurlParser {
    private static final int METHOD_OPT = 88;
    private static final int COMPRESSED_OPT = 99;
    private static final int HEADER_OPT = 72;
    private static final int DATA_OPT = 100;
    private static final CLOptionDescriptor D_COMPRESSED_OPT = new CLOptionDescriptor("compressed", 8, 99, "Request compressed response (using deflate or gzip)");
    private static final CLOptionDescriptor D_HEADER_OPT = new CLOptionDescriptor("header", 34, 72, "Pass custom header LINE to server");
    private static final CLOptionDescriptor D_METHOD_OPT = new CLOptionDescriptor("command", 2, 88, "Pass custom header LINE to server");
    private static final CLOptionDescriptor D_DATA_OPT = new CLOptionDescriptor("data", 2, 100, "HTTP POST data");
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{D_COMPRESSED_OPT, D_HEADER_OPT, D_METHOD_OPT, D_DATA_OPT};

    public Request parse(String commandLine) {
        String[] args = BasicCurlParser.translateCommandline(commandLine);
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        String error = parser.getErrorString();
        if (error == null) {
            Vector clOptions = parser.getArguments();
            Request request = new Request();
            for (CLOption option : clOptions) {
                String value;
                if (option.getDescriptor().getId() == 0) {
                    if ("CURL".equalsIgnoreCase(option.getArgument())) continue;
                    request.setUrl(option.getArgument());
                    continue;
                }
                if (option.getDescriptor().getId() == 99) {
                    request.setCompressed(true);
                    continue;
                }
                if (option.getDescriptor().getId() == 72) {
                    String nameAndValue = option.getArgument(0);
                    int indexOfSemicolon = nameAndValue.indexOf(58);
                    String name = nameAndValue.substring(0, indexOfSemicolon).trim();
                    String value2 = nameAndValue.substring(indexOfSemicolon + 1).trim();
                    request.addHeader(name, value2);
                    continue;
                }
                if (option.getDescriptor().getId() == 88) {
                    value = option.getArgument(0);
                    request.setMethod(value);
                    continue;
                }
                if (option.getDescriptor().getId() != 100) continue;
                value = option.getArgument(0);
                request.setMethod("POST");
                request.setPostData(value);
            }
            return request;
        }
        throw new IllegalArgumentException("Unexpected format for command line:" + commandLine + ", error:" + error);
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }

    public static final class Request {
        private boolean compressed;
        private String url;
        private Map<String, String> headers = new LinkedHashMap<String, String>();
        private String method = "GET";
        private String postData;

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        public void addHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Request [compressed=");
            builder.append(this.compressed);
            builder.append(", url=");
            builder.append(this.url);
            builder.append(", method=");
            builder.append(this.method);
            builder.append(", headers=");
            builder.append(this.headers);
            builder.append("]");
            return builder.toString();
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setPostData(String value) {
            this.postData = value;
        }

        public String getPostData() {
            return this.postData;
        }
    }
}

