/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class HttpDefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 241L;
    private UrlConfigGui urlConfigGui;
    private JCheckBox retrieveEmbeddedResources;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox useMD5;
    private JLabeledTextField embeddedRE;
    private JTextField sourceIpAddr;
    private JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());

    public HttpDefaultsGui() {
        this.init();
    }

    public String getLabelResource() {
        return "url_config_title";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        ConfigTestElement cfg = (ConfigTestElement)config;
        ConfigTestElement el = (ConfigTestElement)this.urlConfigGui.createTestElement();
        cfg.clear();
        cfg.addConfigElement((ConfigElement)el);
        super.configureTestElement(config);
        if (this.retrieveEmbeddedResources.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.image_parser", true));
        } else {
            config.removeProperty("HTTPSampler.image_parser");
        }
        this.enableConcurrentDwn(this.retrieveEmbeddedResources.isSelected());
        if (this.concurrentDwn.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.concurrentDwn", true));
        } else {
            config.removeProperty("HTTPSampler.concurrentDwn");
        }
        if (!StringUtils.isEmpty((CharSequence)this.concurrentPool.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", this.concurrentPool.getText()));
        } else {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", String.valueOf(6)));
        }
        if (this.useMD5.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.md5", true));
        } else {
            config.removeProperty("HTTPSampler.md5");
        }
        if (!StringUtils.isEmpty((CharSequence)this.embeddedRE.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.embedded_url_re", this.embeddedRE.getText()));
        } else {
            config.removeProperty("HTTPSampler.embedded_url_re");
        }
        if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.ipSource", this.sourceIpAddr.getText()));
            config.setProperty((JMeterProperty)new IntegerProperty("HTTPSampler.ipSourceType", this.sourceIpType.getSelectedIndex()));
        } else {
            config.removeProperty("HTTPSampler.ipSource");
            config.removeProperty("HTTPSampler.ipSourceType");
        }
    }

    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(6));
        this.enableConcurrentDwn(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedRE.setText("");
        this.sourceIpAddr.setText("");
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
    }

    public void configure(TestElement el) {
        super.configure(el);
        AbstractTestElement samplerBase = (AbstractTestElement)el;
        this.urlConfigGui.configure(el);
        this.retrieveEmbeddedResources.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.image_parser"));
        this.concurrentDwn.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.concurrentDwn"));
        this.concurrentPool.setText(samplerBase.getPropertyAsString("HTTPSampler.concurrentPool"));
        this.useMD5.setSelected(samplerBase.getPropertyAsBoolean("HTTPSampler.md5", false));
        this.embeddedRE.setText(samplerBase.getPropertyAsString("HTTPSampler.embedded_url_re", ""));
        this.sourceIpAddr.setText(samplerBase.getPropertyAsString("HTTPSampler.ipSource"));
        this.sourceIpType.setSelectedIndex(samplerBase.getPropertyAsInt("HTTPSampler.ipSourceType", HTTPSamplerBase.SOURCE_TYPE_DEFAULT));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.urlConfigGui = new UrlConfigGui(false, true, false);
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.urlConfigGui);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMaximumSize(new Dimension());
        this.add(this.makeTitlePanel(), "North");
        this.add(tabbedPane, "Center");
        this.add(emptyPanel, "South");
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.retrieveEmbeddedResources.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HttpDefaultsGui.this.enableConcurrentDwn(true);
                } else {
                    HttpDefaultsGui.this.enableConcurrentDwn(false);
                }
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (HttpDefaultsGui.this.retrieveEmbeddedResources.isSelected() && e.getStateChange() == 1) {
                    HttpDefaultsGui.this.concurrentPool.setEnabled(true);
                } else {
                    HttpDefaultsGui.this.concurrentPool.setEnabled(false);
                }
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(30, (int)this.concurrentPool.getPreferredSize().getHeight()));
        HorizontalPanel embeddedRsrcPanel = new HorizontalPanel();
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add(this.concurrentDwn);
        embeddedRsrcPanel.add(this.concurrentPool);
        this.embeddedRE = new JLabeledTextField(JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"), 20);
        embeddedRsrcPanel.add((Component)this.embeddedRE);
        return embeddedRsrcPanel;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void enableConcurrentDwn(boolean enable) {
        if (enable) {
            this.concurrentDwn.setEnabled(true);
            this.embeddedRE.setEnabled(true);
            if (this.concurrentDwn.isSelected()) {
                this.concurrentPool.setEnabled(true);
            }
        } else {
            this.concurrentDwn.setEnabled(false);
            this.concurrentPool.setEnabled(false);
            this.embeddedRE.setEnabled(false);
        }
    }
}

