/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.decl.visit.DefaultCSSUrlVisitor;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.ParseException;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CssParser
implements LinkExtractorParser {
    private static final boolean IGNORE_UNRECOVERABLE_PARSING_ERROR = JMeterUtils.getPropDefault((String)"httpsampler.ignore_failed_embedded_resource", (boolean)false);
    private static final Logger LOG = LoggingManager.getLoggerForClass();

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] data, final URL baseUrl, String encoding) throws LinkExtractorParseException {
        try {
            String cssContent = new String(data, encoding);
            CascadingStyleSheet aCSS = CSSReader.readFromStringStream((String)cssContent, (CSSReaderSettings)new CSSReaderSettings().setBrowserCompliantMode(true).setFallbackCharset(Charset.forName(encoding)).setCSSVersion(ECSSVersion.CSS30).setCustomErrorHandler((ICSSParseErrorHandler)new LoggingCSSParseErrorHandler()).setCustomExceptionHandler((ICSSParseExceptionCallback)new CustomLoggingCSSParseExceptionCallback(baseUrl)));
            ArrayList<URLString> list = new ArrayList<URLString>();
            final URLCollection urlCollection = new URLCollection(list);
            if (aCSS != null) {
                CSSVisitor.visitCSSUrl((CascadingStyleSheet)aCSS, (ICSSUrlVisitor)new DefaultCSSUrlVisitor(){

                    public void onImport(CSSImportRule importRule) {
                        String location = importRule.getLocationString();
                        if (!StringUtils.isEmpty((CharSequence)location)) {
                            urlCollection.addURL(location, baseUrl);
                        }
                    }

                    public void onUrlDeclaration(ICSSTopLevelRule aTopLevelRule, CSSDeclaration aDeclaration, CSSExpressionMemberTermURI aURITerm) {
                    }
                });
            } else {
                LOG.warn("Failed parsing url:" + baseUrl + ", got null CascadingStyleSheet");
            }
            if (LOG.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                Iterator<URL> iterator = urlCollection.iterator();
                while (iterator.hasNext()) {
                    URL urlString = iterator.next();
                    builder.append(urlString).append(",");
                }
                LOG.debug("Parsed:" + baseUrl + ", got:" + builder.toString());
            }
            return urlCollection.iterator();
        }
        catch (Exception e) {
            throw new LinkExtractorParseException(e);
        }
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    private static final class CustomLoggingCSSParseExceptionCallback
    extends LoggingCSSParseExceptionCallback {
        private static final long serialVersionUID = -9111232037888068394L;
        private URL cssUrl;

        public CustomLoggingCSSParseExceptionCallback(URL cssUrl) {
            this.cssUrl = cssUrl;
        }

        public void onException(ParseException ex) {
            if (!IGNORE_UNRECOVERABLE_PARSING_ERROR) {
                throw new IllegalStateException("Failed to parse CSS: " + this.cssUrl + ", " + LoggingCSSParseErrorHandler.createLoggingStringParseError((ParseException)ex));
            }
            LOG.warn("Failed to parse CSS: " + this.cssUrl + ", " + LoggingCSSParseErrorHandler.createLoggingStringParseError((ParseException)ex));
        }
    }
}

