/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.util.JMeterUtils;

public abstract class AbstractSamplerCreator
implements SamplerCreator {
    protected static final String HTTP = "http";
    protected static final String HTTPS = "https";
    private static final String binaryFileSuffix = JMeterUtils.getPropDefault((String)"proxy.binary.filesuffix", (String)".binary");
    private static final Set<String> binaryContentTypes = new HashSet<String>();
    private static final String binaryDirectory = JMeterUtils.getPropDefault((String)"proxy.binary.directory", (String)System.getProperty("user.dir"));
    private static final boolean numberRequests;
    private static volatile int requestNumber;

    protected static int getRequestNumber() {
        return requestNumber;
    }

    protected static void incrementRequestNumber() {
        ++requestNumber;
    }

    protected static boolean isNumberRequests() {
        return numberRequests;
    }

    protected boolean isBinaryContent(String contentType) {
        if (contentType == null) {
            return false;
        }
        return binaryContentTypes.contains(contentType);
    }

    protected String getBinaryFileSuffix() {
        return binaryFileSuffix;
    }

    protected String getBinaryDirectory() {
        return binaryDirectory;
    }

    static {
        String binaries = JMeterUtils.getPropDefault((String)"proxy.binary.types", (String)"application/x-amf,application/x-java-serialized-object");
        if (binaries.length() > 0) {
            StringTokenizer s = new StringTokenizer(binaries, "|, ");
            while (s.hasMoreTokens()) {
                binaryContentTypes.add(s.nextToken());
            }
        }
        numberRequests = JMeterUtils.getPropDefault((String)"proxy.number.requests", (boolean)false);
        requestNumber = 0;
    }
}

