/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.protocol.http.util.Base64Encoder;
import org.apache.jmeter.testelement.AbstractTestElement;

public class Authorization
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String URL = "Authorization.url";
    private static final String USERNAME = "Authorization.username";
    private static final String PASSWORD = "Authorization.password";
    private static final String DOMAIN = "Authorization.domain";
    private static final String REALM = "Authorization.realm";
    private static final String TAB = "\t";

    Authorization(String url, String user, String pass, String domain, String realm) {
        this.setURL(url);
        this.setUser(user);
        this.setPass(pass);
        this.setDomain(domain);
        this.setRealm(realm);
    }

    public boolean expectsModification() {
        return false;
    }

    public Authorization() {
        this("", "", "", "", "");
    }

    public void addConfigElement(ConfigElement config) {
    }

    public synchronized String getURL() {
        return this.getPropertyAsString(URL);
    }

    public synchronized void setURL(String url) {
        this.setProperty(URL, url);
    }

    public synchronized String getUser() {
        return this.getPropertyAsString(USERNAME);
    }

    public synchronized void setUser(String user) {
        this.setProperty(USERNAME, user);
    }

    public synchronized String getPass() {
        return this.getPropertyAsString(PASSWORD);
    }

    public synchronized void setPass(String pass) {
        this.setProperty(PASSWORD, pass);
    }

    public synchronized String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public synchronized void setDomain(String domain) {
        this.setProperty(DOMAIN, domain);
    }

    public synchronized String getRealm() {
        return this.getPropertyAsString(REALM);
    }

    public synchronized void setRealm(String realm) {
        this.setProperty(REALM, realm);
    }

    public String toString() {
        return this.getURL() + TAB + this.getUser() + TAB + this.getPass() + TAB + this.getDomain() + TAB + this.getRealm();
    }

    public String toBasicHeader() {
        return "Basic " + Base64Encoder.encode(this.getUser() + ":" + this.getPass());
    }
}

