/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.BindException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.proxy.gui.TreeNodeWrapper;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
ItemListener,
KeyListener,
UnsharedComponent {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private JTextField portField;
    private JCheckBox httpHeaders;
    private JComboBox groupingMode;
    private JCheckBox addAssertions;
    private JCheckBox useKeepAlive;
    private JCheckBox regexMatch;
    private JComboBox samplerTypeName;
    private JCheckBox samplerRedirectAutomatically;
    private JCheckBox samplerFollowRedirects;
    private JCheckBox samplerDownloadImages;
    private JCheckBox httpsSpoof;
    private JTextField httpsMatch;
    private JTextField contentTypeInclude;
    private JTextField contentTypeExclude;
    private JComboBox targetNodes;
    private DefaultComboBoxModel targetNodesModel;
    private ProxyControl model;
    private JTable excludeTable;
    private PowerTableModel excludeModel;
    private JTable includeTable;
    private PowerTableModel includeModel;
    private static final String CHANGE_TARGET = "change_target";
    private JButton stop;
    private JButton start;
    private JButton restart;
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String RESTART = "restart";
    private static final String ENABLE_RESTART = "enable_restart";
    private static final String ADD_INCLUDE = "add_include";
    private static final String ADD_EXCLUDE = "add_exclude";
    private static final String DELETE_INCLUDE = "delete_include";
    private static final String DELETE_EXCLUDE = "delete_exclude";
    private static final String INCLUDE_COL = "patterns_to_include";
    private static final String EXCLUDE_COL = "patterns_to_exclude";
    private static final String PORTFIELD = "portField";

    public ProxyControlGui() {
        log.debug("Creating ProxyControlGui");
        this.init();
    }

    public TestElement createTestElement() {
        this.model = this.makeProxyControl();
        log.debug("creating/configuring model = " + (Object)((Object)this.model));
        this.modifyTestElement((TestElement)this.model);
        return this.model;
    }

    protected ProxyControl makeProxyControl() {
        ProxyControl local = new ProxyControl();
        return local;
    }

    public void modifyTestElement(TestElement el) {
        if (this.excludeTable.isEditing()) {
            this.excludeTable.getCellEditor().stopCellEditing();
        }
        if (this.includeTable.isEditing()) {
            this.includeTable.getCellEditor().stopCellEditing();
        }
        this.configureTestElement(el);
        if (el instanceof ProxyControl) {
            this.model = (ProxyControl)el;
            this.model.setPort(this.portField.getText());
            this.setIncludeListInProxyControl(this.model);
            this.setExcludeListInProxyControl(this.model);
            this.model.setCaptureHttpHeaders(this.httpHeaders.isSelected());
            this.model.setGroupingMode(this.groupingMode.getSelectedIndex());
            this.model.setAssertions(this.addAssertions.isSelected());
            this.model.setSamplerTypeName(this.samplerTypeName.getSelectedIndex());
            this.model.setSamplerRedirectAutomatically(this.samplerRedirectAutomatically.isSelected());
            this.model.setSamplerFollowRedirects(this.samplerFollowRedirects.isSelected());
            this.model.setUseKeepAlive(this.useKeepAlive.isSelected());
            this.model.setSamplerDownloadImages(this.samplerDownloadImages.isSelected());
            this.model.setRegexMatch(this.regexMatch.isSelected());
            this.model.setHttpsSpoof(this.httpsSpoof.isSelected());
            this.model.setHttpsSpoofMatch(this.httpsMatch.getText());
            this.model.setContentTypeInclude(this.contentTypeInclude.getText());
            this.model.setContentTypeExclude(this.contentTypeExclude.getText());
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            if (nw == null) {
                this.model.setTarget(null);
            } else {
                this.model.setTarget(nw.getTreeNode());
            }
        }
    }

    protected void setIncludeListInProxyControl(ProxyControl element) {
        List<String> includeList = this.getDataList(this.includeModel, INCLUDE_COL);
        element.setIncludeList(includeList);
    }

    protected void setExcludeListInProxyControl(ProxyControl element) {
        List<String> excludeList = this.getDataList(this.excludeModel, EXCLUDE_COL);
        element.setExcludeList(excludeList);
    }

    private List<String> getDataList(PowerTableModel p_model, String colName) {
        String[] dataArray = p_model.getData().getColumn(colName);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < dataArray.length; ++i) {
            list.add(dataArray[i]);
        }
        return list;
    }

    public String getLabelResource() {
        return "proxy_title";
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with " + element);
        super.configure(element);
        this.model = (ProxyControl)element;
        this.portField.setText(this.model.getPortString());
        this.httpHeaders.setSelected(this.model.getCaptureHttpHeaders());
        this.groupingMode.setSelectedIndex(this.model.getGroupingMode());
        this.addAssertions.setSelected(this.model.getAssertions());
        this.samplerTypeName.setSelectedItem(this.model.getSamplerTypeName());
        this.samplerRedirectAutomatically.setSelected(this.model.getSamplerRedirectAutomatically());
        this.samplerFollowRedirects.setSelected(this.model.getSamplerFollowRedirects());
        this.useKeepAlive.setSelected(this.model.getUseKeepalive());
        this.samplerDownloadImages.setSelected(this.model.getSamplerDownloadImages());
        this.regexMatch.setSelected(this.model.getRegexMatch());
        this.httpsSpoof.setSelected(this.model.getHttpsSpoof());
        this.httpsMatch.setText(this.model.getHttpsSpoofMatch());
        this.httpsMatch.setEnabled(this.httpsSpoof.isSelected());
        this.contentTypeInclude.setText(this.model.getContentTypeInclude());
        this.contentTypeExclude.setText(this.model.getContentTypeExclude());
        this.reinitializeTargetCombo();
        this.populateTable(this.includeModel, this.model.getIncludePatterns().iterator());
        this.populateTable(this.excludeModel, this.model.getExcludePatterns().iterator());
        this.repaint();
    }

    private void populateTable(PowerTableModel p_model, PropertyIterator iter) {
        p_model.clearData();
        while (iter.hasNext()) {
            p_model.addRow(new Object[]{iter.next().getStringValue()});
        }
        p_model.fireTableDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableRestart();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (command.equals(STOP)) {
            this.model.stopProxy();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
            this.restart.setEnabled(false);
        } else if (command.equals(START)) {
            this.startProxy();
        } else if (command.equals(RESTART)) {
            this.model.stopProxy();
            this.startProxy();
        } else if (command.equals(ENABLE_RESTART)) {
            this.enableRestart();
            this.httpsMatch.setEnabled(this.httpsSpoof.isSelected());
        } else if (command.equals(ADD_EXCLUDE)) {
            this.excludeModel.addNewRow();
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(ADD_INCLUDE)) {
            this.includeModel.addNewRow();
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_EXCLUDE)) {
            this.excludeModel.removeRow(this.excludeTable.getSelectedRow());
            this.excludeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(DELETE_INCLUDE)) {
            this.includeModel.removeRow(this.includeTable.getSelectedRow());
            this.includeModel.fireTableDataChanged();
            this.enableRestart();
        } else if (command.equals(CHANGE_TARGET)) {
            log.debug("Change target " + this.targetNodes.getSelectedItem());
            log.debug("In model " + (Object)((Object)this.model));
            TreeNodeWrapper nw = (TreeNodeWrapper)this.targetNodes.getSelectedItem();
            this.model.setTarget(nw.getTreeNode());
            this.enableRestart();
        }
    }

    private void startProxy() {
        ValueReplacer replacer = GuiPackage.getInstance().getReplacer();
        this.modifyTestElement((TestElement)this.model);
        try {
            replacer.replaceValues((TestElement)this.model);
            this.model.startProxy();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.restart.setEnabled(false);
        }
        catch (InvalidVariableException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"invalid_variables"), "Error", 0);
        }
        catch (BindException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_bind_error"), "Error", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), JMeterUtils.getResString((String)"proxy_daemon_error"), "Error", 0);
        }
    }

    private void enableRestart() {
        if (this.stop.isEnabled()) {
            this.restart.setEnabled(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals(PORTFIELD)) {
            block5: {
                try {
                    Integer.parseInt(this.portField.getText());
                }
                catch (NumberFormatException nfe) {
                    int length = this.portField.getText().length();
                    if (length <= 0) break block5;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Only digits allowed", "Invalid data", 2);
                    this.portField.setText(this.portField.getText().substring(0, length - 1));
                }
            }
            this.enableRestart();
        } else if (fieldName.equals(ENABLE_RESTART)) {
            this.enableRestart();
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box myBox = Box.createVerticalBox();
        myBox.add(this.createPortPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createTestPlanContentPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createHTTPSamplerPanel());
        myBox.add(Box.createVerticalStrut(5));
        myBox.add(this.createContentTypePanel());
        myBox.add(Box.createVerticalStrut(5));
        mainPanel.add((Component)myBox, "North");
        Box includeExcludePanel = Box.createVerticalBox();
        includeExcludePanel.add(this.createIncludePanel());
        includeExcludePanel.add(this.createExcludePanel());
        mainPanel.add((Component)includeExcludePanel, "Center");
        mainPanel.add((Component)this.createControls(), "South");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString((String)START));
        this.start.addActionListener(this);
        this.start.setActionCommand(START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString((String)STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(STOP);
        this.stop.setEnabled(false);
        this.restart = new JButton(JMeterUtils.getResString((String)RESTART));
        this.restart.addActionListener(this);
        this.restart.setActionCommand(RESTART);
        this.restart.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        panel.add(this.restart);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(ProxyControl.DEFAULT_PORT_S, 5);
        this.portField.setName(PORTFIELD);
        this.portField.addKeyListener(this);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        this.httpsSpoof = new JCheckBox(JMeterUtils.getResString((String)"proxy_httpsspoofing"));
        this.httpsSpoof.setSelected(false);
        this.httpsSpoof.addActionListener(this);
        this.httpsSpoof.setActionCommand(ENABLE_RESTART);
        this.httpsMatch = new JTextField(40);
        this.httpsMatch.addKeyListener(this);
        this.httpsMatch.setName(ENABLE_RESTART);
        this.httpsMatch.setEnabled(false);
        JLabel matchlabel = new JLabel(JMeterUtils.getResString((String)"proxy_httpsspoofing_match"));
        matchlabel.setLabelFor(this.httpsMatch);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_general_settings")));
        panel.add((Component)label);
        panel.add((Component)this.portField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)this.httpsSpoof);
        panel.add((Component)matchlabel);
        panel.add((Component)this.httpsMatch);
        return panel;
    }

    private JPanel createTestPlanContentPanel() {
        this.httpHeaders = new JCheckBox(JMeterUtils.getResString((String)"proxy_headers"));
        this.httpHeaders.setSelected(true);
        this.httpHeaders.addActionListener(this);
        this.httpHeaders.setActionCommand(ENABLE_RESTART);
        this.addAssertions = new JCheckBox(JMeterUtils.getResString((String)"proxy_assertions"));
        this.addAssertions.setSelected(false);
        this.addAssertions.addActionListener(this);
        this.addAssertions.setActionCommand(ENABLE_RESTART);
        this.regexMatch = new JCheckBox(JMeterUtils.getResString((String)"proxy_regex"));
        this.regexMatch.setSelected(false);
        this.regexMatch.addActionListener(this);
        this.regexMatch.setActionCommand(ENABLE_RESTART);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_test_plan_content")));
        HorizontalPanel nodeCreationPanel = new HorizontalPanel();
        nodeCreationPanel.add((Component)this.httpHeaders);
        nodeCreationPanel.add((Component)this.addAssertions);
        nodeCreationPanel.add((Component)this.regexMatch);
        HorizontalPanel targetPanel = new HorizontalPanel();
        targetPanel.add((Component)this.createTargetPanel());
        targetPanel.add((Component)this.createGroupingPanel());
        mainPanel.add((Component)targetPanel);
        mainPanel.add((Component)nodeCreationPanel);
        return mainPanel;
    }

    private JPanel createHTTPSamplerPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (String s : HTTPSamplerFactory.getImplementations()) {
            m.addElement(s);
        }
        this.samplerTypeName = new JComboBox(m);
        this.samplerTypeName.setSelectedIndex(0);
        this.samplerTypeName.addItemListener(this);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"proxy_sampler_type"));
        label2.setLabelFor(this.samplerTypeName);
        this.samplerRedirectAutomatically = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects_auto"));
        this.samplerRedirectAutomatically.setSelected(false);
        this.samplerRedirectAutomatically.addActionListener(this);
        this.samplerRedirectAutomatically.setActionCommand(ENABLE_RESTART);
        this.samplerFollowRedirects = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.samplerFollowRedirects.setSelected(true);
        this.samplerFollowRedirects.addActionListener(this);
        this.samplerFollowRedirects.setActionCommand(ENABLE_RESTART);
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.useKeepAlive.setSelected(true);
        this.useKeepAlive.addActionListener(this);
        this.useKeepAlive.setActionCommand(ENABLE_RESTART);
        this.samplerDownloadImages = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.samplerDownloadImages.setSelected(false);
        this.samplerDownloadImages.addActionListener(this);
        this.samplerDownloadImages.setActionCommand(ENABLE_RESTART);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_sampler_settings")));
        panel.add((Component)label2);
        panel.add((Component)this.samplerTypeName);
        panel.add((Component)this.samplerRedirectAutomatically);
        panel.add((Component)this.samplerFollowRedirects);
        panel.add((Component)this.useKeepAlive);
        panel.add((Component)this.samplerDownloadImages);
        return panel;
    }

    private JPanel createTargetPanel() {
        this.targetNodesModel = new DefaultComboBoxModel();
        this.targetNodes = new JComboBox(this.targetNodesModel);
        this.targetNodes.setActionCommand(CHANGE_TARGET);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"proxy_target"));
        label.setLabelFor(this.targetNodes);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label);
        panel.add((Component)this.targetNodes);
        return panel;
    }

    private JPanel createGroupingPanel() {
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        m.addElement(JMeterUtils.getResString((String)"grouping_no_groups"));
        m.addElement(JMeterUtils.getResString((String)"grouping_add_separators"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_controllers"));
        m.addElement(JMeterUtils.getResString((String)"grouping_store_first_only"));
        m.addElement(JMeterUtils.getResString((String)"grouping_in_transaction_controllers"));
        this.groupingMode = new JComboBox(m);
        this.groupingMode.setSelectedIndex(0);
        this.groupingMode.addItemListener(this);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"grouping_mode"));
        label2.setLabelFor(this.groupingMode);
        HorizontalPanel panel = new HorizontalPanel();
        panel.add((Component)label2);
        panel.add((Component)this.groupingMode);
        return panel;
    }

    private JPanel createContentTypePanel() {
        this.contentTypeInclude = new JTextField(35);
        this.contentTypeInclude.addKeyListener(this);
        this.contentTypeInclude.setName(ENABLE_RESTART);
        JLabel labelInclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_include"));
        labelInclude.setLabelFor(this.contentTypeInclude);
        this.contentTypeInclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_include"));
        this.contentTypeExclude = new JTextField(35);
        this.contentTypeExclude.addKeyListener(this);
        this.contentTypeExclude.setName(ENABLE_RESTART);
        JLabel labelExclude = new JLabel(JMeterUtils.getResString((String)"proxy_content_type_exclude"));
        labelExclude.setLabelFor(this.contentTypeExclude);
        this.contentTypeExclude.setText(JMeterUtils.getProperty((String)"proxy.content_type_exclude"));
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"proxy_content_type_filter")));
        panel.add((Component)labelInclude);
        panel.add((Component)this.contentTypeInclude);
        panel.add((Component)labelExclude);
        panel.add((Component)this.contentTypeExclude);
        return panel;
    }

    private JPanel createIncludePanel() {
        this.includeModel = new PowerTableModel(new String[]{INCLUDE_COL}, new Class[]{String.class});
        this.includeTable = new JTable((TableModel)this.includeModel);
        this.includeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.includeTable.setPreferredScrollableViewportSize(new Dimension(100, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)INCLUDE_COL)));
        panel.add((Component)new JScrollPane(this.includeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_INCLUDE, DELETE_INCLUDE), "South");
        return panel;
    }

    private JPanel createExcludePanel() {
        this.excludeModel = new PowerTableModel(new String[]{EXCLUDE_COL}, new Class[]{String.class});
        this.excludeTable = new JTable((TableModel)this.excludeModel);
        this.excludeTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.excludeTable.setPreferredScrollableViewportSize(new Dimension(100, 30));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)EXCLUDE_COL)));
        panel.add((Component)new JScrollPane(this.excludeTable), "Center");
        panel.add((Component)this.createTableButtonPanel(ADD_EXCLUDE, DELETE_EXCLUDE), "South");
        return panel;
    }

    private JPanel createTableButtonPanel(String addCommand, String deleteCommand) {
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton(JMeterUtils.getResString((String)"add"));
        addButton.setActionCommand(addCommand);
        addButton.addActionListener(this);
        buttonPanel.add(addButton);
        JButton deleteButton = new JButton(JMeterUtils.getResString((String)"delete"));
        deleteButton.setActionCommand(deleteCommand);
        deleteButton.addActionListener(this);
        buttonPanel.add(deleteButton);
        return buttonPanel;
    }

    private void reinitializeTargetCombo() {
        log.debug("Reinitializing target combo");
        this.targetNodes.removeActionListener(this);
        this.targetNodesModel.removeAllElements();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.targetNodesModel.addElement(new TreeNodeWrapper(null, JMeterUtils.getResString((String)"use_recording_controller")));
            this.buildNodesModel(root, "", 0);
        }
        TreeNodeWrapper choice = null;
        for (int i = 0; i < this.targetNodesModel.getSize(); ++i) {
            choice = (TreeNodeWrapper)this.targetNodesModel.getElementAt(i);
            log.debug("Selecting item " + choice + " for model " + (Object)((Object)this.model) + " in " + this);
            if (choice.getTreeNode() == this.model.getTarget()) break;
        }
        this.targetNodes.addActionListener(this);
        this.targetNodesModel.setSelectedItem(choice);
        log.debug("Reinitialization complete");
    }

    private void buildNodesModel(JMeterTreeNode node, String parent_name, int level) {
        String seperator = " > ";
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                StringBuilder name = new StringBuilder();
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.getTestElement();
                if (te instanceof Controller) {
                    name.append(this.spaces(level));
                    name.append(parent_name);
                    name.append(cur.getName());
                    TreeNodeWrapper tnw = new TreeNodeWrapper(cur, name.toString());
                    this.targetNodesModel.addElement(tnw);
                    name = new StringBuilder();
                    name.append(cur.getName());
                    name.append(seperator);
                    this.buildNodesModel(cur, name.toString(), level + 1);
                    continue;
                }
                if (!(te instanceof TestPlan) && !(te instanceof WorkBench)) continue;
                name.append(cur.getName());
                name.append(seperator);
                this.buildNodesModel(cur, name.toString(), 0);
            }
        }
    }

    private String spaces(int level) {
        int multi = 4;
        StringBuilder spaces = new StringBuilder(level * multi);
        for (int i = 0; i < level * multi; ++i) {
            spaces.append(" ");
        }
        return spaces.toString();
    }
}

