/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.proxy.FormCharSetFinder;
import org.apache.jmeter.protocol.http.proxy.HttpReplyHdr;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.ProxyControl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy
extends Thread {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static final String CRLF_STRING = "\r\n";
    private static final String NEW_LINE = "\n";
    private static final String[] headersToRemove;
    private static final String PROXY_HEADERS_REMOVE = "proxy.headers.remove";
    private static final String PROXY_HEADERS_REMOVE_DEFAULT = "If-Modified-Since,If-None-Match,Host";
    private static final String PROXY_HEADERS_REMOVE_SEPARATOR = ",";
    private static final String KEYSTORE_TYPE;
    private static final String KEYMANAGERFACTORY;
    private static final String SSLCONTEXT_PROTOCOL;
    private static final HashMap<String, SSLSocketFactory> hashHost;
    private static final String CERT_DIRECTORY;
    private static final String CERT_FILE_DEFAULT = "proxyserver.jks";
    private static final String CERT_FILE;
    private static final char[] KEYSTORE_PASSWORD;
    private static final char[] KEY_PASSWORD;
    private OutputStream outStreamClient = null;
    private Socket clientSocket = null;
    private ProxyControl target;
    private boolean captureHttpHeaders;
    private boolean httpsSpoof;
    private String httpsSpoofMatch;
    private Map<String, String> pageEncodings;
    private Map<String, String> formEncodings;

    void configure(Socket _clientSocket, ProxyControl _target, Map<String, String> _pageEncodings, Map<String, String> _formEncodings) {
        this.target = _target;
        this.clientSocket = _clientSocket;
        this.captureHttpHeaders = _target.getCaptureHttpHeaders();
        this.httpsSpoof = _target.getHttpsSpoof();
        this.httpsSpoofMatch = _target.getHttpsSpoofMatch();
        this.pageEncodings = _pageEncodings;
        this.formEncodings = _formEncodings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block42: {
            String httpSamplerName = this.target.getSamplerTypeName();
            HTTPSamplerBase sampler = HTTPSamplerFactory.newInstance(httpSamplerName);
            HttpRequestHdr request = new HttpRequestHdr(sampler);
            SampleResult result = null;
            HeaderManager headers = null;
            request.parse(new BufferedInputStream(this.clientSocket.getInputStream()));
            this.outStreamClient = this.clientSocket.getOutputStream();
            if (request.getMethod().startsWith("CONNECT") && this.outStreamClient != null) {
                log.debug("Method CONNECT => SSL");
                this.outStreamClient.write("HTTP/1.0 200 OK\r\n\r\n".getBytes("ISO-8859-1"));
                this.outStreamClient.flush();
                String[] param = request.getUrl().split(":");
                if (param.length == 2) {
                    log.debug("Start to negotiate SSL connection, host: " + param[0]);
                    this.clientSocket = this.startSSL(this.clientSocket, param[0]);
                } else {
                    log.warn("In SSL request, unable to find host and port in CONNECT request");
                }
                request.parse(new BufferedInputStream(this.clientSocket.getInputStream()));
            }
            request.getSampler(this.pageEncodings, this.formEncodings);
            headers = request.getHeaderManager();
            sampler.setHeaderManager(headers);
            boolean forcedHTTPS = false;
            if (this.httpsSpoof) {
                if (this.httpsSpoofMatch.length() > 0) {
                    String url = request.getUrl();
                    if (url.matches(this.httpsSpoofMatch)) {
                        sampler.setProtocol("https");
                        forcedHTTPS = true;
                    }
                } else {
                    sampler.setProtocol("https");
                    forcedHTTPS = true;
                }
            }
            sampler.threadStarted();
            result = sampler.sample();
            if (this.httpsSpoof && "text".equals(result.getDataType())) {
                String enc = result.getDataEncodingWithDefault();
                String noHttpsResult = new String(result.getResponseData(), enc);
                String HTTPS_HOST = "https://([^:/]+)(:443)?";
                noHttpsResult = noHttpsResult.replaceAll("https://([^:/]+)(:443)?", "http://$1");
                result.setResponseData(noHttpsResult.getBytes(enc));
            }
            String pageEncoding = this.addPageEncoding(result);
            this.addFormEncodings(result, pageEncoding);
            this.writeToClient(result, new BufferedOutputStream(this.clientSocket.getOutputStream()), forcedHTTPS);
            Object var11_15 = null;
            if (log.isDebugEnabled()) {
                log.debug("Will deliver sample " + sampler.getName());
            }
            if (headers != null) {
                headers.removeHeaderNamed("Cookie");
                headers.removeHeaderNamed("Authorization");
                for (String hdr : headersToRemove) {
                    headers.removeHeaderNamed(hdr);
                }
            }
            this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
            try {
                this.clientSocket.close();
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
            }
            sampler.threadFinished();
            {
                break block42;
                catch (UnknownHostException uhe) {
                    log.warn("Server Not Found.", (Throwable)uhe);
                    this.writeErrorToClient(HttpReplyHdr.formServerNotFound());
                    result = this.generateErrorResult(result, uhe);
                    Object var11_16 = null;
                    if (log.isDebugEnabled()) {
                        log.debug("Will deliver sample " + sampler.getName());
                    }
                    if (headers != null) {
                        headers.removeHeaderNamed("Cookie");
                        headers.removeHeaderNamed("Authorization");
                        for (String hdr : headersToRemove) {
                            headers.removeHeaderNamed(hdr);
                        }
                    }
                    this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                    sampler.threadFinished();
                    break block42;
                }
                catch (IllegalArgumentException e) {
                    log.error("Not implemented (probably used https)", (Throwable)e);
                    this.writeErrorToClient(HttpReplyHdr.formNotImplemented("Probably used https instead of http. To record https requests, see <a href=\"http://jakarta.apache.org/jmeter/usermanual/component_reference.html#HTTP_Proxy_Server\">HTTP Proxy Server documentation</a>"));
                    result = this.generateErrorResult(result, e);
                    Object var11_17 = null;
                    if (log.isDebugEnabled()) {
                        log.debug("Will deliver sample " + sampler.getName());
                    }
                    if (headers != null) {
                        headers.removeHeaderNamed("Cookie");
                        headers.removeHeaderNamed("Authorization");
                        for (String hdr : headersToRemove) {
                            headers.removeHeaderNamed(hdr);
                        }
                    }
                    this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                    sampler.threadFinished();
                    break block42;
                }
                catch (IOException ioe) {
                    log.error("Problem with SSL certificate? Ensure browser is set to accept the JMeter proxy cert: " + ioe.getLocalizedMessage());
                    if (result == null) {
                        result = new SampleResult();
                        result.setSampleLabel("Sample failed");
                    }
                    result.setResponseMessage(ioe.getMessage() + "\n**ensure browser is set to accept the JMeter proxy certificate**");
                    Object var11_18 = null;
                    if (log.isDebugEnabled()) {
                        log.debug("Will deliver sample " + sampler.getName());
                    }
                    if (headers != null) {
                        headers.removeHeaderNamed("Cookie");
                        headers.removeHeaderNamed("Authorization");
                        for (String hdr : headersToRemove) {
                            headers.removeHeaderNamed(hdr);
                        }
                    }
                    this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                    sampler.threadFinished();
                    break block42;
                }
                catch (Exception e) {
                    log.error("Exception when processing sample", (Throwable)e);
                    this.writeErrorToClient(HttpReplyHdr.formInternalError());
                    result = this.generateErrorResult(result, e);
                    Object var11_19 = null;
                    if (log.isDebugEnabled()) {
                        log.debug("Will deliver sample " + sampler.getName());
                    }
                    if (headers != null) {
                        headers.removeHeaderNamed("Cookie");
                        headers.removeHeaderNamed("Authorization");
                        for (String hdr : headersToRemove) {
                            headers.removeHeaderNamed(hdr);
                        }
                    }
                    this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception e2) {
                        log.error("", (Throwable)e2);
                    }
                    sampler.threadFinished();
                }
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                if (log.isDebugEnabled()) {
                    log.debug("Will deliver sample " + sampler.getName());
                }
                if (headers != null) {
                    headers.removeHeaderNamed("Cookie");
                    headers.removeHeaderNamed("Authorization");
                    for (String hdr : headersToRemove) {
                        headers.removeHeaderNamed(hdr);
                    }
                }
                this.target.deliverSampler(sampler, new TestElement[]{this.captureHttpHeaders ? headers : null}, result);
                try {
                    this.clientSocket.close();
                }
                catch (Exception e2) {
                    log.error("", (Throwable)e2);
                }
                sampler.threadFinished();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLSocketFactory getSSLSocketFactory(String host) throws IOException {
        HashMap<String, SSLSocketFactory> hashMap = hashHost;
        synchronized (hashMap) {
            block21: {
                SSLSocketFactory sSLSocketFactory;
                InputStream in;
                block19: {
                    if (hashHost.containsKey(host)) {
                        log.debug("Good, already in map, host=" + host);
                        return hashHost.get(host);
                    }
                    in = this.getCertificate();
                    GeneralSecurityException except = null;
                    if (in == null) {
                        throw new IOException("Unable to read keystore");
                    }
                    KeyStore ks = null;
                    KeyManagerFactory kmf = null;
                    SSLContext sslcontext = null;
                    try {
                        try {
                            ks = KeyStore.getInstance(KEYSTORE_TYPE);
                            ks.load(in, KEYSTORE_PASSWORD);
                            kmf = KeyManagerFactory.getInstance(KEYMANAGERFACTORY);
                            kmf.init(ks, KEY_PASSWORD);
                            sslcontext = SSLContext.getInstance(SSLCONTEXT_PROTOCOL);
                            sslcontext.init(kmf.getKeyManagers(), null, null);
                            SSLSocketFactory sslFactory = sslcontext.getSocketFactory();
                            hashHost.put(host, sslFactory);
                            log.info("KeyStore for SSL loaded OK and put host in map (" + host + ")");
                            sSLSocketFactory = sslFactory;
                            Object var11_15 = null;
                            if (except == null) break block19;
                        }
                        catch (NoSuchAlgorithmException e) {
                            except = e;
                            Object var11_16 = null;
                            if (except != null) {
                                log.error("Problem with SSL certificate", (Throwable)except);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block21;
                        }
                        catch (KeyManagementException e) {
                            except = e;
                            Object var11_17 = null;
                            if (except != null) {
                                log.error("Problem with SSL certificate", (Throwable)except);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block21;
                        }
                        catch (KeyStoreException e) {
                            except = e;
                            Object var11_18 = null;
                            if (except != null) {
                                log.error("Problem with SSL certificate", (Throwable)except);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block21;
                        }
                        catch (UnrecoverableKeyException e) {
                            except = e;
                            Object var11_19 = null;
                            if (except != null) {
                                log.error("Problem with SSL certificate", (Throwable)except);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block21;
                        }
                        catch (CertificateException e) {
                            except = e;
                            Object var11_20 = null;
                            if (except != null) {
                                log.error("Problem with SSL certificate", (Throwable)except);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_21 = null;
                        if (except != null) {
                            log.error("Problem with SSL certificate", (Throwable)except);
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        throw throwable;
                    }
                    log.error("Problem with SSL certificate", (Throwable)except);
                }
                IOUtils.closeQuietly((InputStream)in);
                return sSLSocketFactory;
            }
            return null;
        }
    }

    private Socket startSSL(Socket sock, String host) throws IOException {
        SSLSocketFactory sslFactory = this.getSSLSocketFactory(host);
        if (sslFactory != null) {
            try {
                SSLSocket secureSocket = (SSLSocket)sslFactory.createSocket(sock, sock.getInetAddress().getHostName(), sock.getPort(), true);
                secureSocket.setUseClientMode(false);
                if (log.isDebugEnabled()) {
                    log.debug("SSL transaction ok with cipher: " + secureSocket.getSession().getCipherSuite());
                }
                return secureSocket;
            }
            catch (IOException e) {
                log.error("Error in SSL socket negotiation: ", (Throwable)e);
                throw e;
            }
        }
        log.warn("Unable to negotiate SSL transaction, no keystore?");
        throw new IOException("Unable to negotiate SSL transaction, no keystore?");
    }

    private InputStream getCertificate() {
        File certFile = new File(CERT_DIRECTORY, CERT_FILE);
        FileInputStream in = null;
        String certPath = certFile.getAbsolutePath();
        if (certFile.exists() && certFile.canRead()) {
            try {
                in = new FileInputStream(certFile);
                log.info("Opened Keystore file: " + certPath);
            }
            catch (FileNotFoundException e) {
                log.error("No server cert file found: " + certPath, (Throwable)e);
            }
        } else {
            log.error("No server cert file found: " + certPath);
        }
        return in;
    }

    private SampleResult generateErrorResult(SampleResult result, Exception e) {
        if (result == null) {
            result = new SampleResult();
            result.setSampleLabel("Sample failed");
        }
        result.setResponseMessage(e.getMessage());
        return result;
    }

    /*
     * Loose catch block
     */
    private void writeToClient(SampleResult res, OutputStream out, boolean forcedHTTPS) throws IOException {
        block7: {
            String responseHeaders = this.massageResponseHeaders(res, forcedHTTPS);
            out.write(responseHeaders.getBytes("ISO-8859-1"));
            out.write(CRLF_BYTES);
            out.write(res.getResponseData());
            out.flush();
            log.debug("Done writing to client");
            Object var6_6 = null;
            try {
                out.close();
            }
            catch (Exception ex) {
                log.warn("Error while closing socket", (Throwable)ex);
            }
            break block7;
            {
                catch (IOException e) {
                    log.error("", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    out.close();
                }
                catch (Exception ex) {
                    log.warn("Error while closing socket", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    private String massageResponseHeaders(SampleResult res, boolean forcedHTTPS) {
        String headers = res.getResponseHeaders();
        String[] headerLines = headers.split(NEW_LINE, 0);
        int contentLengthIndex = -1;
        boolean fixContentLength = forcedHTTPS;
        for (int i = 0; i < headerLines.length; ++i) {
            String line = headerLines[i];
            String[] parts = line.split(":\\s+", 2);
            if (parts.length != 2) continue;
            if ("transfer-encoding".equalsIgnoreCase(parts[0])) {
                headerLines[i] = null;
                continue;
            }
            if ("content-encoding".equalsIgnoreCase(parts[0]) && "gzip".equalsIgnoreCase(parts[1])) {
                headerLines[i] = null;
                fixContentLength = true;
                continue;
            }
            if ("Content-Length".equalsIgnoreCase(parts[0])) {
                contentLengthIndex = i;
                continue;
            }
            String HTTPS_PREFIX = "https://";
            if (forcedHTTPS && "Location".equalsIgnoreCase(parts[0]) && parts[1].substring(0, "https://".length()).equalsIgnoreCase("https://")) {
                headerLines[i] = headerLines[i].replaceFirst(parts[1].substring(0, "https://".length()), "http://");
                continue;
            }
            if ((!forcedHTTPS || !"Cookie".equalsIgnoreCase(parts[0])) && !"set-cookie".equalsIgnoreCase(parts[0])) continue;
            headerLines[i] = headerLines[i].replaceAll(" secure", "").trim();
        }
        if (fixContentLength && contentLengthIndex >= 0) {
            headerLines[contentLengthIndex] = "Content-Length: " + res.getResponseData().length;
        }
        StringBuilder sb = new StringBuilder(headers.length());
        for (int i = 0; i < headerLines.length; ++i) {
            String line = headerLines[i];
            if (line == null) continue;
            sb.append(line).append(CRLF_STRING);
        }
        return sb.toString();
    }

    private void writeErrorToClient(String message) {
        try {
            OutputStream sockOut = this.clientSocket.getOutputStream();
            DataOutputStream out = new DataOutputStream(sockOut);
            out.writeBytes(message);
            out.flush();
        }
        catch (Exception e) {
            log.warn("Exception while writing error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addPageEncoding(SampleResult result) {
        String pageEncoding = ConversionUtils.getEncodingFromContentType(result.getContentType());
        if (pageEncoding != null) {
            String urlWithoutQuery = this.getUrlWithoutQuery(result.getURL());
            Map<String, String> map = this.pageEncodings;
            synchronized (map) {
                this.pageEncodings.put(urlWithoutQuery, pageEncoding);
            }
        }
        return pageEncoding;
    }

    private void addFormEncodings(SampleResult result, String pageEncoding) {
        FormCharSetFinder finder = new FormCharSetFinder();
        if (!result.getContentType().startsWith("text/")) {
            return;
        }
        try {
            finder.addFormActionsAndCharSet(result.getResponseDataAsString(), this.formEncodings, pageEncoding);
        }
        catch (HTMLParseException parseException) {
            log.debug("Unable to parse response, could not find any form character set encodings");
        }
    }

    private String getUrlWithoutQuery(URL url) {
        String fullUrl;
        String urlWithoutQuery = fullUrl = url.toString();
        String query = url.getQuery();
        if (query != null) {
            urlWithoutQuery = urlWithoutQuery.substring(0, urlWithoutQuery.length() - query.length() - 1);
        }
        return urlWithoutQuery;
    }

    static {
        KEYSTORE_TYPE = JMeterUtils.getPropDefault((String)"proxy.cert.type", (String)"JKS");
        KEYMANAGERFACTORY = JMeterUtils.getPropDefault((String)"proxy.cert.factory", (String)"SunX509");
        SSLCONTEXT_PROTOCOL = JMeterUtils.getPropDefault((String)"proxy.ssl.protocol", (String)"SSLv3");
        hashHost = new HashMap();
        CERT_DIRECTORY = JMeterUtils.getPropDefault((String)"proxy.cert.directory", (String)JMeterUtils.getJMeterBinDir());
        CERT_FILE = JMeterUtils.getPropDefault((String)"proxy.cert.file", (String)CERT_FILE_DEFAULT);
        KEYSTORE_PASSWORD = JMeterUtils.getPropDefault((String)"proxy.cert.keystorepass", (String)"password").toCharArray();
        KEY_PASSWORD = JMeterUtils.getPropDefault((String)"proxy.cert.keypassword", (String)"password").toCharArray();
        String removeList = JMeterUtils.getPropDefault((String)PROXY_HEADERS_REMOVE, (String)PROXY_HEADERS_REMOVE_DEFAULT);
        headersToRemove = JOrphanUtils.split((String)removeList, (String)PROXY_HEADERS_REMOVE_SEPARATOR);
        log.info("Proxy will remove the headers: " + removeList);
    }
}

