/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestHdr {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String binaryFileSuffix = JMeterUtils.getPropDefault((String)"proxy.binary.filesuffix", (String)".binary");
    private static final Set<String> binaryContentTypes = new HashSet<String>();
    private static final String binaryDirectory = JMeterUtils.getPropDefault((String)"proxy.binary.directory", (String)System.getProperty("user.dir"));
    private String method = "";
    private String paramHttps = "";
    private String url = "";
    private String version = "";
    private byte[] rawPostData;
    private final Map<String, Header> headers = new HashMap<String, Header>();
    private final HTTPSamplerBase sampler;
    private HeaderManager headerManager;
    private static final boolean numberRequests;
    private static volatile int requestNumber;

    public HttpRequestHdr() {
        this.sampler = HTTPSamplerFactory.newInstance();
    }

    public HttpRequestHdr(HTTPSamplerBase sampler) {
        this.sampler = sampler;
    }

    public byte[] parse(InputStream in) throws IOException {
        int x;
        boolean inHeaders = true;
        int readLength = 0;
        int dataLength = 0;
        boolean firstLine = true;
        ByteArrayOutputStream clientRequest = new ByteArrayOutputStream();
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        while ((inHeaders || readLength < dataLength) && (x = in.read()) != -1) {
            line.write(x);
            clientRequest.write(x);
            if (firstLine && !CharUtils.isAscii((char)((char)x))) {
                throw new IllegalArgumentException("Only ASCII supported in headers (perhaps SSL was used?)");
            }
            if (inHeaders && (byte)x == 10) {
                if (line.size() < 3) {
                    inHeaders = false;
                    firstLine = false;
                }
                if (firstLine) {
                    this.parseFirstLine(line.toString());
                    firstLine = false;
                } else {
                    int contentLen = this.parseLine(line.toString());
                    if (contentLen > 0) {
                        dataLength = contentLen;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Client Request Line: " + line.toString());
                }
                line.reset();
                continue;
            }
            if (inHeaders) continue;
            ++readLength;
        }
        this.rawPostData = line.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("rawPostData in default JRE encoding: " + new String(this.rawPostData));
            log.debug("Request: " + clientRequest.toString());
        }
        return clientRequest.toByteArray();
    }

    private void parseFirstLine(String firstLine) {
        if (log.isDebugEnabled()) {
            log.debug("browser request: " + firstLine);
        }
        StringTokenizer tz = new StringTokenizer(firstLine);
        this.method = this.getToken(tz).toUpperCase(Locale.ENGLISH);
        this.url = this.getToken(tz);
        this.version = this.getToken(tz);
        if (log.isDebugEnabled()) {
            log.debug("parser input:  " + firstLine);
            log.debug("parsed method: " + this.method);
            log.debug("parsed url:    " + this.url);
            log.debug("parsed version:" + this.version);
        }
        if (this.getMethod().startsWith("CONNECT")) {
            this.paramHttps = this.url;
        }
        if (this.url.startsWith("/")) {
            this.url = "https://" + this.paramHttps + this.url;
        }
        log.debug("First Line: " + this.url);
    }

    private int parseLine(String nextLine) {
        int colon = nextLine.indexOf(58);
        if (colon <= 0) {
            return 0;
        }
        String name = nextLine.substring(0, colon).trim();
        String value = nextLine.substring(colon + 1).trim();
        this.headers.put(name.toLowerCase(Locale.ENGLISH), new Header(name, value));
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private HeaderManager createHeaderManager() {
        HeaderManager manager = new HeaderManager();
        for (String key : this.headers.keySet()) {
            if (key.equals(PROXY_CONNECTION) || key.equals(CONTENT_LENGTH) || key.equalsIgnoreCase("Connection")) continue;
            manager.add(this.headers.get(key));
        }
        manager.setName(JMeterUtils.getResString((String)"header_manager_title"));
        manager.setProperty("TestElement.test_class", HeaderManager.class.getName());
        manager.setProperty("TestElement.gui_class", HeaderPanel.class.getName());
        return manager;
    }

    public HeaderManager getHeaderManager() {
        if (this.headerManager == null) {
            this.headerManager = this.createHeaderManager();
        }
        return this.headerManager;
    }

    public HTTPSamplerBase getSampler(Map<String, String> pageEncodings, Map<String, String> formEncodings) throws MalformedURLException, IOException {
        HttpTestSampleGui tempGui = new HttpTestSampleGui();
        this.sampler.setProperty("TestElement.gui_class", tempGui.getClass().getName());
        this.populateSampler(pageEncodings, formEncodings);
        tempGui.configure((TestElement)this.sampler);
        tempGui.modifyTestElement((TestElement)this.sampler);
        this.sampler.setFollowRedirects(false);
        this.sampler.setUseKeepAlive(true);
        if (log.isDebugEnabled()) {
            log.debug("getSampler: sampler path = " + this.sampler.getPath());
        }
        return this.sampler;
    }

    private String getContentType() {
        Header contentTypeHeader = this.headers.get(CONTENT_TYPE);
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    private boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    private MultipartUrlConfig getMultipartConfig(String contentType) {
        if (this.isMultipart(contentType)) {
            String boundaryString = contentType.substring(contentType.toLowerCase(Locale.ENGLISH).indexOf("boundary=") + "boundary=".length());
            return new MultipartUrlConfig(boundaryString);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSampler(Map<String, String> pageEncodings, Map<String, String> formEncodings) throws MalformedURLException, UnsupportedEncodingException {
        this.sampler.setDomain(this.serverName());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting server: " + this.sampler.getDomain());
        }
        this.sampler.setMethod(this.method);
        log.debug("Proxy: setting method: " + this.sampler.getMethod());
        this.sampler.setPort(this.serverPort());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting port: " + this.sampler.getPort());
        }
        if (this.url.indexOf("//") > -1) {
            String protocol = this.url.substring(0, this.url.indexOf(":"));
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to : " + protocol);
            }
            this.sampler.setProtocol(protocol);
        } else if (this.sampler.getPort() == 443) {
            this.sampler.setProtocol(HTTPS);
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to https");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Proxy setting default protocol to: http");
            }
            this.sampler.setProtocol(HTTP);
        }
        URL pageUrl = null;
        pageUrl = this.sampler.isProtocolDefaultPort() ? new URL(this.sampler.getProtocol(), this.sampler.getDomain(), this.getPath()) : new URL(this.sampler.getProtocol(), this.sampler.getDomain(), this.sampler.getPort(), this.getPath());
        String urlWithoutQuery = this.getUrlWithoutQuery(pageUrl);
        String contentEncoding = null;
        String requestContentEncoding = ConversionUtils.getEncodingFromContentType(this.getContentType());
        if (requestContentEncoding != null) {
            contentEncoding = requestContentEncoding;
        } else {
            Map<String, String> map;
            if (pageEncodings != null) {
                map = pageEncodings;
                synchronized (map) {
                    contentEncoding = pageEncodings.get(urlWithoutQuery);
                }
            }
            if (formEncodings != null) {
                map = formEncodings;
                synchronized (map) {
                    String formEncoding = formEncodings.get(urlWithoutQuery);
                    if (formEncoding != null) {
                        contentEncoding = formEncoding;
                    }
                }
            }
        }
        String postData = null;
        if (log.isDebugEnabled()) {
            if (contentEncoding != null) {
                log.debug("Using encoding " + contentEncoding + " for request body");
            } else {
                log.debug("No encoding found, using JRE default encoding for request body");
            }
        }
        postData = contentEncoding != null ? new String(this.rawPostData, contentEncoding) : new String(this.rawPostData);
        if (contentEncoding != null) {
            this.sampler.setPath(this.getPath(), contentEncoding);
        } else {
            this.sampler.setPath(this.getPath(), null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting path: " + this.sampler.getPath());
        }
        if (!"CONNECT".equals(this.getMethod()) && numberRequests) {
            this.sampler.setName(++requestNumber + " " + this.sampler.getPath());
        } else {
            this.sampler.setName(this.sampler.getPath());
        }
        if (contentEncoding != null) {
            this.sampler.setContentEncoding(contentEncoding);
        }
        if (!"CONNECT".equals(this.getMethod()) && !"GET".equals(this.method)) {
            String contentType = this.getContentType();
            MultipartUrlConfig urlConfig = this.getMultipartConfig(contentType);
            if (urlConfig != null) {
                urlConfig.parseArguments(postData);
                this.sampler.setDoMultipartPost(true);
                this.getHeaderManager().removeHeaderNamed(CONTENT_TYPE);
                this.getHeaderManager().removeHeaderNamed(CONTENT_LENGTH);
                this.sampler.setArguments(urlConfig.getArguments());
                this.sampler.setHTTPFiles(urlConfig.getHTTPFileArgs().asArray());
            } else if (postData.trim().startsWith("<?") || "PUT".equals(this.sampler.getMethod())) {
                this.sampler.addNonEncodedArgument("", postData, "");
            } else if (contentType == null || contentType.startsWith("application/x-www-form-urlencoded")) {
                this.sampler.parseArguments(postData.trim(), contentEncoding);
            } else if (postData.length() > 0) {
                if (this.isBinaryContent(contentType)) {
                    try {
                        File tempDir = new File(binaryDirectory);
                        File out = File.createTempFile(this.method, binaryFileSuffix, tempDir);
                        FileUtils.writeByteArrayToFile((File)out, (byte[])this.rawPostData);
                        HTTPFileArg[] files = new HTTPFileArg[]{new HTTPFileArg(out.getPath(), "", contentType)};
                        this.sampler.setHTTPFiles(files);
                    }
                    catch (IOException e) {
                        log.warn("Could not create binary file: " + e);
                    }
                } else {
                    this.sampler.addNonEncodedArgument("", postData, "");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("sampler path = " + this.sampler.getPath());
        }
    }

    private boolean isBinaryContent(String contentType) {
        if (contentType == null) {
            return false;
        }
        return binaryContentTypes.contains(contentType);
    }

    private String serverName() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(":"))) {
            str = str.substring(0, i);
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private int serverPort() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf("/"))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(":"))) {
            return Integer.parseInt(str.substring(i + 1).trim());
        }
        return 0;
    }

    private String getPath() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if ((i = str.indexOf("/")) < 0) {
            return "";
        }
        return str.substring(i);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    private String getToken(StringTokenizer tk) {
        if (tk.hasMoreTokens()) {
            return tk.nextToken();
        }
        return "";
    }

    private String getUrlWithoutQuery(URL _url) {
        String fullUrl;
        String urlWithoutQuery = fullUrl = _url.toString();
        String query = _url.getQuery();
        if (query != null) {
            urlWithoutQuery = urlWithoutQuery.substring(0, urlWithoutQuery.length() - query.length() - 1);
        }
        return urlWithoutQuery;
    }

    static {
        String binaries = JMeterUtils.getPropDefault((String)"proxy.binary.types", (String)"application/x-amf,application/x-java-serialized-object");
        if (binaries.length() > 0) {
            StringTokenizer s = new StringTokenizer(binaries, "|, ");
            while (s.hasMoreTokens()) {
                binaryContentTypes.add(s.nextToken());
            }
        }
        numberRequests = JMeterUtils.getPropDefault((String)"proxy.number.requests", (boolean)false);
        requestNumber = 0;
    }
}

