/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderManager
extends ConfigTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    public static final String HEADERS = "HeaderManager.headers";
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{"name", "value"};
    private static final int COLUMN_COUNT = COLUMN_RESOURCE_NAMES.length;
    private Object SOAPHeader = null;

    public HeaderManager() {
        this.setProperty((JMeterProperty)new CollectionProperty(HEADERS, new ArrayList()));
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(HEADERS, new ArrayList()));
    }

    public CollectionProperty getHeaders() {
        return (CollectionProperty)this.getProperty(HEADERS);
    }

    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    public String getColumnName(int column) {
        return COLUMN_RESOURCE_NAMES[column];
    }

    public Class<? extends String> getColumnClass(int column) {
        return COLUMN_RESOURCE_NAMES[column].getClass();
    }

    public Header getHeader(int row) {
        return (Header)this.getHeaders().get(row).getObjectValue();
    }

    public void save(String headFile) throws IOException {
        File file = new File(headFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + headFile);
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# JMeter generated Header file");
        CollectionProperty hdrs = this.getHeaders();
        for (int i = 0; i < hdrs.size(); ++i) {
            JMeterProperty hdr = hdrs.get(i);
            Header head = (Header)hdr.getObjectValue();
            writer.println(head.toString());
        }
        writer.flush();
        writer.close();
    }

    /*
     * Exception decompiling
     */
    public void addFile(String headerFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void add(Header h) {
        this.getHeaders().addItem((Object)h);
    }

    public void add() {
        this.getHeaders().addItem((Object)new Header());
    }

    public void remove(int index) {
        this.getHeaders().remove(index);
    }

    public int size() {
        return this.getHeaders().size();
    }

    public Header get(int i) {
        return (Header)this.getHeaders().get(i).getObjectValue();
    }

    public void removeHeaderNamed(String name) {
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        for (int i = this.getHeaders().size() - 1; i >= 0; --i) {
            Header header = (Header)this.getHeaders().get(i).getObjectValue();
            if (header == null || !header.getName().equalsIgnoreCase(name)) continue;
            removeIndices.add(i);
        }
        for (Integer indice : removeIndices) {
            this.getHeaders().remove(indice.intValue());
        }
    }

    public Object getSOAPHeader() {
        return this.SOAPHeader;
    }

    public void setSOAPHeader(Object header) {
        this.SOAPHeader = header;
    }

    public HeaderManager merge(TestElement element, boolean preferLocalValues) {
        if (!(element instanceof HeaderManager)) {
            throw new IllegalArgumentException("Cannot merge type:" + this.getClass().getName() + " with type:" + element.getClass().getName());
        }
        HeaderManager merged = (HeaderManager)this.clone();
        HeaderManager other = (HeaderManager)element;
        for (int i = 0; i < other.getHeaders().size(); ++i) {
            Header otherHeader = other.get(i);
            boolean found = false;
            for (int j = 0; j < merged.getHeaders().size(); ++j) {
                Header mergedHeader = merged.get(j);
                if (!mergedHeader.getName().equalsIgnoreCase(otherHeader.getName())) continue;
                found = true;
                if (preferLocalValues) break;
                if (otherHeader.getValue() == null || otherHeader.getValue().length() == 0) {
                    merged.remove(j);
                    break;
                }
                mergedHeader.setValue(otherHeader.getValue());
                break;
            }
            if (found) continue;
            merged.add(otherHeader);
        }
        merged.setName(merged.getName() + ":" + other.getName());
        return merged;
    }
}

