/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jmeter.functions.XPathFileContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

final class XPathWrapper {
    private static final Logger log = LoggerFactory.getLogger(XPathWrapper.class);
    private static final Map<String, XPathFileContainer> fileContainers = new HashMap<String, XPathFileContainer>();
    private static final ThreadLocal<Map<String, XPathFileContainer>> filePacks = new ThreadLocal<Map<String, XPathFileContainer>>(){

        @Override
        protected Map<String, XPathFileContainer> initialValue() {
            return new HashMap<String, XPathFileContainer>();
        }
    };

    private XPathWrapper() {
    }

    private static XPathFileContainer open(String file, String xpathString) {
        if (log.isInfoEnabled()) {
            log.info("{}: Opening {}", (Object)Thread.currentThread().getName(), (Object)file);
        }
        XPathFileContainer frcc = null;
        try {
            frcc = new XPathFileContainer(file, xpathString);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            log.warn(e.getLocalizedMessage());
        }
        return frcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXPathString(String file, String xpathString) {
        String key;
        Map<String, XPathFileContainer> my = filePacks.get();
        XPathFileContainer xpfc = my.get(key = file + xpathString);
        if (xpfc == null) {
            Map<String, XPathFileContainer> map = fileContainers;
            synchronized (map) {
                xpfc = fileContainers.get(key);
                if (xpfc == null) {
                    xpfc = XPathWrapper.open(file, xpathString);
                }
                if (xpfc != null) {
                    fileContainers.put(key, xpfc);
                }
            }
            if (xpfc == null) {
                log.error("XPathFileContainer is null!");
                return "";
            }
            my.put(key, xpfc);
        }
        if (xpfc.size() == 0) {
            log.warn("XPathFileContainer has no nodes: {} {}", (Object)file, (Object)xpathString);
            return "";
        }
        int currentRow = xpfc.nextRow();
        if (log.isDebugEnabled()) {
            log.debug("getting match number {}", (Object)Integer.toString(currentRow));
        }
        return xpfc.getXPathString(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        log.debug("clearAll()");
        filePacks.get().clear();
        if (log.isInfoEnabled()) {
            log.info("{}: clearing container", (Object)Thread.currentThread().getName());
        }
        Map<String, XPathFileContainer> map = fileContainers;
        synchronized (map) {
            fileContainers.clear();
        }
    }
}

