/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.functions.XPathWrapper;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY = "__XPath";
    private static final List<String> desc = new LinkedList<String>();
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String myValue = "";
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String xpathString = ((CompoundVariable)this.values[1]).execute();
        if (log.isDebugEnabled()) {
            log.debug("execute (" + fileName + " " + xpathString + ")   ");
        }
        myValue = XPathWrapper.getXPathString(fileName, xpathString);
        if (log.isDebugEnabled()) {
            log.debug("execute value: " + myValue);
        }
        return myValue;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        log.debug("setParameter - Collection.size=" + parameters.size());
        this.values = parameters.toArray();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < parameters.size(); ++i) {
                log.debug("i:" + ((CompoundVariable)this.values[i]).execute());
            }
        }
        this.checkParameterCount(parameters, 2);
        XPathWrapper.clearAll();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"xpath_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"xpath_expression"));
    }
}

