/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathFileContainer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final NodeList nodeList;
    private final String fileName;
    private final String xpath;
    private int nextRow;

    int getNextRow() {
        return this.nextRow;
    }

    public XPathFileContainer(String file, String xpath) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, TransformerException {
        if (log.isDebugEnabled()) {
            log.debug("XPath(" + file + ") xpath " + xpath);
        }
        this.fileName = file;
        this.xpath = xpath;
        this.nextRow = 0;
        this.nodeList = this.load();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeList load() throws IOException, FileNotFoundException, ParserConfigurationException, SAXException, TransformerException {
        BufferedInputStream fis = null;
        NodeList nl = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            fis = new BufferedInputStream(new FileInputStream(this.fileName));
            nl = XPathUtil.selectNodeList((Document)builder.parse(fis), (String)this.xpath);
            if (log.isDebugEnabled()) {
                log.debug("found " + nl.getLength());
            }
        }
        catch (FileNotFoundException e) {
            try {
                log.warn(e.toString());
                throw e;
                catch (IOException e2) {
                    log.warn(e2.toString());
                    throw e2;
                }
                catch (ParserConfigurationException e3) {
                    log.warn(e3.toString());
                    throw e3;
                }
                catch (SAXException e4) {
                    log.warn(e4.toString());
                    throw e4;
                }
                catch (TransformerException e5) {
                    log.warn(e5.toString());
                    throw e5;
                }
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)fis);
        return nl;
    }

    public String getXPathString(int num) {
        return this.nodeList.item(num).getNodeValue();
    }

    public int nextRow() {
        int row = this.nextRow++;
        if (this.nextRow >= this.size()) {
            this.nextRow = 0;
        }
        log.debug("Row: " + row);
        return row;
    }

    public int size() {
        return this.nodeList == null ? -1 : this.nodeList.getLength();
    }

    public String getFileName() {
        return this.fileName;
    }
}

