/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.Backend;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendListener
extends AbstractTestElement
implements Backend,
Serializable,
SampleListener,
TestStateListener,
NoThreadClone,
Remoteable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BackendListener.class);
    public static final String CLASSNAME = "classname";
    public static final String QUEUE_SIZE = "QUEUE_SIZE";
    private static final Object LOCK = new Object();
    public static final String ARGUMENTS = "arguments";
    private Class<?> clientClass;
    public static final String DEFAULT_QUEUE_SIZE = "5000";
    private static final transient SampleResult FINAL_SAMPLE_RESULT = new SampleResult();
    private static final Map<String, ListenerClientData> queuesByTestElementName = new ConcurrentHashMap<String, ListenerClientData>();
    private transient String myName;
    private transient ListenerClientData listenerClientData;

    public BackendListener() {
        this.setArguments(new Arguments());
    }

    public Object clone() {
        BackendListener clone = (BackendListener)super.clone();
        clone.clientClass = this.clientClass;
        return clone;
    }

    private Class<?> initClass() {
        String name = this.getClassname().trim();
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            log.error("{}\tException initialising: {}", new Object[]{this.whoAmI(), name, e});
            return null;
        }
    }

    private String whoAmI() {
        return Thread.currentThread().getName() + "@" + Integer.toHexString(this.hashCode()) + "-" + this.getName();
    }

    public void sampleOccurred(SampleEvent event) {
        Arguments args = this.getArguments();
        BackendListenerContext context = new BackendListenerContext(args);
        SampleResult sr = this.listenerClientData.client.createSampleResult(context, event.getResult());
        if (sr == null) {
            if (log.isDebugEnabled()) {
                log.debug("{} => Dropping SampleResult: {}", (Object)this.getName(), (Object)event.getResult());
            }
            return;
        }
        try {
            if (!this.listenerClientData.queue.offer(sr)) {
                this.listenerClientData.queueWaits.add(1L);
                long t1 = System.nanoTime();
                this.listenerClientData.queue.put(sr);
                long t2 = System.nanoTime();
                this.listenerClientData.queueWaitTime.add(t2 - t1);
            }
        }
        catch (Exception err) {
            log.error("sampleOccurred, failed to queue the sample", (Throwable)err);
        }
    }

    private static void sendToListener(BackendListenerClient backendListenerClient, BackendListenerContext context, List<SampleResult> sampleResults) {
        if (!sampleResults.isEmpty()) {
            backendListenerClient.handleSampleResults(sampleResults, context);
            sampleResults.clear();
        }
    }

    private static BackendListenerClient createBackendListenerClientImpl(Class<?> clientClass) {
        if (clientClass == null) {
            return new ErrorBackendListenerClient();
        }
        try {
            return (BackendListenerClient)clientClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("Exception creating: {}", clientClass, (Object)e);
            return new ErrorBackendListenerClient();
        }
    }

    public void testStarted() {
        this.testStarted("local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String host) {
        int queueSize;
        if (log.isDebugEnabled()) {
            log.debug("{}\ttestStarted({})", (Object)this.whoAmI(), (Object)host);
        }
        String size = this.getQueueSize();
        try {
            queueSize = Integer.parseInt(size);
        }
        catch (NumberFormatException nfe) {
            log.warn("Invalid queue size '{}' defaulting to {}", (Object)size, (Object)DEFAULT_QUEUE_SIZE);
            queueSize = Integer.parseInt(DEFAULT_QUEUE_SIZE);
        }
        Object object = LOCK;
        synchronized (object) {
            this.myName = this.getName();
            this.listenerClientData = queuesByTestElementName.get(this.myName);
            if (this.listenerClientData == null) {
                this.clientClass = this.initClass();
                BackendListenerClient backendListenerClient = BackendListener.createBackendListenerClientImpl(this.clientClass);
                BackendListenerContext context = new BackendListenerContext((Arguments)this.getArguments().clone());
                this.listenerClientData = new ListenerClientData();
                this.listenerClientData.queue = new ArrayBlockingQueue(queueSize);
                this.listenerClientData.queueWaits = new LongAdder();
                this.listenerClientData.queueWaitTime = new LongAdder();
                this.listenerClientData.latch = new CountDownLatch(1);
                this.listenerClientData.client = backendListenerClient;
                if (log.isInfoEnabled()) {
                    log.info("{}: Starting worker with class: {} and queue capacity: {}", new Object[]{this.getName(), this.clientClass, this.getQueueSize()});
                }
                Worker worker = new Worker(backendListenerClient, (Arguments)this.getArguments().clone(), this.listenerClientData);
                worker.setDaemon(true);
                worker.start();
                if (log.isInfoEnabled()) {
                    log.info("{}: Started  worker with class: {}", (Object)this.getName(), this.clientClass);
                }
                try {
                    backendListenerClient.setupTest(context);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed calling setupTest", e);
                }
                queuesByTestElementName.put(this.myName, this.listenerClientData);
            }
            this.listenerClientData.instanceCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        Object object = LOCK;
        synchronized (object) {
            ListenerClientData listenerClientDataForName = queuesByTestElementName.get(this.myName);
            if (log.isDebugEnabled()) {
                log.debug("testEnded called on instance {}#{}", (Object)this.myName, (Object)listenerClientDataForName.instanceCount);
            }
            if (listenerClientDataForName != null) {
                listenerClientDataForName.instanceCount--;
                if (listenerClientDataForName.instanceCount > 0) {
                    return;
                }
                queuesByTestElementName.remove(this.myName);
            } else {
                log.error("No listener client data found for BackendListener {}", (Object)this.myName);
            }
        }
        try {
            this.listenerClientData.queue.put(FINAL_SAMPLE_RESULT);
        }
        catch (Exception ex) {
            log.warn("testEnded() with exception: {}", (Object)ex.getMessage(), (Object)ex);
        }
        if (this.listenerClientData.queueWaits.longValue() > 0L) {
            log.warn("QueueWaits: {}; QueueWaitTime: {} (nanoseconds), you may need to increase queue capacity, see property 'backend_queue_capacity'", (Object)this.listenerClientData.queueWaits, (Object)this.listenerClientData.queueWaitTime);
        }
        try {
            this.listenerClientData.latch.await();
            BackendListenerContext context = new BackendListenerContext(this.getArguments());
            this.listenerClientData.client.teardownTest(context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed calling teardownTest", e);
        }
    }

    public void testEnded() {
        this.testEnded("local");
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void setArguments(Arguments args) {
        args.removeArgument("useRegexpForSamplersList", "false");
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    public void setQueueSize(String queueSize) {
        this.setProperty(QUEUE_SIZE, queueSize, DEFAULT_QUEUE_SIZE);
    }

    public String getQueueSize() {
        return this.getPropertyAsString(QUEUE_SIZE, DEFAULT_QUEUE_SIZE);
    }

    private static final class ListenerClientData {
        private BackendListenerClient client;
        private BlockingQueue<SampleResult> queue;
        private LongAdder queueWaits;
        private LongAdder queueWaitTime;
        private int instanceCount;
        private CountDownLatch latch;

        private ListenerClientData() {
        }
    }

    static class ErrorBackendListenerClient
    extends AbstractBackendListenerClient {
        ErrorBackendListenerClient() {
        }

        @Override
        public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
            log.warn("ErrorBackendListenerClient#handleSampleResult called, noop");
        }
    }

    private static final class Worker
    extends Thread {
        private final ListenerClientData listenerClientData;
        private final BackendListenerContext context;
        private final BackendListenerClient backendListenerClient;

        private Worker(BackendListenerClient backendListenerClient, Arguments arguments, ListenerClientData listenerClientData) {
            this.listenerClientData = listenerClientData;
            arguments.addArgument("TestElement.name", this.getName());
            this.context = new BackendListenerContext(arguments);
            this.backendListenerClient = backendListenerClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isDebugEnabled = log.isDebugEnabled();
            ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>(this.listenerClientData.queue.size());
            try {
                try {
                    boolean endOfLoop = false;
                    while (!endOfLoop) {
                        if (isDebugEnabled) {
                            log.debug("Thread: {} taking SampleResult from queue: {}", (Object)Thread.currentThread().getName(), (Object)this.listenerClientData.queue.size());
                        }
                        SampleResult sampleResult = (SampleResult)this.listenerClientData.queue.take();
                        if (isDebugEnabled) {
                            log.debug("Thread: {} took SampleResult: {}, isFinal: {}", new Object[]{Thread.currentThread().getName(), sampleResult, sampleResult == FINAL_SAMPLE_RESULT});
                        }
                        while (!(endOfLoop = sampleResult == FINAL_SAMPLE_RESULT) && sampleResult != null) {
                            sampleResults.add(sampleResult);
                            if (isDebugEnabled) {
                                log.debug("Thread: {} polling from queue: {}", (Object)Thread.currentThread().getName(), (Object)this.listenerClientData.queue.size());
                            }
                            sampleResult = (SampleResult)this.listenerClientData.queue.poll();
                            if (!isDebugEnabled) continue;
                            log.debug("Thread: {} took from queue: {}, isFinal: {}", new Object[]{Thread.currentThread().getName(), sampleResult, sampleResult == FINAL_SAMPLE_RESULT});
                        }
                        if (isDebugEnabled) {
                            log.debug("Thread: {} exiting with FINAL EVENT: {}, null: {}", new Object[]{Thread.currentThread().getName(), sampleResult == FINAL_SAMPLE_RESULT, sampleResult == null});
                        }
                        BackendListener.sendToListener(this.backendListenerClient, this.context, sampleResults);
                        if (endOfLoop) continue;
                        LockSupport.parkNanos(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                BackendListener.sendToListener(this.backendListenerClient, this.context, sampleResults);
                log.info("Worker ended");
            }
            finally {
                this.listenerClientData.latch.countDown();
            }
        }
    }
}

