/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONManager {
    private static final Logger log = LoggerFactory.getLogger(JSONManager.class);
    private static final Configuration DEFAULT_CONFIGURATION = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
    private final Map<String, JsonPath> expressionToJsonPath = new HashMap<String, JsonPath>(2);

    private JsonPath getJsonPath(String jsonPathExpression) {
        return this.expressionToJsonPath.computeIfAbsent(jsonPathExpression, x$0 -> JsonPath.compile((String)x$0, (Predicate[])new Predicate[0]));
    }

    public void reset() {
        this.expressionToJsonPath.clear();
    }

    public List<Object> extractWithJsonPath(String jsonString, String jsonPath) throws ParseException {
        List extractedObjects;
        JsonPath jsonPathParser = this.getJsonPath(jsonPath);
        try {
            extractedObjects = (List)jsonPathParser.read(jsonString, DEFAULT_CONFIGURATION);
        }
        catch (PathNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not find JSON Path {} in [{}]: {}", new Object[]{jsonPath, jsonString, e.getLocalizedMessage()});
            }
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(extractedObjects.size());
        for (Object obj : extractedObjects) {
            results.add(JSONManager.stringifyJSONObject(obj));
        }
        return Collections.unmodifiableList(results);
    }

    private static String stringifyJSONObject(Object obj) {
        if (obj instanceof Map) {
            return new JSONObject((Map)obj).toJSONString();
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).toJSONString();
        }
        return obj == null ? null : obj.toString();
    }
}

