/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.SMIMEAssertionTestElement;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="smime_assertion_title")
public class SMIMEAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 1L;
    private final JCheckBox verifySignature = new JCheckBox(JMeterUtils.getResString((String)"smime_assertion_verify_signature"));
    private final JCheckBox notSigned = new JCheckBox(JMeterUtils.getResString((String)"smime_assertion_not_signed"));
    private final JRadioButton signerNoCheck = new JRadioButton(JMeterUtils.getResString((String)"smime_assertion_signer_no_check"));
    private final JRadioButton signerCheckConstraints = new JRadioButton(JMeterUtils.getResString((String)"smime_assertion_signer_constraints"));
    private final JRadioButton signerCheckByFile = new JRadioButton(JMeterUtils.getResString((String)"smime_assertion_signer_by_file"));
    private final JTextField signerDnField = new JTextField(50);
    private final JTextField signerSerialNumberField = new JTextField(25);
    private final JTextField signerEmailField = new JTextField(25);
    private final JTextField issuerDnField = new JTextField(50);
    private final JTextField signerCertFile = new JTextField(25);
    private final JTextField messagePositionTf = new JTextField(25);

    public SMIMEAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "smime_assertion_title";
    }

    public void clearGui() {
        super.clearGui();
        this.issuerDnField.setText("");
        this.messagePositionTf.setText("");
        this.notSigned.setSelected(false);
        this.signerCertFile.setText("");
        this.signerCheckByFile.setSelected(false);
        this.signerCheckConstraints.setSelected(false);
        this.signerDnField.setText("");
        this.signerEmailField.setText("");
        this.signerNoCheck.setSelected(false);
        this.signerSerialNumberField.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createSignaturePanel());
        box.add(this.createSignerPanel());
        box.add(this.createMessagePositionPanel());
        this.add(box, "North");
    }

    private JPanel createSignaturePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smime_assertion_signature")));
        this.notSigned.addChangeListener(evt -> this.verifySignature.setEnabled(!this.notSigned.isSelected()));
        panel.add(this.verifySignature);
        panel.add(this.notSigned);
        return panel;
    }

    private JPanel createSignerPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smime_assertion_signer")));
        panel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.signerNoCheck);
        buttonGroup.add(this.signerCheckConstraints);
        buttonGroup.add(this.signerCheckByFile);
        panel.add(this.signerNoCheck);
        panel.add(this.signerCheckConstraints);
        this.signerCheckConstraints.addChangeListener(evt -> {
            boolean signerCC = this.signerCheckConstraints.isSelected();
            this.signerDnField.setEnabled(signerCC);
            this.signerSerialNumberField.setEnabled(signerCC);
            this.signerEmailField.setEnabled(signerCC);
            this.issuerDnField.setEnabled(signerCC);
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(JMeterUtils.getResString((String)"smime_assertion_signer_dn")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.signerDnField);
        panel.add(box);
        box = Box.createHorizontalBox();
        box.add(new JLabel(JMeterUtils.getResString((String)"smime_assertion_signer_email")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.signerEmailField);
        panel.add(box);
        box = Box.createHorizontalBox();
        box.add(new JLabel(JMeterUtils.getResString((String)"smime_assertion_issuer_dn")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.issuerDnField);
        panel.add(box);
        box = Box.createHorizontalBox();
        box.add(new JLabel(JMeterUtils.getResString((String)"smime_assertion_signer_serial")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.signerSerialNumberField);
        panel.add(box);
        this.signerCheckByFile.addChangeListener(evt -> this.signerCertFile.setEnabled(this.signerCheckByFile.isSelected()));
        box = Box.createHorizontalBox();
        box.add(this.signerCheckByFile);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.signerCertFile);
        panel.add(box);
        return panel;
    }

    private JPanel createMessagePositionPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"smime_assertion_message_position")));
        panel.add(this.messagePositionTf);
        return panel;
    }

    public void configure(TestElement el) {
        super.configure(el);
        SMIMEAssertionTestElement smimeAssertion = (SMIMEAssertionTestElement)el;
        this.verifySignature.setSelected(smimeAssertion.isVerifySignature());
        this.notSigned.setSelected(smimeAssertion.isNotSigned());
        if (smimeAssertion.isSignerNoCheck()) {
            this.signerNoCheck.setSelected(true);
        }
        if (smimeAssertion.isSignerCheckConstraints()) {
            this.signerCheckConstraints.setSelected(true);
        }
        if (smimeAssertion.isSignerCheckByFile()) {
            this.signerCheckByFile.setSelected(true);
        }
        this.issuerDnField.setText(smimeAssertion.getIssuerDn());
        this.signerDnField.setText(smimeAssertion.getSignerDn());
        this.signerSerialNumberField.setText(smimeAssertion.getSignerSerial());
        this.signerEmailField.setText(smimeAssertion.getSignerEmail());
        this.signerCertFile.setText(smimeAssertion.getSignerCertFile());
        this.messagePositionTf.setText(smimeAssertion.getSpecificMessagePosition());
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        SMIMEAssertionTestElement smimeAssertion = (SMIMEAssertionTestElement)el;
        smimeAssertion.setVerifySignature(this.verifySignature.isSelected());
        smimeAssertion.setNotSigned(this.notSigned.isSelected());
        smimeAssertion.setIssuerDn(this.issuerDnField.getText());
        smimeAssertion.setSignerDn(this.signerDnField.getText());
        smimeAssertion.setSignerSerial(this.signerSerialNumberField.getText());
        smimeAssertion.setSignerEmail(this.signerEmailField.getText());
        smimeAssertion.setSignerCertFile(this.signerCertFile.getText());
        smimeAssertion.setSignerNoCheck(this.signerNoCheck.isSelected());
        smimeAssertion.setSignerCheckConstraints(this.signerCheckConstraints.isSelected());
        smimeAssertion.setSignerCheckByFile(this.signerCheckByFile.isSelected());
        smimeAssertion.setSpecificMessagePosition(this.messagePositionTf.getText());
    }

    public TestElement createTestElement() {
        SMIMEAssertionTestElement smimeAssertion = new SMIMEAssertionTestElement();
        this.modifyTestElement((TestElement)smimeAssertion);
        return smimeAssertion;
    }
}

