/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.ForeachController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class ForeachControlPanel
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JTextField inputVal;
    private JTextField returnVal;
    private JCheckBox useSeparator;
    private boolean displayName = true;
    private static final String INPUTVAL = "Input Field";
    private static final String RETURNVAL = "Return Field";

    public ForeachControlPanel() {
        this(true);
    }

    public ForeachControlPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.inputVal.setText(((ForeachController)element).getInputValString());
        this.returnVal.setText(((ForeachController)element).getReturnValString());
        this.useSeparator.setSelected(((ForeachController)element).getUseSeparator());
    }

    public TestElement createTestElement() {
        ForeachController lc = new ForeachController();
        this.modifyTestElement((TestElement)lc);
        return lc;
    }

    public void modifyTestElement(TestElement lc) {
        this.configureTestElement(lc);
        if (lc instanceof ForeachController) {
            if (this.inputVal.getText().length() > 0) {
                ((ForeachController)lc).setInputVal(this.inputVal.getText());
            } else {
                ((ForeachController)lc).setInputVal("");
            }
            if (this.returnVal.getText().length() > 0) {
                ((ForeachController)lc).setReturnVal(this.returnVal.getText());
            } else {
                ((ForeachController)lc).setReturnVal("");
            }
            ((ForeachController)lc).setUseSeparator(this.useSeparator.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.inputVal.setText("");
        this.returnVal.setText("");
        this.useSeparator.setSelected(true);
    }

    public String getLabelResource() {
        return "foreach_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createLoopCountPanel(), "North");
            this.add(mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.createLoopCountPanel(), "North");
        }
    }

    private JPanel createLoopCountPanel() {
        VerticalPanel loopPanel = new VerticalPanel();
        JLabel inputValLabel = new JLabel(JMeterUtils.getResString((String)"foreach_input"));
        JLabel returnValLabel = new JLabel(JMeterUtils.getResString((String)"foreach_output"));
        JPanel inputValSubPanel = new JPanel(new BorderLayout(5, 0));
        this.inputVal = new JTextField("", 5);
        this.inputVal.setName(INPUTVAL);
        inputValLabel.setLabelFor(this.inputVal);
        inputValSubPanel.add((Component)inputValLabel, "West");
        inputValSubPanel.add((Component)this.inputVal, "Center");
        JPanel returnValSubPanel = new JPanel(new BorderLayout(5, 0));
        this.returnVal = new JTextField("", 5);
        this.returnVal.setName(RETURNVAL);
        returnValLabel.setLabelFor(this.returnVal);
        returnValSubPanel.add((Component)returnValLabel, "West");
        returnValSubPanel.add((Component)this.returnVal, "Center");
        this.useSeparator = new JCheckBox(JMeterUtils.getResString((String)"foreach_use_separator"), true);
        loopPanel.add((Component)inputValSubPanel);
        loopPanel.add((Component)returnValSubPanel);
        loopPanel.add((Component)this.useSeparator);
        return loopPanel;
    }
}

