/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.GraphAccumListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphAccumModel
implements Clearable,
Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private String name;
    private final List<SampleResult> samples;
    private final List<GraphAccumListener> listeners;
    private long max = 1L;
    private boolean bigChange = false;
    private SampleResult current;

    public GraphAccumModel() {
        log.debug("Start : GraphAccumModel1");
        this.listeners = new LinkedList<GraphAccumListener>();
        this.samples = Collections.synchronizedList(new LinkedList());
        log.debug("End : GraphAccumModel1");
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public List<SampleResult> getList() {
        return this.samples;
    }

    public String getName() {
        return this.name;
    }

    public long getMax() {
        if (log.isDebugEnabled()) {
            log.debug("getMax1 : Returning - " + this.max);
        }
        return this.max;
    }

    public void addGraphAccumListener(GraphAccumListener listener) {
        this.listeners.add(listener);
    }

    public void clearData() {
        log.debug("Start : clear1");
        this.samples.clear();
        this.max = 1L;
        this.bigChange = true;
        this.fireDataChanged();
        log.debug("End : clear1");
    }

    public void addNewSample(SampleResult res) {
        log.debug("Start : addNewSample1");
        long totalTime = res.getTime();
        if (log.isDebugEnabled()) {
            log.debug("addNewSample1 : time - " + totalTime);
            log.debug("addNewSample1 : max - " + this.max);
        }
        if (totalTime > this.max) {
            this.bigChange = true;
            this.max = totalTime;
        }
        this.current = res;
        this.samples.add(res);
        log.debug("End : addNewSample1");
        this.fireDataChanged();
    }

    protected void fireDataChanged() {
        log.debug("Start : fireDataChanged1");
        if (this.bigChange) {
            for (GraphAccumListener gal : this.listeners) {
                gal.updateGui();
            }
            this.bigChange = false;
        } else {
            this.quickUpdate(this.current);
        }
        log.debug("End : fireDataChanged1");
    }

    protected void quickUpdate(SampleResult s) {
        for (GraphAccumListener gal : this.listeners) {
            gal.updateGui(s);
        }
    }
}

