/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.log.Logger;

public class BeanShellTimer
extends BeanShellTestElement
implements Cloneable,
Timer,
TestBean {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 4L;
    private static final String INIT_FILE = "beanshell.timer.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public long delay() {
        String ret = "0";
        BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
        if (bshInterpreter == null) {
            log.error("BeanShell not found");
            return 0L;
        }
        try {
            Object o = this.processFileOrScript(bshInterpreter);
            if (o != null) {
                ret = o.toString();
            }
        }
        catch (JMeterException e) {
            log.warn("Problem in BeanShell script " + (Object)((Object)e));
        }
        try {
            return Long.decode(ret);
        }
        catch (NumberFormatException e) {
            log.warn(e.getLocalizedMessage());
            return 0L;
        }
    }
}

