/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.NodeLib;
import org.apache.jena.tdb2.store.Hash;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableOps;

public abstract class NodeTableNative
implements NodeTable {
    protected Index nodeHashToId;
    private boolean syncNeeded = false;

    public NodeTableNative(Index nodeToId) {
        this.nodeHashToId = nodeToId;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    @Override
    public boolean containsNode(Node node) {
        NodeId x = this.getNodeIdForNode(node);
        return NodeId.isDoesNotExist(x);
    }

    @Override
    public boolean containsNodeId(NodeId nodeId) {
        Node x = this.getNodeForNodeId(nodeId);
        return x == null;
    }

    @Override
    public List<NodeId> bulkNodeToNodeId(List<Node> nodes, boolean withAllocation) {
        return NodeTableOps.bulkNodeToNodeIdImpl(this, nodes, withAllocation);
    }

    @Override
    public List<Node> bulkNodeIdToNode(List<NodeId> nodeIds) {
        return NodeTableOps.bulkNodeIdToNodeImpl(this, nodeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            Node n = this.readNodeFromTable(id);
            return n;
        }
    }

    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = this.accessIndex(node, allocate);
        return nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NodeId accessIndex(Node node, boolean create) {
        Hash hash = new Hash(this.nodeHashToId.getRecordFactory().keyLength());
        NodeLib.setHash(hash, node);
        byte[] k = hash.getBytes();
        Record r = this.nodeHashToId.getRecordFactory().create(k);
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            Record r2 = this.nodeHashToId.find(r);
            if (r2 != null) {
                NodeId id = NodeIdFactory.get(r2.getValue(), 0);
                return id;
            }
            if (!create) {
                return NodeId.NodeDoesNotExist;
            }
            this.syncNeeded = true;
            NodeId id = this.writeNodeToTable(node);
            NodeIdFactory.set(id, r.getValue(), 0);
            if (!this.nodeHashToId.insert(r)) {
                throw new TDBException("NodeTableBase::nodeToId - record mysteriously appeared");
            }
            return id;
        }
    }

    protected abstract NodeId writeNodeToTable(Node var1);

    protected abstract Node readNodeFromTable(NodeId var1);

    protected abstract void syncSub();

    protected abstract void closeSub();

    public synchronized void close() {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.close();
            this.closeSub();
            this.nodeHashToId = null;
        }
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.all2();
    }

    private Iterator<Pair<NodeId, Node>> all2() {
        throw new NotImplemented();
    }

    public void sync() {
        if (this.syncNeeded) {
            this.syncSub();
            if (this.nodeHashToId != null) {
                this.nodeHashToId.sync();
            }
            this.syncNeeded = false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodeHashToId.isEmpty();
    }

    @Override
    public NodeTable wrapped() {
        return null;
    }
}

