/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.arq.querybuilder.rewriters.ExprRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.op.OpAntiJoin;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSemiJoin;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.pfunction.PropFuncArg;

class OpRewriter
extends AbstractRewriter<Op>
implements OpVisitor {
    OpRewriter(Map<Var, Node> values) {
        super(values);
    }

    private Quad rewrite(Quad q) {
        return new Quad(this.changeNode(q.getGraph()), this.changeNode(q.getSubject()), this.changeNode(q.getPredicate()), this.changeNode(q.getObject()));
    }

    private QuadPattern rewrite(QuadPattern pattern) {
        QuadPattern qp = new QuadPattern();
        for (Quad q : pattern.getList()) {
            qp.add(this.rewrite(q));
        }
        return qp;
    }

    private List<Op> rewriteOpList(List<Op> lst) {
        ArrayList<Op> retval = new ArrayList<Op>();
        for (Op o : lst) {
            o.visit((OpVisitor)this);
            retval.add((Op)this.pop());
        }
        return retval;
    }

    private BasicPattern rewrite(BasicPattern pattern) {
        return BasicPattern.wrap(this.rewrite(pattern.getList()));
    }

    public void visit(OpBGP opBGP) {
        this.push(new OpBGP(this.rewrite(opBGP.getPattern())));
    }

    public void visit(OpQuadPattern quadPattern) {
        this.push(new OpQuadPattern(this.changeNode(quadPattern.getGraphNode()), this.rewrite(quadPattern.getBasicPattern())));
    }

    public void visit(OpQuadBlock quadBlock) {
        this.push(new OpQuadBlock(this.rewrite(quadBlock.getPattern())));
    }

    public void visit(OpTriple opTriple) {
        this.push(new OpTriple(this.rewrite(opTriple.getTriple())));
    }

    public void visit(OpQuad opQuad) {
        this.push(new OpQuad(this.rewrite(opQuad.getQuad())));
    }

    public void visit(OpPath opPath) {
        this.push(new OpPath(this.rewrite(opPath.getTriplePath())));
    }

    public void visit(OpTable opTable) {
        Table tbl = opTable.getTable();
        boolean process = false;
        for (Var v : tbl.getVars()) {
            process |= this.values.keySet().contains(v);
        }
        if (!process) {
            this.push(opTable);
        } else {
            TableN retTbl = new TableN(tbl.getVars());
            Iterator iter = tbl.rows();
            while (iter.hasNext()) {
                retTbl.addBinding(this.rewrite((Binding)iter.next()));
            }
            this.push(OpTable.create((Table)retTbl));
        }
    }

    public void visit(OpNull opNull) {
        this.push(opNull);
    }

    public void visit(OpProcedure opProc) {
        opProc.getSubOp().visit((OpVisitor)this);
        Op op = (Op)this.pop();
        ExprList args = new ExprRewriter(this.values).rewrite(opProc.getArgs());
        Node procId = this.changeNode(opProc.getProcId());
        this.push(new OpProcedure(procId, args, op));
    }

    private PropFuncArg rewrite(PropFuncArg arg) {
        if (arg.isList()) {
            List<Node> lst = this.changeNodes(arg.getArgList());
            return new PropFuncArg(lst, null);
        }
        return new PropFuncArg(this.changeNode(arg.getArg()));
    }

    public void visit(OpPropFunc opPropFunc) {
        opPropFunc.getSubOp().visit((OpVisitor)this);
        Op op = (Op)this.pop();
        Node uri = this.changeNode(opPropFunc.getProperty());
        PropFuncArg args1 = this.rewrite(opPropFunc.getSubjectArgs());
        PropFuncArg args2 = this.rewrite(opPropFunc.getObjectArgs());
        this.push(new OpPropFunc(uri, args1, args2, op));
    }

    public void visit(OpFilter opFilter) {
        opFilter.getSubOp().visit((OpVisitor)this);
        this.push(OpFilter.filterBy((ExprList)new ExprRewriter(this.values).rewrite(opFilter.getExprs()), (Op)((Op)this.pop())));
    }

    public void visit(OpGraph opGraph) {
        opGraph.getSubOp().visit((OpVisitor)this);
        this.push(new OpGraph(this.changeNode(opGraph.getNode()), (Op)this.pop()));
    }

    public void visit(OpService opService) {
        opService.getSubOp().visit((OpVisitor)this);
        this.push(new OpService(this.changeNode(opService.getService()), (Op)this.pop(), opService.getSilent()));
    }

    public void visit(OpDatasetNames dsNames) {
        this.push(new OpDatasetNames(this.changeNode(dsNames.getGraphNode())));
    }

    public void visit(OpLabel opLabel) {
        if (opLabel.hasSubOp()) {
            opLabel.getSubOp().visit((OpVisitor)this);
            this.push(OpLabel.create((Object)opLabel.getObject(), (Op)((Op)this.pop())));
        } else {
            this.push(opLabel);
        }
    }

    public void visit(OpAssign opAssign) {
        opAssign.getSubOp().visit((OpVisitor)this);
        this.push(OpAssign.assign((Op)((Op)this.pop()), (VarExprList)this.rewrite(opAssign.getVarExprList())));
    }

    public void visit(OpExtend opExtend) {
        opExtend.getSubOp().visit((OpVisitor)this);
        this.push(OpExtend.extend((Op)((Op)this.pop()), (VarExprList)this.rewrite(opExtend.getVarExprList())));
    }

    public void visit(OpUnfold opUnfold) {
        opUnfold.getSubOp().visit((OpVisitor)this);
        this.push(new OpUnfold((Op)this.pop(), opUnfold.getExpr(), opUnfold.getVar1(), opUnfold.getVar2()));
    }

    public void visit(OpJoin opJoin) {
        opJoin.getRight().visit((OpVisitor)this);
        opJoin.getLeft().visit((OpVisitor)this);
        this.push(OpJoin.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpLeftJoin opLeftJoin) {
        opLeftJoin.getRight().visit((OpVisitor)this);
        opLeftJoin.getLeft().visit((OpVisitor)this);
        this.push(OpLeftJoin.create((Op)((Op)this.pop()), (Op)((Op)this.pop()), (ExprList)new ExprRewriter(this.values).rewrite(opLeftJoin.getExprs())));
    }

    public void visit(OpUnion opUnion) {
        opUnion.getRight().visit((OpVisitor)this);
        opUnion.getLeft().visit((OpVisitor)this);
        this.push(OpUnion.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpMinus opMinus) {
        opMinus.getRight().visit((OpVisitor)this);
        opMinus.getLeft().visit((OpVisitor)this);
        this.push(OpMinus.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpLateral opLateral) {
        opLateral.getRight().visit((OpVisitor)this);
        opLateral.getLeft().visit((OpVisitor)this);
        this.push(OpLateral.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpSemiJoin opSemiJoin) {
        opSemiJoin.getRight().visit((OpVisitor)this);
        opSemiJoin.getLeft().visit((OpVisitor)this);
        this.push(OpSemiJoin.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpAntiJoin opAntiJoin) {
        opAntiJoin.getRight().visit((OpVisitor)this);
        opAntiJoin.getLeft().visit((OpVisitor)this);
        this.push(OpAntiJoin.create((Op)((Op)this.pop()), (Op)((Op)this.pop())));
    }

    public void visit(OpConditional opCondition) {
        opCondition.getRight().visit((OpVisitor)this);
        opCondition.getLeft().visit((OpVisitor)this);
        this.push(new OpConditional((Op)this.pop(), (Op)this.pop()));
    }

    public void visit(OpSequence opSequence) {
        List<Op> lst = this.rewriteOpList(opSequence.getElements());
        this.push(opSequence.copy(lst));
    }

    public void visit(OpDisjunction opDisjunction) {
        List<Op> lst = this.rewriteOpList(opDisjunction.getElements());
        this.push(opDisjunction.copy(lst));
    }

    public void visit(OpExt opExt) {
        this.push(opExt);
    }

    public void visit(OpList opList) {
        opList.getSubOp().visit((OpVisitor)this);
        this.push(new OpList((Op)this.pop()));
    }

    public void visit(OpOrder opOrder) {
        List<SortCondition> lst = new ExprRewriter(this.values).rewriteSortConditionList(opOrder.getConditions());
        opOrder.getSubOp().visit((OpVisitor)this);
        this.push(new OpOrder((Op)this.pop(), lst));
    }

    public void visit(OpProject opProject) {
        opProject.getSubOp().visit((OpVisitor)this);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Var v : opProject.getVars()) {
            Node n = this.changeNode((Node)v);
            vars.add(Var.alloc((Node)n));
        }
        this.push(new OpProject((Op)this.pop(), vars));
    }

    public void visit(OpReduced opReduced) {
        opReduced.getSubOp().visit((OpVisitor)this);
        this.push(opReduced.copy((Op)this.pop()));
    }

    public void visit(OpDistinct opDistinct) {
        opDistinct.getSubOp().visit((OpVisitor)this);
        this.push(opDistinct.copy((Op)this.pop()));
    }

    public void visit(OpSlice opSlice) {
        opSlice.getSubOp().visit((OpVisitor)this);
        this.push(opSlice.copy((Op)this.pop()));
    }

    public void visit(OpGroup opGroup) {
        opGroup.getSubOp().visit((OpVisitor)this);
        ExprRewriter expRewriter = new ExprRewriter(this.values);
        VarExprList groupVars = this.rewrite(opGroup.getGroupVars());
        ArrayList<ExprAggregator> aggregators = new ArrayList<ExprAggregator>();
        for (ExprAggregator ea : opGroup.getAggregators()) {
            ea.visit((ExprVisitor)expRewriter);
            aggregators.add((ExprAggregator)expRewriter.pop());
        }
        this.push(new OpGroup((Op)this.pop(), groupVars, aggregators));
    }

    public void visit(OpTopN opTop) {
        opTop.getSubOp().visit((OpVisitor)this);
        ExprRewriter expRewriter = new ExprRewriter(this.values);
        expRewriter.rewriteSortConditionList(opTop.getConditions());
        this.push(new OpTopN((Op)this.pop(), opTop.getLimit(), expRewriter.rewriteSortConditionList(opTop.getConditions())));
    }
}

