/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.clauses.PrologClause;
import org.apache.jena.arq.querybuilder.clauses.ValuesClause;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.PrologHandler;
import org.apache.jena.arq.querybuilder.handlers.ValuesHandler;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.util.ExprUtils;

public abstract class AbstractQueryBuilder<T extends AbstractQueryBuilder<T>>
implements Cloneable,
PrologClause<T>,
ValuesClause<T> {
    protected Query query = new Query();
    private final Map<Var, Node> values = new HashMap<Var, Node>();

    public Node makeNode(Object o) {
        return Converters.makeNode(o, this.query.getPrefixMapping());
    }

    private Object makeNodeOrPath(Object o) {
        return Converters.makeNodeOrPath(o, this.query.getPrefixMapping());
    }

    @Deprecated
    public static Object makeNodeOrPath(Object o, PrefixMapping pMapping) {
        return Converters.makeNodeOrPath(o, pMapping);
    }

    public ElementSubQuery asSubQuery() {
        return this.getWhereHandler().makeSubQuery(this);
    }

    @Deprecated(since="5.0.0")
    public TriplePath makeTriplePath(Object s, Object p, Object o) {
        Object po = this.makeNodeOrPath(p);
        if (po instanceof Path) {
            return new TriplePath(this.makeNode(s), (Path)po, this.makeNode(o));
        }
        return new TriplePath(Triple.create((Node)this.makeNode(s), (Node)((Node)po), (Node)this.makeNode(o)));
    }

    public List<TriplePath> makeTriplePaths(Object s, Object p, Object o) {
        return Converters.makeTriplePaths(s, p, o, this.query.getPrefixMapping());
    }

    public Expr makeExpr(String expression) throws QueryParseException {
        return ExprUtils.parse((Query)this.query, (String)expression, (boolean)true);
    }

    @Deprecated
    public static String quote(String q) {
        return Converters.quoted(q);
    }

    @Deprecated
    public static Node checkVar(Node n) {
        return Converters.checkVar(n);
    }

    @Deprecated
    public static Node makeNode(Object o, PrefixMapping pMapping) {
        return Converters.makeNode(o, pMapping);
    }

    @Deprecated
    public static Var makeVar(Object o) throws ARQInternalErrorException {
        return Converters.makeVar(o);
    }

    protected AbstractQueryBuilder() {
    }

    public abstract HandlerBlock getHandlerBlock();

    @Override
    public final PrologHandler getPrologHandler() {
        return this.getHandlerBlock().getPrologHandler();
    }

    @Override
    public ValuesHandler getValuesHandler() {
        return this.getHandlerBlock().getValueHandler();
    }

    public final WhereHandler getWhereHandler() {
        return this.getHandlerBlock().getWhereHandler();
    }

    public final T addWhere(AbstractQueryBuilder<?> whereClause) {
        this.getWhereHandler().addAll(whereClause.getWhereHandler());
        return (T)this;
    }

    @Override
    public final ExprFactory getExprFactory() {
        return this.getHandlerBlock().getPrologHandler().getExprFactory();
    }

    public void setVar(Var var, Node value) {
        if (value == null) {
            this.values.remove(var);
        } else {
            this.values.put(var, value);
        }
    }

    public void setVar(Object var, Object value) {
        if (value == null) {
            this.setVar(Converters.makeVar(var), null);
        } else {
            this.setVar(Converters.makeVar(var), this.makeNode(value));
        }
    }

    @Override
    public T addPrefix(String pfx, Resource uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    @Override
    public T addPrefix(String pfx, Node uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    @Override
    public T addPrefix(String pfx, String uri) {
        this.getPrologHandler().addPrefix(pfx, uri);
        return (T)this;
    }

    @Override
    public T addPrefixes(Map<String, String> prefixes) {
        this.getPrologHandler().addPrefixes(prefixes);
        return (T)this;
    }

    @Override
    public T addPrefixes(PrefixMapping prefixMapping) {
        this.getPrologHandler().addPrefixes(prefixMapping);
        return (T)this;
    }

    @Override
    public T setBase(String base) {
        this.getPrologHandler().setBase(base);
        return (T)this;
    }

    @Override
    public T setBase(Object base) {
        this.setBase(this.makeNode(base).getURI());
        return (T)this;
    }

    @Deprecated
    public static Collection<Node> makeValueNodes(Iterator<?> iter, PrefixMapping prefixMapping) {
        return Converters.makeValueNodes(iter, prefixMapping);
    }

    public Collection<Node> makeValueNodes(Iterator<?> iter) {
        return Converters.makeValueNodes(iter, this.getPrologHandler().getPrefixes());
    }

    @Override
    public T addValueVar(Object var) {
        if (var == null) {
            throw new IllegalArgumentException("var must not be null.");
        }
        if (var instanceof Collection) {
            Collection column = (Collection)var;
            if (column.size() == 0) {
                throw new IllegalArgumentException("column must have at least one entry.");
            }
            Iterator iter = column.iterator();
            Var v = Converters.makeVar(iter.next());
            this.getValuesHandler().addValueVar(v, this.makeValueNodes(iter));
        } else {
            this.getValuesHandler().addValueVar(Converters.makeVar(var), null);
        }
        return (T)this;
    }

    @Override
    public T addValueVar(Object var, Object ... objects) {
        Collection<Node> values = null;
        if (objects != null) {
            values = this.makeValueNodes(Arrays.asList(objects).iterator());
        }
        this.getValuesHandler().addValueVar(Converters.makeVar(var), values);
        return (T)this;
    }

    @Override
    public <K extends Collection<?>> T addValueVars(Map<?, K> dataTable) {
        ValuesHandler hdlr = new ValuesHandler(null);
        for (Map.Entry<?, K> entry : dataTable.entrySet()) {
            Collection<Node> values = null;
            if (entry.getValue() != null) {
                values = this.makeValueNodes(((Collection)entry.getValue()).iterator());
            }
            hdlr.addValueVar(Converters.makeVar(entry.getKey()), values);
        }
        this.getValuesHandler().addAll(hdlr);
        return (T)this;
    }

    @Override
    public T addValueRow(Object ... values) {
        this.getValuesHandler().addValueRow(this.makeValueNodes(Arrays.asList(values).iterator()));
        return (T)this;
    }

    @Override
    public T addValueRow(Collection<?> values) {
        this.getValuesHandler().addValueRow(this.makeValueNodes(values.iterator()));
        return (T)this;
    }

    @Override
    public List<Var> getValuesVars() {
        return this.getValuesHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getValuesMap() {
        return this.getValuesHandler().getValuesMap();
    }

    @Override
    public T clearValues() {
        this.getValuesHandler().clear();
        return (T)this;
    }

    public String toString() {
        return this.buildString();
    }

    public final String buildString() {
        return this.build().toString();
    }

    public final Query build() {
        Query q = new Query();
        switch (this.query.queryType()) {
            case ASK: {
                q.setQueryAskType();
                break;
            }
            case CONSTRUCT: {
                q.setQueryConstructType();
                break;
            }
            case DESCRIBE: {
                q.setQueryDescribeType();
                break;
            }
            case SELECT: {
                q.setQuerySelectType();
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalStateException("Internal query is not a known type: " + String.valueOf(q.queryType()));
            }
        }
        HandlerBlock handlerBlock = new HandlerBlock(q);
        handlerBlock.addAll(this.getHandlerBlock());
        handlerBlock.setVars(this.values);
        if (q.getQueryPattern() == null) {
            q.setQueryPattern((Element)new ElementGroup());
        }
        handlerBlock.build();
        q.resetResultVars();
        return q;
    }

    public static Query clone(Query q2) {
        Query retval = new Query();
        if (q2.isSelectType()) {
            retval.setQuerySelectType();
        } else if (q2.isAskType()) {
            retval.setQueryAskType();
        } else if (q2.isDescribeType()) {
            retval.setQueryDescribeType();
        } else if (q2.isConstructType()) {
            retval.setQueryConstructType();
        }
        HandlerBlock hb = new HandlerBlock(retval);
        HandlerBlock hb2 = new HandlerBlock(q2);
        hb.addAll(hb2);
        q2.resetResultVars();
        return retval;
    }

    public static Query rewrite(Query q2, Map<Var, Node> values) {
        HandlerBlock hb = new HandlerBlock(q2);
        hb.setVars(values);
        return q2;
    }
}

