/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi;

import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.ontapi.GraphRepository;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.OntSpecification;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.common.OntConfigs;
import org.apache.jena.ontapi.common.OntObjectPersonalityBuilder;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.UnionGraphImpl;
import org.apache.jena.ontapi.impl.repositories.OntUnionGraphRepository;
import org.apache.jena.ontapi.impl.repositories.PersistentGraphRepository;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class OntModelFactory {
    public static final PrefixMapping STANDARD = PrefixMapping.Factory.create().setNsPrefix("owl", "http://www.w3.org/2002/07/owl#").setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#").setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#").lock();

    public static void init() {
        JenaSystem.init();
    }

    public static Graph createDefaultGraph() {
        return GraphMemFactory.createGraphMem();
    }

    public static UnionGraph createUnionGraph(Graph base) {
        return new UnionGraphImpl(base, false);
    }

    public static Model createDefaultModel() {
        return OntModelFactory.createDefaultModel(OntModelFactory.createDefaultGraph());
    }

    public static Model createDefaultModel(Graph graph) {
        return new ModelCom(Objects.requireNonNull(graph));
    }

    public static OntModel createModel() {
        return OntModelFactory.createModel(OntModelFactory.createDefaultGraph());
    }

    public static OntModel createModel(Graph graph) {
        return (OntModel)OntModelFactory.createModel(graph, OntSpecification.OWL2_DL_MEM_BUILTIN_RDFS_INF).setNsPrefixes(STANDARD);
    }

    public static OntModel createModel(Graph graph, OntPersonality personality) {
        OntPersonality withBuiltinHierarchySupport = OntObjectPersonalityBuilder.from(personality).setConfig(OntConfigs.OWL2_CONFIG.setTrue(OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT)).build();
        return (OntModel)OntModelFactory.createModel(graph, new OntSpecification(withBuiltinHierarchySupport, null)).setNsPrefixes(STANDARD);
    }

    public static OntModel createModel(OntSpecification spec) {
        return (OntModel)OntModelFactory.createModel(OntModelFactory.createDefaultGraph(), spec).setNsPrefixes(STANDARD);
    }

    public static OntModel createModel(Graph graph, OntSpecification spec) {
        Objects.requireNonNull(graph);
        ReasonerFactory reasonerFactory = Objects.requireNonNull(spec).getReasonerFactory();
        if (reasonerFactory == null) {
            return new OntGraphModelImpl(Graphs.makeOntUnionFrom(graph, OntModelFactory::createUnionGraph), spec.getPersonality());
        }
        return OntModelFactory.createModel(graph, spec.getPersonality(), reasonerFactory.create(null));
    }

    public static OntModel createModel(Graph graph, OntPersonality personality, Reasoner reasoner) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(reasoner);
        Objects.requireNonNull(personality);
        if (Graphs.dataGraphs(graph).anyMatch(it -> it instanceof InfGraph)) {
            throw new IllegalArgumentException("InfGraph in the hierarchy detected");
        }
        UnionGraph unionGraph = Graphs.makeOntUnionFrom(graph, OntModelFactory::createUnionGraph);
        InfGraph infGraph = reasoner.bind((Graph)unionGraph);
        return new OntGraphModelImpl(infGraph, personality);
    }

    public static OntModel createModel(String uri, GraphRepository repository) {
        return (OntModel)OntModelFactory.createModel(OntModelFactory.createOntGraph(uri != null ? NodeFactory.createURI((String)uri) : NodeFactory.createBlankNode(), repository), OntSpecification.OWL2_DL_MEM_BUILTIN_RDFS_INF, repository).setNsPrefixes(STANDARD);
    }

    public static OntModel createModel(OntSpecification spec, GraphRepository repository) {
        return (OntModel)OntModelFactory.createModel(null, spec, repository).setNsPrefixes(STANDARD);
    }

    public static OntModel createModel(Graph graph, OntSpecification spec, GraphRepository repository) {
        UnionGraph union;
        Objects.requireNonNull(spec);
        Objects.requireNonNull(repository);
        if (Graphs.dataGraphs(graph).anyMatch(it -> it instanceof InfGraph)) {
            throw new IllegalArgumentException("InfGraph in the hierarchy detected");
        }
        if (graph == null) {
            graph = OntModelFactory.createOntGraph(NodeFactory.createBlankNode(), repository);
        }
        OntUnionGraphRepository ontUnionGraphRepository = new OntUnionGraphRepository(repository, OntModelFactory::createUnionGraph, n -> OntModelFactory.createOntGraph(n, repository), true);
        if (graph instanceof UnionGraph) {
            union = (UnionGraph)graph;
            Graphs.flatHierarchy((UnionGraph)graph).forEach(it -> {
                Graphs.findOntologyNameNode(it.getBaseGraph()).orElseGet(() -> Graphs.createOntologyHeaderNode(it, null));
                ontUnionGraphRepository.put((Graph)it);
            });
        } else {
            Graphs.dataGraphs(graph).forEach(it -> {
                String name = Graphs.findOntologyNameNode(it).orElseGet(() -> Graphs.createOntologyHeaderNode(it, null)).toString();
                repository.put(name, (Graph)it);
            });
            union = ontUnionGraphRepository.put(Graphs.getPrimary(graph));
        }
        ReasonerFactory reasonerFactory = spec.getReasonerFactory();
        if (reasonerFactory == null) {
            return new OntGraphModelImpl(union, spec.getPersonality());
        }
        InfGraph inf = reasonerFactory.create(null).bind((Graph)union);
        return new OntGraphModelImpl(inf, spec.getPersonality());
    }

    public static OntModel getModelOrNull(String uri, OntSpecification spec, GraphRepository repository) {
        return OntModelFactory.getModelOrNull(NodeFactory.createURI((String)Objects.requireNonNull(uri)), spec, repository);
    }

    public static OntModel getModelOrNull(Node name, OntSpecification spec, GraphRepository repository) {
        Objects.requireNonNull(spec);
        Objects.requireNonNull(repository);
        Objects.requireNonNull(name);
        if (!name.isURI() && !name.isBlank()) {
            throw new IllegalArgumentException("Ontology name must be URI or blank Node");
        }
        OntUnionGraphRepository ontUnionGraphRepository = new OntUnionGraphRepository(repository, OntModelFactory::createUnionGraph, n -> OntModelFactory.createOntGraph(n, repository), true);
        if (!ontUnionGraphRepository.contains(name)) {
            return null;
        }
        UnionGraph union = ontUnionGraphRepository.get(name);
        ReasonerFactory reasonerFactory = spec.getReasonerFactory();
        if (reasonerFactory == null) {
            return new OntGraphModelImpl(union, spec.getPersonality());
        }
        InfGraph inf = reasonerFactory.create(null).bind((Graph)union);
        return new OntGraphModelImpl(inf, spec.getPersonality());
    }

    public static Graph createOntGraph(Node name, GraphRepository repository) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(repository);
        Graph res = repository instanceof PersistentGraphRepository ? ((PersistentGraphRepository)repository).getGraphMaker().createGraph(name.toString()) : OntModelFactory.createDefaultGraph();
        res.add(name, RDF.type.asNode(), OWL2.Ontology.asNode());
        return res;
    }

    static {
        OntModelFactory.init();
    }
}

