/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.ctl.JsonDescription;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.ValidString;
import org.apache.jena.fuseki.server.Validators;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.system.G;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;

public class ActionDatasets
extends ActionContainerItem {
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabaseTDB1 = "tdb";
    private static final String tDatabaseTDB2 = "tdb2";
    private static final String tDatabaseMem = "mem";
    private static Map<String, String> dbTypeToTemplate = new HashMap<String, String>();
    private static final String NL = "\n";
    private static final String queryStringLocations = "PREFIX tdb1:   <http://jena.hpl.hp.com/2008/tdb#>\nPREFIX tdb2:   <http://jena.apache.org/2016/tdb#>\nSELECT * {\n   ?x ( tdb2:location | tdb1:location) ?location\n}\n";
    private static final Query queryLocations;

    public void validate(HttpAction action) {
    }

    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets((JsonBuilder)builder, (DataAccessPointRegistry)action.getDataAccessPointRegistry());
        builder.finishObject("D");
        return builder.build();
    }

    protected JsonValue execGetItem(HttpAction action) {
        String item = ActionDatasets.getItemDatasetName((HttpAction)action);
        action.log.info(String.format("[%d] GET dataset %s", action.id, item));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = ActionDatasets.getItemDataAccessPoint((HttpAction)action, (String)item);
        if (dsDesc == null) {
            ServletOps.errorNotFound((String)("Not found: dataset " + item));
        }
        JsonDescription.describe((JsonBuilder)builder, (DataAccessPoint)dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonValue execPostContainer(HttpAction action) {
        UUID uuid = UUID.randomUUID();
        ContentType ct = ActionLib.getContentType((HttpAction)action);
        boolean hasParams = action.getRequestParameterNames().hasMoreElements();
        if (ct == null && !hasParams) {
            ServletOps.errorBadRequest((String)"Bad request - Content-Type or both parameters dbName and dbType required");
        }
        boolean succeeded = false;
        String configFile = null;
        String systemFileCopy = null;
        DatasetDescriptionMap registry = new DatasetDescriptionMap();
        Object object = FusekiWebapp.systemLock;
        synchronized (object) {
            block36: {
                block37: {
                    DataAccessPoint dataAccessPoint;
                    String datasetPath;
                    Model model;
                    block33: {
                        String tdbLocation2222;
                        block34: {
                            block35: {
                                try {
                                    String datasetName;
                                    boolean templatedRequest;
                                    Model modelFromRequest;
                                    block32: {
                                        modelFromRequest = ModelFactory.createDefaultModel();
                                        StreamRDF dest = StreamRDFLib.graph((Graph)modelFromRequest.getGraph());
                                        templatedRequest = false;
                                        try {
                                            if (hasParams || WebContent.isHtmlForm((ContentType)ct)) {
                                                ActionDatasets.assemblerFromForm(action, dest);
                                                templatedRequest = true;
                                                break block32;
                                            }
                                            if (WebContent.isMultiPartForm((ContentType)ct)) {
                                                ServletOps.errorBadRequest((String)"Service configuration from a multipart upload not supported");
                                            } else {
                                                if (!FusekiWebapp.allowConfigFiles()) {
                                                    ServletOps.errorBadRequest((String)"Service configuration from an upload file not supported");
                                                }
                                                ActionDatasets.assemblerFromBody(action, dest);
                                            }
                                        }
                                        catch (RiotException ex) {
                                            ActionLib.consumeBody((HttpAction)action);
                                            action.log.warn(String.format("[%d] Failed to read configuration: %s", action.id, ex.getMessage()));
                                            ServletOps.errorBadRequest((String)"Failed to read configuration");
                                        }
                                    }
                                    model = ModelFactory.createDefaultModel();
                                    model.add(modelFromRequest);
                                    model = AssemblerUtils.prepareForAssembler((Model)model);
                                    Statement stmt = this.findService(model);
                                    if (stmt == null) {
                                        action.log.warn(String.format("[%d] No service name", action.id));
                                        ServletOps.errorBadRequest((String)String.format("No service name", new Object[0]));
                                    }
                                    Resource subject = stmt.getSubject();
                                    Literal object2 = stmt.getObject().asLiteral();
                                    if (object2.getDatatype() != null && !object2.getDatatype().equals(XSDDatatype.XSDstring)) {
                                        action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode((RDFNode)object2)));
                                    }
                                    if ((datasetName = object2.getLexicalForm()).isEmpty()) {
                                        action.log.warn(String.format("[%d] Empty dataset name", action.id));
                                        ServletOps.errorBadRequest((String)"Empty dataset name");
                                    }
                                    if (StringUtils.isBlank((CharSequence)datasetName)) {
                                        action.log.warn(String.format("[%d] Whitespace dataset name: '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest((String)String.format("Whitespace dataset name: '%s'", datasetName));
                                    }
                                    if (datasetName.contains(" ")) {
                                        action.log.warn(String.format("[%d] Bad dataset name (contains spaces) '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest((String)String.format("Bad dataset name (contains spaces) '%s'", datasetName));
                                    }
                                    if (datasetName.equals("/")) {
                                        action.log.warn(String.format("[%d] Bad dataset name '%s'", action.id, datasetName));
                                        ServletOps.errorBadRequest((String)String.format("Bad dataset name '%s'", datasetName));
                                    }
                                    try {
                                        ValidString validString = Validators.serviceName((String)datasetName);
                                    }
                                    catch (FusekiConfigException ex) {
                                        action.log.warn(String.format("[%d] Invalid service name: '%s'", action.id, datasetName));
                                        ServletOps.error((int)400, (String)String.format("Invalid service name: '%s'", datasetName));
                                    }
                                    datasetPath = DataAccessPoint.canonical((String)datasetName);
                                    if (!this.isValidServiceName(datasetPath)) {
                                        action.log.warn(String.format("[%d] Database service name not acceptable: '%s'", action.id, datasetName));
                                        ServletOps.error((int)400, (String)String.format("Database service name not acceptable: '%s'", datasetName));
                                    }
                                    if (action.getDataAccessPointRegistry().isRegistered((Object)datasetPath)) {
                                        action.log.warn(String.format("[%d] Name already registered '%s'", action.id, datasetPath));
                                        ServletOps.error((int)409, (String)String.format("Name already registered '%s'", datasetPath));
                                    }
                                    if (!templatedRequest) {
                                        List<String> tdbLocations = ActionDatasets.tdbLocations(action, model.getGraph());
                                        for (String tdbLocation2222 : tdbLocations) {
                                            if (this.isValidTDBLocation(tdbLocation2222)) continue;
                                            action.log.warn(String.format("[%d] TDB database location not acceptable: '%s'", action.id, tdbLocation2222));
                                            ServletOps.error((int)400, (String)String.format("TDB database location not acceptable: '%s'", tdbLocation2222));
                                        }
                                    }
                                    systemFileCopy = FusekiWebapp.dirSystemFileArea.resolve(uuid.toString()).toString();
                                    RDFWriter.source((Model)model).lang(Lang.TURTLE).output(systemFileCopy);
                                    action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
                                    List<String> existing = FusekiWebapp.existingConfigurationFile(datasetPath);
                                    if (!existing.isEmpty()) {
                                        ServletOps.error((int)409, (String)("Configuration file for '" + datasetPath + "' already exists"));
                                    }
                                    configFile = FusekiWebapp.generateConfigurationFilename(datasetPath);
                                    dataAccessPoint = FusekiConfig.buildDataAccessPoint((Graph)subject.getModel().getGraph(), (Node)subject.asNode(), (DatasetDescriptionMap)registry);
                                    if (dataAccessPoint != null) break block33;
                                    FmtLog.error((Logger)action.log, (String)"Failed to build DataAccessPoint: datasetPath = %s; DataAccessPoint name = %s", (Object[])new Object[]{datasetPath, dataAccessPoint});
                                    ServletOps.errorBadRequest((String)"Failed to build DataAccessPoint");
                                    tdbLocation2222 = null;
                                    if (succeeded) break block34;
                                    if (systemFileCopy == null) break block35;
                                }
                                catch (Throwable throwable) {
                                    if (!succeeded) {
                                        if (systemFileCopy != null) {
                                            FileOps.deleteSilent(systemFileCopy);
                                        }
                                        if (configFile != null) {
                                            FileOps.deleteSilent(configFile);
                                        }
                                    }
                                    throw throwable;
                                }
                                FileOps.deleteSilent((String)systemFileCopy);
                            }
                            if (configFile != null) {
                                FileOps.deleteSilent((String)configFile);
                            }
                        }
                        return tdbLocation2222;
                    }
                    dataAccessPoint.getDataService().setEndpointProcessors(action.getOperationRegistry());
                    RDFWriter.source((Model)model).lang(Lang.TURTLE).output(configFile);
                    if (!datasetPath.equals(dataAccessPoint.getName())) {
                        FmtLog.warn((Logger)action.log, (String)"Inconsistent names: datasetPath = %s; DataAccessPoint name = %s", (Object[])new Object[]{datasetPath, dataAccessPoint});
                    }
                    dataAccessPoint.getDataService().goActive();
                    succeeded = true;
                    action.getDataAccessPointRegistry().register(dataAccessPoint);
                    MetricsProvider metricProvider = action.getMetricsProvider();
                    if (metricProvider != null) {
                        action.getMetricsProvider().addDataAccessPointMetrics(dataAccessPoint);
                    }
                    action.setResponseContentType("text/plain");
                    ServletOps.success((HttpAction)action);
                    if (succeeded) break block36;
                    if (systemFileCopy == null) break block37;
                    FileOps.deleteSilent((String)systemFileCopy);
                }
                if (configFile != null) {
                    FileOps.deleteSilent((String)configFile);
                }
            }
            return null;
        }
    }

    private boolean isValidServiceName(String datasetPath) {
        int idx = datasetPath.indexOf(47, 1);
        if (idx > 0) {
            return false;
        }
        return !datasetPath.startsWith("/..");
    }

    private boolean isValidTDBLocation(String tdbLocation) {
        List components;
        Location location = Location.create((String)tdbLocation);
        if (location.isMem()) {
            return true;
        }
        String locationString = location.getDirectoryPath();
        return !locationString.startsWith("..") && !locationString.contains("/..") || !(components = FileOps.pathComponents((String)locationString)).contains("..");
    }

    private Statement findService(Model model) {
        Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
        if (stmt == null) {
            Statement stmt3;
            Statement stmt2 = ActionDatasets.getOne(model, null, RDF.type, (RDFNode)FusekiVocab.fusekiService);
            if (stmt2 == null) {
                int count = model.listStatements(null, RDF.type, (RDFNode)FusekiVocab.fusekiService).toList().size();
                if (count == 0) {
                    ServletOps.errorBadRequest((String)"No triple rdf:type fuseki:Service found");
                } else {
                    ServletOps.errorBadRequest((String)"Multiple Fuseki service descriptions");
                }
            }
            if ((stmt3 = ActionDatasets.getOne(model, stmt2.getSubject(), pServiceName, null)) == null) {
                StmtIterator sIter = model.listStatements(stmt2.getSubject(), pServiceName, (RDFNode)null);
                if (!sIter.hasNext()) {
                    ServletOps.errorBadRequest((String)"No name given in description of Fuseki service");
                }
                sIter.next();
                if (sIter.hasNext()) {
                    ServletOps.errorBadRequest((String)"Multiple names given in description of Fuseki service");
                }
                throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
            }
            stmt = stmt3;
        }
        if (stmt == null) {
            return null;
        }
        if (!stmt.getObject().isLiteral()) {
            ServletOps.errorBadRequest((String)("Found " + FmtUtils.stringForRDFNode((RDFNode)stmt.getObject()) + " : Service names are strings, which are then used to build the external URI"));
        }
        return stmt;
    }

    protected JsonValue execPostItem(HttpAction action) {
        String s;
        DataService dSrv;
        String name = ActionDatasets.getItemDatasetName((HttpAction)action);
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        DataAccessPoint dap = ActionDatasets.getItemDataAccessPoint((HttpAction)action, (String)name);
        if (dap == null) {
            ServletOps.errorNotFound((String)("Not found: dataset " + name));
        }
        if ((dSrv = dap.getDataService()) == null) {
            dSrv = action.getDataAccessPoint().getDataService();
        }
        if ((s = action.getRequestParameter("state")) == null || s.isEmpty()) {
            ServletOps.errorBadRequest((String)"No state change given");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execDeleteItem(HttpAction action) {
        String name = ActionDatasets.getItemDatasetName((HttpAction)action);
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE dataset=%s", action.id, name));
        if (!action.getDataAccessPointRegistry().isRegistered((Object)name)) {
            ServletOps.errorNotFound((String)("No such dataset registered: " + name));
        }
        boolean succeeded = false;
        Object object = FusekiWebapp.systemLock;
        synchronized (object) {
            String filename;
            Path pDatabase;
            DataAccessPoint ref = action.getDataAccessPointRegistry().get(name);
            if (ref == null) {
                ServletOps.errorNotFound((String)("No such dataset registered: " + name));
            }
            DataService dataService = ref.getDataService();
            action.getDataAccessPointRegistry().remove((Object)name);
            List<String> configurationFiles = FusekiWebapp.existingConfigurationFile(name);
            if (configurationFiles.isEmpty()) {
                action.log.warn(String.format("[%d] Can't delete database configuration - not a managed database", action.id, name));
                succeeded = true;
                ServletOps.success((HttpAction)action);
                return;
            }
            if (configurationFiles.size() > 1) {
                action.log.warn(String.format("[%d] There are %d configuration files, not one.", action.id, configurationFiles.size()));
                ServletOps.errorOccurred((String)String.format("There are %d configuration files, not one. Delete not performed; manual clean up of the filesystem needed.", configurationFiles.size()));
                return;
            }
            String cfgPathname = configurationFiles.get(0);
            FileOps.deleteSilent((String)cfgPathname);
            boolean isTDB1 = TDBInternal.isTDB1((DatasetGraph)dataService.getDataset());
            boolean isTDB2 = org.apache.jena.tdb2.sys.TDBInternal.isTDB2((DatasetGraph)dataService.getDataset());
            try {
                dataService.shutdown();
            }
            catch (JenaException ex) {
                return;
            }
            if ((isTDB1 || isTDB2) && Files.exists(pDatabase = FusekiWebapp.dirDatabases.resolve(filename = name.startsWith("/") ? name.substring(1) : name), new LinkOption[0])) {
                try {
                    if (Files.isSymbolicLink(pDatabase)) {
                        action.log.info(String.format("[%d] Database is a symbolic link, not removing files", action.id, pDatabase));
                    } else {
                        IO.deleteAll((Path)pDatabase);
                        action.log.info(String.format("[%d] Deleted database files %s", action.id, pDatabase));
                    }
                }
                catch (RuntimeIOException ex) {
                    action.log.error(String.format("[%d] Error while deleting database files %s: %s", action.id, pDatabase, ex.getMessage()), (Throwable)ex);
                }
            }
            succeeded = true;
            ServletOps.success((HttpAction)action);
        }
    }

    private static void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private static void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String dbType = action.getRequestParameter(paramDatasetType);
        String dbName = action.getRequestParameter(paramDatasetName);
        if (StringUtils.isBlank((CharSequence)dbType) || StringUtils.isBlank((CharSequence)dbName)) {
            action.log.warn(String.format("[%d] Both parameters 'dbName' and 'dbType' required and not be blank", action.id));
            ServletOps.errorBadRequest((String)"Received HTML form. Both parameters 'dbName' and 'dbType' required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (dbName.startsWith("/")) {
            params.put("NAME", dbName.substring(1));
        } else {
            params.put("NAME", dbName);
        }
        params.put("NAME", dbName);
        FusekiWebapp.addGlobals(params);
        String template = dbTypeToTemplate.get(dbType.toLowerCase(Locale.ROOT));
        if (template == null) {
            ArrayList<String> keys = new ArrayList<String>(dbTypeToTemplate.keySet());
            Collections.sort(keys);
            ServletOps.errorBadRequest((String)String.format("dbType can be only one of %s", keys));
        }
        String instance = TemplateFunctions.templateFile(template, params, Lang.TTL);
        RDFParser.create().source(new StringReader(instance)).base("http://base/").lang(Lang.TTL).parse(dest);
    }

    private static void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        throw new NotImplemented();
    }

    private static Quad getOne(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator iter = dsg.findNG(g, s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Quad q = (Quad)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return q;
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.getRequest();
        String base = ActionLib.wholeRequestURL((HttpServletRequest)request);
        ContentType ct = FusekiNetLib.getContentType((HttpServletRequest)request);
        Lang lang = RDFLanguages.contentTypeToLang((String)ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest((String)("Unknown content type for triples: " + String.valueOf(ct)));
            return;
        }
        dest.prefix("root", base + "#");
        ActionLib.parse((HttpAction)action, (StreamRDF)dest, (Lang)lang, (String)base);
    }

    private static List<String> tdbLocations(HttpAction action, Graph configGraph) {
        ArrayList<String> arrayList;
        block8: {
            QueryExec exec = QueryExec.graph((Graph)configGraph).query(queryLocations).build();
            try {
                RowSet results = exec.select();
                ArrayList<String> locations = new ArrayList<String>();
                results.forEach(b -> {
                    String location;
                    Node loc = b.get("location");
                    if (loc.isURI()) {
                        location = loc.getURI();
                    } else if (Util.isSimpleString((Node)loc)) {
                        location = G.asString((Node)loc);
                    } else {
                        ServletOps.errorBadRequest((String)"TDB database location is not a string");
                        location = null;
                    }
                    locations.add(location);
                });
                arrayList = locations;
                if (exec == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (exec != null) {
                        try {
                            exec.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ServletOps.errorBadRequest((String)"TDB database location can not be deterined");
                    return null;
                }
            }
            exec.close();
        }
        return arrayList;
    }

    static {
        dbTypeToTemplate.put(tDatabaseTDB1, "templates/config-tdb");
        dbTypeToTemplate.put(tDatabaseTDB2, "templates/config-tdb2");
        dbTypeToTemplate.put(tDatabaseMem, "templates/config-mem");
        queryLocations = QueryFactory.create((String)queryStringLocations);
    }
}

