/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.cmd.FusekiArgs;
import org.apache.jena.fuseki.mgt.Template;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.FusekiCore;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdfs.RDFSFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;

public class FusekiWebapp {
    public static final String runArea = "run";
    public static final String databasesLocationBase = "databases";
    public static final String backupDirNameBase = "backups";
    public static final String configDirNameBase = "configuration";
    public static final String logsNameBase = "logs";
    public static final String systemDatabaseNameBase = "system";
    public static final String systemFileAreaBase = "system_files";
    public static final String templatesNameBase = "templates";
    public static final String DFT_SHIRO_INI = "shiro.ini";
    public static final String DFT_CONFIG = "config.ttl";
    public static Path dirDatabases = null;
    public static Path dirBackups = null;
    public static Path dirConfiguration = null;
    public static Path dirLogs = null;
    public static Path dirSystemDatabase = null;
    public static Path dirSystemFileArea = null;
    public static Path dirTemplates = null;
    private static boolean initialized = false;
    static boolean serverInitialized = false;

    public static synchronized void formatBaseArea() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            FusekiEnv.setEnvironment();
            Path FUSEKI_HOME = FusekiEnv.FUSEKI_HOME;
            Path FUSEKI_BASE = FusekiEnv.FUSEKI_BASE;
            JenaSystem.init();
            FusekiCore.init();
            Fuseki.configLog.info("FUSEKI_HOME=" + (FUSEKI_HOME == null ? "unset" : FUSEKI_HOME.toString()));
            Fuseki.configLog.info("FUSEKI_BASE=" + FUSEKI_BASE.toString());
            if (FUSEKI_HOME != null) {
                if (!Files.isDirectory(FUSEKI_HOME, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_HOME is not a directory: " + String.valueOf(FUSEKI_HOME));
                }
                if (!Files.isReadable(FUSEKI_HOME)) {
                    throw new FusekiConfigException("FUSEKI_HOME is not readable: " + String.valueOf(FUSEKI_HOME));
                }
            }
            if (Files.exists(FUSEKI_BASE, new LinkOption[0])) {
                if (!Files.isDirectory(FUSEKI_BASE, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_BASE is not a directory: " + String.valueOf(FUSEKI_BASE));
                }
                if (!Files.isWritable(FUSEKI_BASE)) {
                    throw new FusekiConfigException("FUSEKI_BASE is not writable: " + String.valueOf(FUSEKI_BASE));
                }
            } else {
                FusekiWebapp.ensureDir(FUSEKI_BASE);
            }
            dirTemplates = FusekiWebapp.writeableDirectory(FUSEKI_BASE, templatesNameBase);
            dirDatabases = FusekiWebapp.writeableDirectory(FUSEKI_BASE, databasesLocationBase);
            dirBackups = FusekiWebapp.writeableDirectory(FUSEKI_BASE, backupDirNameBase);
            dirConfiguration = FusekiWebapp.writeableDirectory(FUSEKI_BASE, configDirNameBase);
            dirLogs = FusekiWebapp.writeableDirectory(FUSEKI_BASE, logsNameBase);
            dirSystemDatabase = FusekiWebapp.writeableDirectory(FUSEKI_BASE, systemDatabaseNameBase);
            dirSystemFileArea = FusekiWebapp.writeableDirectory(FUSEKI_BASE, systemFileAreaBase);
            if (Files.isRegularFile(FUSEKI_BASE, new LinkOption[0])) {
                throw new FusekiConfigException("FUSEKI_BASE exists but is a file");
            }
            FusekiWebapp.copyFileIfMissing(null, DFT_SHIRO_INI, FUSEKI_BASE);
            FusekiWebapp.copyFileIfMissing(null, DFT_CONFIG, FUSEKI_BASE);
            for (String n : Template.templateNames) {
                FusekiWebapp.copyFileIfMissing(null, n, FUSEKI_BASE);
            }
            serverInitialized = true;
        }
        catch (RuntimeException ex) {
            Fuseki.serverLog.error("Exception in server initialization", (Throwable)ex);
            throw ex;
        }
    }

    private static void copyFileIfMissing(Path src, String fn, Path dst) {
        Path dstFile = dst.resolve(fn);
        if (Files.exists(dstFile, new LinkOption[0])) {
            return;
        }
        if (src != null) {
            try {
                Files.copy(src.resolve(fn), dstFile, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e) {
                IO.exception((String)("Failed to copy file " + String.valueOf(src.resolve(fn))), (IOException)e);
                e.printStackTrace();
            }
        } else {
            FusekiWebapp.copyFileFromResource(fn, dstFile);
        }
    }

    public static void copyFileFromResource(String fn, Path dstFile) {
        try {
            URL url = FusekiWebapp.class.getResource(fn);
            if (url == null) {
                throw new FusekiConfigException("Failed to find resource '" + fn + "'");
            }
            InputStream in = url.openStream();
            Files.copy(in, dstFile, new CopyOption[0]);
        }
        catch (IOException e) {
            IO.exception((String)("Failed to copy file from resource: " + fn), (IOException)e);
            e.printStackTrace();
        }
    }

    public static void initializeDataAccessPoints(DataAccessPointRegistry registry, FusekiArgs initialSetup, String configDir) {
        List<DataAccessPoint> configFileDBs = FusekiWebapp.initServerConfiguration(initialSetup);
        List directoryDBs = FusekiConfig.readConfigurationDirectory((String)configDir);
        ArrayList<DataAccessPoint> datapoints = new ArrayList<DataAccessPoint>();
        datapoints.addAll(configFileDBs);
        datapoints.addAll(directoryDBs);
        datapoints.forEach(arg_0 -> ((DataAccessPointRegistry)registry).register(arg_0));
    }

    private static List<DataAccessPoint> initServerConfiguration(FusekiArgs params) {
        ArrayList<DataAccessPoint> datasets = new ArrayList<DataAccessPoint>();
        if (params == null) {
            return datasets;
        }
        if (params.fusekiCmdLineConfigFile != null) {
            List<DataAccessPoint> confDatasets = FusekiWebapp.processServerConfigFile(params.fusekiCmdLineConfigFile);
            datasets.addAll(confDatasets);
        } else if (params.fusekiServerConfigFile != null) {
            List<DataAccessPoint> confDatasets = FusekiWebapp.processServerConfigFile(params.fusekiServerConfigFile);
            datasets.addAll(confDatasets);
        } else if (params.dsg != null) {
            if (params.rdfsGraph != null) {
                Graph rdfsGraph = RDFDataMgr.loadGraph((String)params.rdfsGraph);
                params.dsg = RDFSFactory.datasetRDFS((DatasetGraph)params.dsg, (Graph)rdfsGraph);
            }
            DataAccessPoint dap = FusekiWebapp.datasetDefaultConfiguration(params.datasetPath, params.dsg, params.allowUpdate);
            datasets.add(dap);
        } else if (params.templateFile != null) {
            DataAccessPoint dap = FusekiWebapp.configFromTemplate(params.templateFile, params.datasetPath, params.allowUpdate, params.params);
            if (params.rdfsGraph != null) {
                DataService dSrv = dap.getDataService();
                DatasetGraph dsg = dSrv.getDataset();
                Graph rdfsGraph = RDFDataMgr.loadGraph((String)params.rdfsGraph);
                DatasetGraph dsg2 = RDFSFactory.datasetRDFS((DatasetGraph)dsg, (Graph)rdfsGraph);
                DataService dSrv2 = DataService.newBuilder((DataService)dSrv).dataset(dsg2).build();
                dap = new DataAccessPoint(dap.getName(), dSrv2);
            }
            datasets.add(dap);
        }
        return datasets;
    }

    private static List<DataAccessPoint> processServerConfigFile(String configFilename) {
        if (!FileOps.exists((String)configFilename)) {
            Fuseki.configLog.warn("Configuration file '" + configFilename + "' does not exist");
            return Collections.emptyList();
        }
        Model model = AssemblerUtils.readAssemblerFile((String)configFilename);
        if (model.size() == 0L) {
            return Collections.emptyList();
        }
        List x = FusekiConfig.processServerConfiguration((Model)model, (Context)Fuseki.getContext());
        return x;
    }

    private static DataAccessPoint configFromTemplate(String templateFile, String datasetPath, boolean allowUpdate, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("NAME", datasetPath);
        } else if (!params.containsKey("NAME")) {
            Fuseki.configLog.warn("No NAME found in template parameters (added)");
            params.put("NAME", datasetPath);
        }
        Fuseki.configLog.info("Template file: " + templateFile);
        String dir = params.get("DIR");
        if (dir != null && !Objects.equals(dir, "--mem--") && !FileOps.exists((String)dir)) {
            throw new CmdException("Directory not found: " + dir);
        }
        datasetPath = DataAccessPoint.canonical((String)datasetPath);
        FusekiWebapp.addGlobals(params);
        String str = TemplateFunctions.templateFile(templateFile, params, Lang.TTL);
        Lang lang = RDFLanguages.filenameToLang((String)templateFile, (Lang)Lang.TTL);
        Model model = RDFParser.fromString((String)str, (Lang)lang).base(datasetPath).toModel();
        List defns = FusekiConfig.servicesAndDatasets((Graph)model.getGraph());
        if (defns.size() != 1) {
            if (defns.isEmpty()) {
                ServletOps.errorBadRequest((String)"No description of a Fuseki service");
            } else {
                ServletOps.errorBadRequest((String)"Multiple descriptions of Fuseki service");
            }
        }
        DataAccessPoint dap = (DataAccessPoint)defns.get(0);
        return dap;
    }

    public static void addGlobals(Map<String, String> params) {
        if (params == null) {
            Fuseki.configLog.warn("FusekiServer.addGlobals : params is null", new Throwable());
            return;
        }
        if (!params.containsKey("FUSEKI_BASE")) {
            params.put("FUSEKI_BASE", FusekiWebapp.pathStringOrElse(FusekiEnv.FUSEKI_BASE, "unset"));
        }
        if (!params.containsKey("FUSEKI_HOME")) {
            params.put("FUSEKI_HOME", FusekiWebapp.pathStringOrElse(FusekiEnv.FUSEKI_HOME, "unset"));
        }
    }

    private static String pathStringOrElse(Path path, String dft) {
        if (path == null) {
            return dft;
        }
        return path.toString();
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static DataAccessPoint datasetDefaultConfiguration(String name, DatasetGraph dsg, boolean allowUpdate) {
        name = DataAccessPoint.canonical((String)name);
        DataService ds = FusekiConfig.buildDataServiceStd((DatasetGraph)dsg, (boolean)allowUpdate);
        DataAccessPoint dap = new DataAccessPoint(name, ds);
        return dap;
    }

    private static void ensureDir(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new FusekiConfigException("Failed to create directory: " + String.valueOf(directory));
            }
        } else if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + String.valueOf(directory));
        }
    }

    private static void mustExist(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            throw new FusekiConfigException("Does not exist: " + String.valueOf(directory));
        }
        if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + String.valueOf(directory));
        }
    }

    private static boolean emptyDir(Path dir) {
        return dir.toFile().list().length <= 2;
    }

    private static boolean exists(Path directory) {
        File dir = directory.toFile();
        return dir.exists();
    }

    private static Path writeableDirectory(Path root, String relName) {
        Path p = FusekiWebapp.makePath(root, relName);
        FusekiWebapp.ensureDir(p);
        if (!Files.isWritable(p)) {
            throw new FusekiConfigException("Not writable: " + String.valueOf(p));
        }
        return p;
    }

    private static Path makePath(Path root, String relName) {
        Path path = root.resolve(relName);
        return path;
    }

    public static String datasetNameToConfigurationFile(HttpAction action, String dsName) {
        List<String> existing = FusekiWebapp.existingConfigurationFile(dsName);
        if (!existing.isEmpty()) {
            if (existing.size() > 1) {
                action.log.warn(String.format("[%d] Multiple existing configuration files for %s : %s", action.id, dsName, existing));
                ServletOps.errorBadRequest((String)("Multiple existing configuration files for " + dsName));
                return null;
            }
            return existing.get(0).toString();
        }
        return FusekiWebapp.generateConfigurationFilename(dsName);
    }

    public static String generateConfigurationFilename(String dsName) {
        String filename = dsName;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        Path p = dirConfiguration.resolve(filename + ".ttl");
        return p.toString();
    }

    public static List<String> existingConfigurationFile(String baseFilename) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirConfiguration, baseFilename + ".*");){
                stream.forEach(p -> paths.add(dirConfiguration.resolve((Path)p).toString()));
            }
            return paths;
        }
        catch (IOException ex) {
            throw new InternalErrorException("Failed to read configuration directory " + String.valueOf(dirConfiguration));
        }
    }
}

