/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.ctl.JsonDescription;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.DataUploader;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;

public class ActionDatasets
extends ActionContainerItem {
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabaseTDB = "tdb";
    private static final String tDatabaseTDB1 = "tdb1";
    private static final String tDatabaseTDB2 = "tdb2";
    private static final String tDatabaseMem = "mem";
    private static final Object lock = new Object();
    private static Map<String, String> dbTypeToTemplate = Map.of("tdb", "templates/config-tdb2", "tdb1", "templates/config-tdb", "tdb2", "templates/config-tdb2", "mem", "templates/config-mem");

    public void validate(HttpAction action) {
    }

    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets((JsonBuilder)builder, (DataAccessPointRegistry)action.getDataAccessPointRegistry());
        builder.finishObject("D");
        return builder.build();
    }

    protected JsonValue execGetItem(HttpAction action) {
        String item = ActionDatasets.getItemDatasetName((HttpAction)action);
        action.log.info(String.format("[%d] GET dataset %s", action.id, item));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = ActionDatasets.getItemDataAccessPoint((HttpAction)action, (String)item);
        if (dsDesc == null) {
            ServletOps.errorNotFound((String)("Not found: dataset " + item));
        }
        JsonDescription.describe((JsonBuilder)builder, (DataAccessPoint)dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonValue execPostContainer(HttpAction action) {
        UUID uuid = UUID.randomUUID();
        DatasetDescriptionMap registry = new DatasetDescriptionMap();
        ContentType ct = ActionLib.getContentType((HttpAction)action);
        boolean hasParams = action.getRequestParameterNames().hasMoreElements();
        if (ct == null && !hasParams) {
            ServletOps.errorBadRequest((String)"Bad request - Content-Type or both parameters dbName and dbType required");
        }
        boolean committed = false;
        Object object = lock;
        synchronized (object) {
            block43: {
                String configFile;
                String systemFileCopy;
                block42: {
                    JsonValue jsonValue;
                    block40: {
                        block41: {
                            systemFileCopy = null;
                            configFile = null;
                            try {
                                String datasetName;
                                Model modelData = ModelFactory.createDefaultModel();
                                StreamRDF dest = StreamRDFLib.graph((Graph)modelData.getGraph());
                                if (hasParams || WebContent.isHtmlForm((ContentType)ct)) {
                                    ActionDatasets.assemblerFromForm(action, dest);
                                } else if (WebContent.isMultiPartForm((ContentType)ct)) {
                                    ActionDatasets.assemblerFromUpload(action, dest);
                                } else {
                                    ActionDatasets.assemblerFromBody(action, dest);
                                }
                                systemFileCopy = FusekiWebapp.dirSystemFileArea.resolve(uuid.toString()).toString();
                                try (OutputStream outCopy = IO.openOutputFile((String)systemFileCopy);){
                                    RDFDataMgr.write((OutputStream)outCopy, (Model)modelData, (Lang)Lang.TURTLE);
                                }
                                Model model = ModelFactory.createDefaultModel();
                                model.add(modelData);
                                model = AssemblerUtils.prepareForAssembler((Model)model);
                                Statement stmt = this.findService(model);
                                Resource subject = stmt.getSubject();
                                Literal object2 = stmt.getObject().asLiteral();
                                if (object2.getDatatype() != null && !object2.getDatatype().equals(XSDDatatype.XSDstring)) {
                                    action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode((RDFNode)object2)));
                                }
                                if ((datasetName = object2.getLexicalForm()).isEmpty()) {
                                    ServletOps.error((int)400, (String)"Empty dataset name");
                                }
                                if (StringUtils.isBlank((CharSequence)datasetName)) {
                                    ServletOps.error((int)400, (String)String.format("Whitespace dataset name: '%s'", datasetName));
                                }
                                if (datasetName.contains(" ")) {
                                    ServletOps.error((int)400, (String)String.format("Bad dataset name (contains spaces) '%s'", datasetName));
                                }
                                if (datasetName.equals("/")) {
                                    ServletOps.error((int)400, (String)String.format("Bad dataset name '%s'", datasetName));
                                }
                                String datasetPath = DataAccessPoint.canonical((String)datasetName);
                                if (action.getDataAccessPointRegistry().isRegistered((Object)datasetPath)) {
                                    ServletOps.error((int)409, (String)("Name already registered " + datasetPath));
                                }
                                action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
                                configFile = FusekiWebapp.generateConfigurationFilename(datasetPath);
                                List<String> existing = FusekiWebapp.existingConfigurationFile(datasetPath);
                                if (!existing.isEmpty()) {
                                    ServletOps.error((int)409, (String)("Configuration file for '" + datasetPath + "' already exists"));
                                }
                                try (OutputStream outCopy = IO.openOutputFile((String)configFile);){
                                    RDFDataMgr.write((OutputStream)outCopy, (Model)modelData, (Lang)Lang.TURTLE);
                                }
                                DataAccessPoint dataAccessPoint = FusekiConfig.buildDataAccessPoint((Graph)subject.getModel().getGraph(), (Node)subject.asNode(), (DatasetDescriptionMap)registry);
                                if (dataAccessPoint == null) {
                                    FmtLog.error((Logger)action.log, (String)"Failed to build DataAccessPoint: datasetPath = %s; DataAccessPoint name = %s", (Object[])new Object[]{datasetPath, dataAccessPoint});
                                    ServletOps.errorBadRequest((String)"Failed to build DataAccessPoint");
                                    jsonValue = null;
                                    if (committed) return jsonValue;
                                    if (systemFileCopy == null) break block40;
                                    break block41;
                                }
                                dataAccessPoint.getDataService().setEndpointProcessors(action.getOperationRegistry());
                                dataAccessPoint.getDataService().goActive();
                                if (!datasetPath.equals(dataAccessPoint.getName())) {
                                    FmtLog.warn((Logger)action.log, (String)"Inconsistent names: datasetPath = %s; DataAccessPoint name = %s", (Object[])new Object[]{datasetPath, dataAccessPoint});
                                }
                                action.getDataAccessPointRegistry().register(dataAccessPoint);
                                action.setResponseContentType("text/plain");
                                ServletOps.success((HttpAction)action);
                                committed = true;
                                if (committed) return null;
                                break block42;
                            }
                            catch (IOException ex) {
                                IO.exception((IOException)ex);
                                break block43;
                            }
                        }
                        FileOps.deleteSilent((String)systemFileCopy);
                    }
                    if (configFile == null) return jsonValue;
                    FileOps.deleteSilent((String)configFile);
                    return jsonValue;
                }
                if (systemFileCopy != null) {
                    FileOps.deleteSilent((String)systemFileCopy);
                }
                if (configFile == null) return null;
                FileOps.deleteSilent((String)configFile);
                break block43;
                finally {
                    if (!committed) {
                        if (systemFileCopy != null) {
                            FileOps.deleteSilent(systemFileCopy);
                        }
                        if (configFile != null) {
                            FileOps.deleteSilent(configFile);
                        }
                    }
                }
            }
            return null;
        }
    }

    private Statement findService(Model model) {
        Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
        if (stmt == null) {
            Statement stmt3;
            Statement stmt2 = ActionDatasets.getOne(model, null, RDF.type, (RDFNode)FusekiVocab.fusekiService);
            if (stmt2 == null) {
                int count = model.listStatements(null, RDF.type, (RDFNode)FusekiVocab.fusekiService).toList().size();
                if (count == 0) {
                    ServletOps.errorBadRequest((String)"No triple rdf:type fuseki:Service found");
                } else {
                    ServletOps.errorBadRequest((String)"Multiple Fuseki service descriptions");
                }
            }
            if ((stmt3 = ActionDatasets.getOne(model, stmt2.getSubject(), pServiceName, null)) == null) {
                StmtIterator sIter = model.listStatements(stmt2.getSubject(), pServiceName, (RDFNode)null);
                if (!sIter.hasNext()) {
                    ServletOps.errorBadRequest((String)"No name given in description of Fuseki service");
                }
                sIter.next();
                if (sIter.hasNext()) {
                    ServletOps.errorBadRequest((String)"Multiple names given in description of Fuseki service");
                }
                throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
            }
            stmt = stmt3;
        }
        if (!stmt.getObject().isLiteral()) {
            ServletOps.errorBadRequest((String)("Found " + FmtUtils.stringForRDFNode((RDFNode)stmt.getObject()) + " : Service names are strings, then used to build the external URI"));
        }
        return stmt;
    }

    protected JsonValue execPostItem(HttpAction action) {
        String name = ActionDatasets.getItemDatasetName((HttpAction)action);
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        DataAccessPoint dap = ActionDatasets.getItemDataAccessPoint((HttpAction)action, (String)name);
        if (dap == null) {
            ServletOps.errorNotFound((String)("Not found: dataset " + name));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execDeleteItem(HttpAction action) {
        String name = ActionDatasets.getItemDatasetName((HttpAction)action);
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE dataset=%s", action.id, name));
        if (!action.getDataAccessPointRegistry().isRegistered((Object)name)) {
            ServletOps.errorNotFound((String)("No such dataset registered: " + name));
        }
        boolean committed = false;
        Object object = lock;
        synchronized (object) {
            Path pDatabase;
            DataAccessPoint ref = action.getDataAccessPointRegistry().get(name);
            if (ref == null) {
                ServletOps.errorNotFound((String)("No such dataset registered: " + name));
            }
            DataService dataService = ref.getDataService();
            action.getDataAccessPointRegistry().remove((Object)name);
            String filename = name.startsWith("/") ? name.substring(1) : name;
            List<String> configurationFiles = FusekiWebapp.existingConfigurationFile(filename);
            if (configurationFiles.isEmpty()) {
                action.log.warn(String.format("[%d] Can't delete database configuration - not a managed database; dataset=%s", action.id, name));
                committed = true;
                ServletOps.success((HttpAction)action);
                return;
            }
            if (configurationFiles.size() > 1) {
                action.log.warn(String.format("[%d] There are %d configuration files, not one.", action.id, configurationFiles.size()));
                ServletOps.errorOccurred((String)String.format("There are %d configuration files, not one. Delete not performed; manual clean up of the filesystem needed.", configurationFiles.size()));
                return;
            }
            String cfgPathname = configurationFiles.get(0);
            FileOps.deleteSilent((String)cfgPathname);
            boolean isTDB1 = TDBInternal.isTDB1((DatasetGraph)dataService.getDataset());
            boolean isTDB2 = org.apache.jena.tdb2.sys.TDBInternal.isTDB2((DatasetGraph)dataService.getDataset());
            try {
                dataService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((isTDB1 || isTDB2) && Files.exists(pDatabase = FusekiWebapp.dirDatabases.resolve(filename), new LinkOption[0])) {
                try {
                    if (Files.isSymbolicLink(pDatabase)) {
                        action.log.info(String.format("[%d] Database is a symbolic link, not removing files %s", action.id, pDatabase));
                    } else {
                        IO.deleteAll((Path)pDatabase);
                        action.log.info(String.format("[%d] Deleted database files %s", action.id, pDatabase));
                    }
                }
                catch (RuntimeIOException ex) {
                    action.log.error(String.format("[%d] Error while deleting database files %s: %s", action.id, pDatabase, ex.getMessage()), (Throwable)ex);
                }
            }
            ServletOps.success((HttpAction)action);
        }
    }

    private static void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private static void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String x = action.getRequestQueryString();
        String dbType = action.getRequestParameter(paramDatasetType);
        String dbName = action.getRequestParameter(paramDatasetName);
        if (StringUtils.isBlank((CharSequence)dbType) || StringUtils.isBlank((CharSequence)dbName)) {
            ServletOps.errorBadRequest((String)"Received HTML form.  Both parameters 'dbName' and 'dbType' required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (dbName.startsWith("/")) {
            params.put("NAME", dbName.substring(1));
        } else {
            params.put("NAME", dbName);
        }
        FusekiWebapp.addGlobals(params);
        String template = dbTypeToTemplate.get(Lib.lowercase((String)dbType));
        if (template == null) {
            ServletOps.errorBadRequest((String)String.format("dbType can be only '%s' ('%s','%s') or '%s'", tDatabaseTDB, tDatabaseTDB1, tDatabaseTDB2, tDatabaseMem));
        }
        String syntax = TemplateFunctions.templateFile(template, params, Lang.TTL);
        RDFParser.create().source(new StringReader(syntax)).base("http://base/").lang(Lang.TTL).parse(dest);
    }

    private static void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        DataUploader.incomingData((HttpAction)action, (StreamRDF)dest);
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.getRequest();
        String base = ActionLib.wholeRequestURL((HttpServletRequest)request);
        ContentType ct = FusekiNetLib.getContentType((HttpServletRequest)request);
        Lang lang = RDFLanguages.contentTypeToLang((String)ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest((String)("Unknown content type for triples: " + String.valueOf(ct)));
            return;
        }
        dest.prefix("root", base + "#");
        ActionLib.parseOrError((HttpAction)action, (StreamRDF)dest, (Lang)lang, (String)base);
    }
}

