/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.embedded;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler1;
import org.apache.jena.fuseki.mgt.ActionStats;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.FusekiFilter;
import org.apache.jena.fuseki.servlets.ServiceDispatchRegistry;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class FusekiServer {
    public final Server server;
    private int port;

    public static FusekiServer make(int port, String name, DatasetGraph dsg) {
        return FusekiServer.create().setPort(port).setLoopback(true).add(name, dsg).build();
    }

    public static Builder create() {
        return new Builder();
    }

    private FusekiServer(int port, Server server) {
        this.server = server;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return ((ServletContextHandler)this.server.getHandler()).getServletContext();
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get((ServletContext)this.getServletContext());
    }

    public ServiceDispatchRegistry getServiceDispatchRegistry() {
        return ServiceDispatchRegistry.get((ServletContext)this.getServletContext());
    }

    public FusekiServer start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
        if (this.port == 0) {
            this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        Fuseki.serverLog.info("Start Fuseki (port=" + this.port + ")");
        return this;
    }

    public void stop() {
        Fuseki.serverLog.info("Stop Fuseki (port=" + this.port + ")");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public static class Builder {
        private DataAccessPointRegistry dataAccessPoints = new DataAccessPointRegistry();
        private ServiceDispatchRegistry serviceDispatch = new ServiceDispatchRegistry(true);
        private int port = 3330;
        private boolean loopback = false;
        private boolean withStats = false;
        private boolean verbose = false;
        private List<Pair<String, HttpServlet>> other = new ArrayList<Pair<String, HttpServlet>>();
        private String contextPath = "/";
        private String staticContentDir = null;
        private SecurityHandler securityHandler = null;

        public Builder setPort(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero.");
            }
            this.port = port;
            return this;
        }

        public Builder setContextPath(String path) {
            Objects.requireNonNull(path, "path");
            this.contextPath = path;
            return this;
        }

        public Builder setLoopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder setStaticFileBase(String directory) {
            Objects.requireNonNull(directory, "directory");
            this.staticContentDir = directory;
            return this;
        }

        public Builder setSecurityHandler(SecurityHandler securityHandler) {
            Objects.requireNonNull(securityHandler, "securityHandler");
            this.securityHandler = securityHandler;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder enableStats(boolean withStats) {
            this.withStats = withStats;
            return this;
        }

        public Builder add(String name, Dataset dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph());
        }

        public Builder add(String name, DatasetGraph dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset, true);
        }

        public Builder add(String name, Dataset dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph(), allowUpdate);
        }

        public Builder add(String name, DatasetGraph dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            DataService dSrv = FusekiBuilder.buildDataServiceStd((DatasetGraph)dataset, (boolean)allowUpdate);
            return this.add(name, dSrv);
        }

        public Builder add(String name, DataService dataService) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataService, "dataService");
            return this.add$(name, dataService);
        }

        private Builder add$(String name, DataService dataService) {
            if (this.dataAccessPoints.isRegistered((Object)(name = DataAccessPoint.canonical((String)name)))) {
                throw new FusekiConfigException("Data service name already registered: " + name);
            }
            DataAccessPoint dap = new DataAccessPoint(name, dataService);
            this.dataAccessPoints.register(name, dap);
            return this;
        }

        public Builder parseConfigFile(String filename) {
            Objects.requireNonNull(filename, "filename");
            Model model = AssemblerUtils.readAssemblerFile((String)filename);
            Resource server = GraphUtils.getResourceByType((Model)model, (Resource)FusekiVocab.tServer);
            if (server != null) {
                AssemblerUtils.setContext((Resource)server, (Context)Fuseki.getContext());
            }
            List x = FusekiConfig.servicesAndDatasets((Model)model);
            x.forEach(dap -> this.add(dap.getName(), dap.getDataService()));
            return this;
        }

        public Builder addServlet(String pathSpec, HttpServlet servlet) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(servlet, "servlet");
            this.other.add((Pair<String, HttpServlet>)Pair.create((Object)pathSpec, (Object)servlet));
            return this;
        }

        public Builder registerOperation(Operation operation, ActionService handler) {
            this.registerOperation(operation, null, handler);
            return this;
        }

        public Builder registerOperation(Operation operation, String contentType, ActionService handler) {
            Objects.requireNonNull(operation, "operation");
            Objects.requireNonNull(handler, "handler");
            if (this.serviceDispatch.isRegistered(operation)) {
                throw new FusekiConfigException("Handler for operation already registered: " + operation.getName());
            }
            this.serviceDispatch.register(operation, contentType, handler);
            return this;
        }

        public Builder addOperation(String datasetName, String endpointName, Operation operation) {
            Objects.requireNonNull(datasetName, "datasetName");
            Objects.requireNonNull(endpointName, "endpointName");
            String name = DataAccessPoint.canonical((String)datasetName);
            if (!this.serviceDispatch.isRegistered(operation)) {
                throw new FusekiConfigException("Operation not registered: " + operation.getName());
            }
            if (!this.dataAccessPoints.isRegistered((Object)name)) {
                throw new FusekiConfigException("Dataset not registered: " + datasetName);
            }
            DataAccessPoint dap = (DataAccessPoint)this.dataAccessPoints.get((Object)name);
            FusekiBuilder.addServiceEP((DataService)dap.getDataService(), (Operation)operation, (String)endpointName);
            return this;
        }

        public FusekiServer build() {
            ServletContextHandler handler = this.buildServletContext(this.contextPath);
            ContextHandler.Context cxt = handler.getServletContext();
            Fuseki.setVerbose((ServletContext)cxt, (boolean)this.verbose);
            ServiceDispatchRegistry.set((ServletContext)cxt, (ServiceDispatchRegistry)new ServiceDispatchRegistry(this.serviceDispatch));
            DataAccessPointRegistry.set((ServletContext)cxt, (DataAccessPointRegistry)new DataAccessPointRegistry(this.dataAccessPoints));
            Builder.setMimeTypes(handler);
            this.servlets(handler);
            Server server = Builder.jettyServer(this.port, this.loopback);
            server.setHandler((Handler)handler);
            return new FusekiServer(this.port, server);
        }

        private ServletContextHandler buildServletContext(String contextPath) {
            if (contextPath == null || contextPath.isEmpty()) {
                contextPath = "/";
            } else if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            context.setDisplayName(Fuseki.servletRequestLogName);
            context.setErrorHandler((ErrorHandler)new FusekiErrorHandler1());
            context.setContextPath(contextPath);
            if (this.securityHandler != null) {
                context.setSecurityHandler(this.securityHandler);
            }
            return context;
        }

        private static void setMimeTypes(ServletContextHandler context) {
            MimeTypes mimeTypes = new MimeTypes();
            mimeTypes.addMimeMapping("nt", "application/n-triples");
            mimeTypes.addMimeMapping("nq", "application/n-quads");
            mimeTypes.addMimeMapping("ttl", "text/turtle;charset=utf-8");
            mimeTypes.addMimeMapping("trig", "text/trig;charset=utf-8");
            mimeTypes.addMimeMapping("rdfxml", "application/rdf+xml");
            mimeTypes.addMimeMapping("jsonld", "application/ld+json");
            mimeTypes.addMimeMapping("rj", "application/rdf+json");
            mimeTypes.addMimeMapping("rt", "application/rdf+thrift");
            mimeTypes.addMimeMapping("trdf", "application/rdf+thrift");
            mimeTypes.addMimeMapping("rq", "application/sparql-query");
            mimeTypes.addMimeMapping("ru", "application/sparql-update");
            mimeTypes.addMimeMapping("rsj", "application/sparql-results+json");
            mimeTypes.addMimeMapping("rsx", "application/sparql-results+xml");
            mimeTypes.addMimeMapping("srt", "application/sparql-results+thrift");
            mimeTypes.addMimeMapping("txt", "text/plain");
            mimeTypes.addMimeMapping("csv", "text/csv");
            mimeTypes.addMimeMapping("tsv", "text/tab-separated-values");
            context.setMimeTypes(mimeTypes);
        }

        private void servlets(ServletContextHandler context) {
            FusekiFilter ff = new FusekiFilter();
            FilterHolder h = new FilterHolder((Filter)ff);
            context.addFilter(h, "/*", null);
            this.other.forEach(p -> Builder.addServlet(context, (String)p.getLeft(), (HttpServlet)p.getRight()));
            if (this.withStats) {
                Builder.addServlet(context, "/$/stats", (HttpServlet)new ActionStats());
            }
            if (this.staticContentDir != null) {
                DefaultServlet staticServlet = new DefaultServlet();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                staticContent.setInitParameter("resourceBase", this.staticContentDir);
                context.addServlet(staticContent, "/");
            }
        }

        private static void addServlet(ServletContextHandler context, String pathspec, HttpServlet httpServlet) {
            ServletHolder sh = new ServletHolder((Servlet)httpServlet);
            context.addServlet(sh, pathspec);
        }

        private static Server jettyServer(int port, boolean loopback) {
            Server server = new Server();
            HttpConnectionFactory f1 = new HttpConnectionFactory();
            f1.getHttpConfiguration().setRequestHeaderSize(524288);
            f1.getHttpConfiguration().setOutputBufferSize(0x100000);
            if (!Fuseki.outputJettyServerHeader) {
                f1.getHttpConfiguration().setSendServerVersion(false);
            }
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
            connector.setPort(port);
            server.addConnector((Connector)connector);
            if (loopback) {
                connector.setHost("localhost");
            }
            return server;
        }
    }
}

